/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GameTask<V>
implements Future<V> {
    protected static final Logger logger = Logger.getLogger(GameTask.class.getName());
    protected final Callable<V> callable;
    protected V _result;
    protected ExecutionException _exception;
    protected boolean _cancelled;
    protected boolean _finished;
    protected final ReentrantLock _stateLock = new ReentrantLock();
    protected final Condition _finishedCondition = this._stateLock.newCondition();

    public GameTask(Callable<V> callable) {
        this.callable = callable;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this._stateLock.lock();
        try {
            if (this.isDone()) {
                boolean bl = false;
                return bl;
            }
            this._cancelled = true;
            this._finishedCondition.signalAll();
            boolean bl = true;
            return bl;
        }
        finally {
            this._stateLock.unlock();
        }
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this._stateLock.lock();
        try {
            while (!this.isDone()) {
                this._finishedCondition.await();
            }
            if (this._exception != null) {
                throw this._exception;
            }
            V v = this._result;
            return v;
        }
        finally {
            this._stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this._stateLock.lock();
        try {
            if (!this.isDone()) {
                this._finishedCondition.await(timeout, unit);
            }
            if (this._exception != null) {
                throw this._exception;
            }
            if (this._result == null) {
                throw new TimeoutException("Object not returned in time allocated.");
            }
            V v = this._result;
            return v;
        }
        finally {
            this._stateLock.unlock();
        }
    }

    @Override
    public boolean isCancelled() {
        this._stateLock.lock();
        try {
            boolean bl = this._cancelled;
            return bl;
        }
        finally {
            this._stateLock.unlock();
        }
    }

    @Override
    public boolean isDone() {
        this._stateLock.lock();
        try {
            boolean bl = this._finished || this._cancelled || this._exception != null;
            return bl;
        }
        finally {
            this._stateLock.unlock();
        }
    }

    public Callable<V> getCallable() {
        return this.callable;
    }

    public void invoke() {
        try {
            V tmpResult = this.callable.call();
            this._stateLock.lock();
            try {
                this._result = tmpResult;
                this._finished = true;
                this._finishedCondition.signalAll();
            }
            finally {
                this._stateLock.unlock();
            }
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "invoke()", "Exception", e);
            this._stateLock.lock();
            try {
                this._exception = new ExecutionException(e);
                this._finishedCondition.signalAll();
            }
            finally {
                this._stateLock.unlock();
            }
        }
    }

    public ExecutionException getExecutionException() {
        this._stateLock.lock();
        try {
            ExecutionException executionException = this._exception;
            return executionException;
        }
        finally {
            this._stateLock.unlock();
        }
    }
}

