/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util;

import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.RendererCallable;
import com.ardor3d.util.GameTask;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

public class GameTaskQueue {
    public static final String RENDER = "render";
    public static final String UPDATE = "update";
    private final ConcurrentLinkedQueue<GameTask<?>> _queue = new ConcurrentLinkedQueue();
    private final AtomicBoolean _executeMultiple = new AtomicBoolean();
    private long _executionTime = 0L;
    private final List<ExecutionExceptionListener> _executionExceptionListeners = new LinkedList<ExecutionExceptionListener>();

    public void addExecutionExceptionListener(ExecutionExceptionListener l) {
        this._executionExceptionListeners.add(l);
    }

    public boolean removeExecutionExceptionListener(ExecutionExceptionListener l) {
        return this._executionExceptionListeners.remove(l);
    }

    public boolean isExecuteAll() {
        return this._executeMultiple.get();
    }

    public void setExecuteMultiple(boolean executeMultiple) {
        this._executeMultiple.set(executeMultiple);
        if (executeMultiple) {
            this._executionTime = Integer.MAX_VALUE;
        }
    }

    public void setExecutionTime(int msecs) {
        this._executionTime = msecs;
        this._executeMultiple.set(true);
    }

    public long getExecutionTime() {
        if (!this._executeMultiple.get()) {
            return -1L;
        }
        return this._executionTime;
    }

    public <V> Future<V> enqueue(Callable<V> callable) {
        GameTask<V> task = new GameTask<V>(callable);
        this._queue.add(task);
        return task;
    }

    public <V> void enqueue(GameTask<V> task) {
        this._queue.add(task);
    }

    public void execute() {
        this.execute(null);
    }

    public void execute(Renderer renderer) {
        long elapsedTime;
        long beginTime = System.currentTimeMillis();
        GameTask<?> task = this._queue.poll();
        do {
            if (task == null) {
                return;
            }
            if (renderer != null && task.getCallable() instanceof RendererCallable) {
                ((RendererCallable)task.getCallable()).setRenderer(renderer);
            }
            while (task.isCancelled()) {
                task = this._queue.poll();
                if (task != null) continue;
                return;
            }
            task.invoke();
            ExecutionException e = task.getExecutionException();
            if (e != null) {
                for (ExecutionExceptionListener l : this._executionExceptionListeners) {
                    l.executionException(e);
                }
            }
            elapsedTime = System.currentTimeMillis() - beginTime;
        } while (this._executeMultiple.get() && elapsedTime < this._executionTime && (task = this._queue.poll()) != null);
    }

    public void clear() {
        this._queue.clear();
    }

    public void enqueueAll(GameTaskQueue queue) {
        this._queue.addAll(queue._queue);
        queue._queue.clear();
    }

    public int size() {
        return this._queue.size();
    }

    public static interface ExecutionExceptionListener {
        public void executionException(ExecutionException var1);
    }
}

