/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util;

import com.ardor3d.util.GameTaskQueue;
import com.google.common.collect.MapMaker;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;

public final class GameTaskQueueManager {
    private static final Object MAP_LOCK = new Object();
    private static final ConcurrentMap<Object, GameTaskQueueManager> _managers = new MapMaker().weakKeys().makeMap();
    private final ConcurrentMap<String, GameTaskQueue> _managedQueues = new ConcurrentHashMap<String, GameTaskQueue>(2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GameTaskQueueManager getManager(Object key) {
        Object object = MAP_LOCK;
        synchronized (object) {
            GameTaskQueueManager manager = (GameTaskQueueManager)_managers.get(key);
            if (manager == null) {
                manager = new GameTaskQueueManager();
                _managers.put(key, manager);
            }
            return manager;
        }
    }

    public static GameTaskQueueManager clearManager(Object key) {
        return (GameTaskQueueManager)_managers.remove(key);
    }

    private GameTaskQueueManager() {
        this.addQueue("render", new GameTaskQueue());
        this.addQueue("update", new GameTaskQueue());
    }

    public void addQueue(String name, GameTaskQueue queue) {
        this._managedQueues.put(name, queue);
    }

    public GameTaskQueue getQueue(String name) {
        return (GameTaskQueue)this._managedQueues.get(name);
    }

    public void moveTasksTo(GameTaskQueueManager manager) {
        for (String key : this._managedQueues.keySet()) {
            GameTaskQueue q = manager.getQueue(key);
            GameTaskQueue mq = (GameTaskQueue)this._managedQueues.get(key);
            if (q == null || mq.size() <= 0) continue;
            q.enqueueAll(mq);
        }
    }

    public void clearTasks() {
        for (GameTaskQueue q : this._managedQueues.values()) {
            q.clear();
        }
    }

    public <V> Future<V> update(Callable<V> callable) {
        return this.getQueue("update").enqueue(callable);
    }

    public <V> Future<V> render(Callable<V> callable) {
        return this.getQueue("render").enqueue(callable);
    }
}

