/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndianDataInput
implements DataInput,
AutoCloseable {
    private final BufferedInputStream _stream;
    public int CHAR_SIZE = 2;

    public LittleEndianDataInput(InputStream in) {
        this._stream = new BufferedInputStream(in);
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this._stream.read() & 0xFF | (this._stream.read() & 0xFF) << 8;
    }

    public final long readUnsignedInt() throws IOException {
        return (long)(this._stream.read() & 0xFF | (this._stream.read() & 0xFF) << 8 | (this._stream.read() & 0xFF) << 16) | (long)(this._stream.read() & 0xFF) << 24;
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this._stream.read() != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        return (byte)this._stream.read();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this._stream.read();
    }

    @Override
    public final short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    @Override
    public final char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    public final int readInt() throws IOException {
        return this._stream.read() & 0xFF | (this._stream.read() & 0xFF) << 8 | (this._stream.read() & 0xFF) << 16 | (this._stream.read() & 0xFF) << 24;
    }

    @Override
    public final long readLong() throws IOException {
        return (long)(this._stream.read() & 0xFF) | (long)(this._stream.read() & 0xFF) << 8 | (long)(this._stream.read() & 0xFF) << 16 | (long)(this._stream.read() & 0xFF) << 24 | (long)(this._stream.read() & 0xFF) << 32 | (long)(this._stream.read() & 0xFF) << 40 | (long)(this._stream.read() & 0xFF) << 48 | (long)(this._stream.read() & 0xFF) << 56;
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        int bytesRead = this._stream.read(b, off, len);
        if (bytesRead == -1) {
            throw new EOFException("EOF reached");
        }
        if (bytesRead < len) {
            this.readFully(b, off + bytesRead, len - bytesRead);
        }
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        return (int)this._stream.skip(n);
    }

    @Override
    public final String readLine() throws IOException {
        throw new IOException("Unsupported operation");
    }

    @Override
    public final String readUTF() throws IOException {
        throw new IOException("Unsupported operation");
    }

    @Override
    public final void close() throws IOException {
        this._stream.close();
    }

    public final int available() throws IOException {
        return this._stream.available();
    }
}

