/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util;

import com.ardor3d.util.export.ByteUtils;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class LittleEndianRandomAccessDataInput
implements DataInput {
    private final ByteBuffer _contents;
    public int CHAR_SIZE = 2;

    public LittleEndianRandomAccessDataInput(InputStream in) throws IOException {
        this._contents = ByteBuffer.wrap(ByteUtils.getByteContent((InputStream)in));
    }

    public LittleEndianRandomAccessDataInput(ByteBuffer contents) throws IOException {
        this._contents = contents;
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this.readByte() & 0xFF | (this.readByte() & 0xFF) << 8;
    }

    public final long readUnsignedInt() throws IOException {
        return (long)(this.readByte() & 0xFF | (this.readByte() & 0xFF) << 8 | (this.readByte() & 0xFF) << 16) | (long)(this.readByte() & 0xFF) << 24;
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        return this._contents.get();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public final short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    @Override
    public final char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    public final int readInt() throws IOException {
        return this.readByte() & 0xFF | (this.readByte() & 0xFF) << 8 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 24;
    }

    @Override
    public final long readLong() throws IOException {
        return (long)(this.readByte() & 0xFF) | (long)(this.readByte() & 0xFF) << 8 | (long)(this.readByte() & 0xFF) << 16 | (long)(this.readByte() & 0xFF) << 24 | (long)(this.readByte() & 0xFF) << 32 | (long)(this.readByte() & 0xFF) << 40 | (long)(this.readByte() & 0xFF) << 48 | (long)(this.readByte() & 0xFF) << 56;
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        if (len - off + this._contents.position() > this._contents.capacity()) {
            throw new EOFException("EOF reached");
        }
        this._contents.get(b, off, len);
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        if (this._contents.remaining() >= n) {
            this._contents.position(this._contents.position() + n);
            return n;
        }
        int skipped = this._contents.remaining();
        this._contents.position(this._contents.limit());
        return skipped;
    }

    public final LittleEndianRandomAccessDataInput mark() {
        this._contents.mark();
        return this;
    }

    public final LittleEndianRandomAccessDataInput reset() {
        this._contents.reset();
        return this;
    }

    @Override
    public final String readLine() throws IOException {
        throw new IOException("operation unsupported.");
    }

    @Override
    public final String readUTF() throws IOException {
        throw new IOException("operation unsupported.");
    }

    public String readString(int size, Charset charset) throws IOException {
        int start = this.position();
        byte[] content = new byte[size];
        this.readFully(content);
        this.seek(start + size);
        int indexOfNullByte = size;
        for (int i = 0; i < size; ++i) {
            if (content[i] != 0) continue;
            indexOfNullByte = i;
            break;
        }
        String s = new String(content, 0, indexOfNullByte, charset);
        return s;
    }

    public String readString(int size) throws IOException {
        return this.readString(size, Charset.defaultCharset());
    }

    public final void seek(int pos) throws IOException {
        this._contents.position(pos);
    }

    public int position() {
        return this._contents.position();
    }

    public int capacity() {
        return this._contents.capacity();
    }
}

