/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util;

import java.util.Comparator;

public abstract class SortUtil {
    public static int SHELL_SORT_THRESHOLD = 17;

    public static <T> void msort(T[] source, int left, int right, Comparator<? super T> comp) {
        Object[] copy = new Object[source.length];
        System.arraycopy(source, 0, copy, 0, source.length);
        SortUtil.msort(copy, source, left, right, comp);
    }

    public static <T> void msort(T[] source, T[] copy, int left, int right, Comparator<? super T> comp) {
        int length = right - left + 1;
        if (length <= SHELL_SORT_THRESHOLD) {
            SortUtil.shellSort(copy, left, right, comp);
            return;
        }
        int mid = left + right >> 1;
        SortUtil.msort(copy, source, left, mid, comp);
        SortUtil.msort(copy, source, mid + 1, right, comp);
        SortUtil.merge(source, copy, left, mid, right, comp);
    }

    protected static <T> void merge(T[] source, T[] destination, int left, int mid, int right, Comparator<? super T> comp) {
        int i = left;
        int j = mid + 1;
        for (int k = left; k <= right; ++k) {
            destination[k] = i == mid + 1 ? source[j++] : (j == right + 1 ? source[i++] : (comp.compare(source[i], source[j]) <= 0 ? source[i++] : source[j++]));
        }
    }

    public static <T> void shellSort(T[] array, int left, int right, Comparator<? super T> comp) {
        int h = 1;
        while (h <= (right - 1) / 9) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = left + h; i <= right; ++i) {
                T val = array[i];
                for (int j = i; j >= left + h && comp.compare(val, array[j - h]) < 0; j -= h) {
                    array[j] = array[j - h];
                }
                array[j] = val;
            }
            h /= 3;
        }
    }

    public static <T extends Comparable<T>> void shellSort(T[] array, int left, int right) {
        int h = 1;
        while (h <= (right - 1) / 9) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = left + h; i <= right; ++i) {
                T val = array[i];
                for (int j = i; j >= left + h && val.compareTo(array[j - 1]) < 0; j -= h) {
                    array[j] = array[j - h];
                }
                array[j] = val;
            }
            h /= 3;
        }
    }
}

