/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util;

import com.ardor3d.annotation.SavableFactory;
import com.ardor3d.image.Texture;
import com.ardor3d.image.TextureStoreFormat;
import com.ardor3d.util.Constants;
import com.ardor3d.util.ContextIdReference;
import com.ardor3d.util.TextureManager;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.resource.ResourceSource;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

@SavableFactory(factoryMethod="initSavable")
public final class TextureKey
implements Savable {
    protected ResourceSource _source = null;
    protected boolean _flipped;
    protected TextureStoreFormat _format = TextureStoreFormat.GuessCompressedFormat;
    protected String _id;
    protected Texture.MinificationFilter _minFilter = Texture.MinificationFilter.Trilinear;
    private final List<WeakReference<Object>> _dirtyContexts;
    private boolean _dirty;
    protected final transient ContextIdReference<TextureKey> _idCache = new ContextIdReference<TextureKey>(this, TextureManager.getRefQueue());
    protected transient int _code = Integer.MAX_VALUE;
    protected static final List<WeakReference<TextureKey>> _keyCache = new LinkedList<WeakReference<TextureKey>>();
    private static final Integer ZERO = new Integer(0);
    private static AtomicInteger _uniqueTK = new AtomicInteger(Integer.MIN_VALUE);

    protected TextureKey() {
        this._dirtyContexts = Constants.useMultipleContexts ? new ArrayList<WeakReference<Object>>() : null;
    }

    public static TextureKey initSavable() {
        return new TextureKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirty() {
        if (Constants.useMultipleContexts) {
            List<WeakReference<Object>> list = this._dirtyContexts;
            synchronized (list) {
                this._dirtyContexts.clear();
                for (Object context : this._idCache.getContextObjects()) {
                    WeakReference<Object> ref = new WeakReference<Object>(context);
                    this._dirtyContexts.add(ref);
                }
            }
        } else {
            this._dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty(Object glContext) {
        if (Constants.useMultipleContexts) {
            List<WeakReference<Object>> list = this._dirtyContexts;
            synchronized (list) {
                if (this._dirtyContexts.isEmpty()) {
                    return false;
                }
                Iterator<WeakReference<Object>> it = this._dirtyContexts.iterator();
                while (it.hasNext()) {
                    WeakReference<Object> ref = it.next();
                    Object check = ref.get();
                    if (check == null) {
                        it.remove();
                        continue;
                    }
                    if (!check.equals(glContext)) continue;
                    return true;
                }
                return false;
            }
        }
        return this._dirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClean(Object glContext) {
        if (Constants.useMultipleContexts) {
            List<WeakReference<Object>> list = this._dirtyContexts;
            synchronized (list) {
                if (!this._dirtyContexts.isEmpty()) {
                    Iterator<WeakReference<Object>> it = this._dirtyContexts.iterator();
                    while (it.hasNext()) {
                        WeakReference<Object> ref = it.next();
                        Object check = ref.get();
                        if (check == null || !check.equals(glContext)) continue;
                        it.remove();
                        return;
                    }
                }
            }
        } else {
            this._dirty = false;
        }
    }

    public static synchronized TextureKey getRTTKey(Texture.MinificationFilter minFilter) {
        int val = _uniqueTK.addAndGet(1);
        if (val == Integer.MAX_VALUE) {
            _uniqueTK.set(Integer.MIN_VALUE);
            val = Integer.MIN_VALUE;
        }
        return TextureKey.getKey(null, false, TextureStoreFormat.GuessCompressedFormat, "RTT_" + val, minFilter);
    }

    public static synchronized TextureKey getKey(ResourceSource source, boolean flipped, TextureStoreFormat storeFormat, Texture.MinificationFilter minFilter) {
        return TextureKey.getKey(source, flipped, storeFormat, null, minFilter);
    }

    public static synchronized TextureKey getKey(ResourceSource source, boolean flipped, TextureStoreFormat storeFormat, String id, Texture.MinificationFilter minFilter) {
        TextureKey key = new TextureKey();
        key._source = source;
        key._flipped = flipped;
        key._minFilter = minFilter;
        key._format = storeFormat;
        key._id = id;
        key._code = Integer.MAX_VALUE;
        Iterator<WeakReference<TextureKey>> it = _keyCache.iterator();
        while (it.hasNext()) {
            WeakReference<TextureKey> ref = it.next();
            TextureKey check = (TextureKey)ref.get();
            if (check == null) {
                it.remove();
                continue;
            }
            if (!check.equals(key)) continue;
            return check;
        }
        _keyCache.add(new WeakReference<TextureKey>(key));
        return key;
    }

    public static synchronized boolean clearKey(TextureKey key) {
        Iterator<WeakReference<TextureKey>> it = _keyCache.iterator();
        while (it.hasNext()) {
            WeakReference<TextureKey> ref = it.next();
            TextureKey check = (TextureKey)ref.get();
            if (check == null || !check.equals(key)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public Integer getTextureIdForContext(Object glContext) {
        Integer id = this._idCache.getValue(glContext);
        if (id != null) {
            return id;
        }
        return ZERO;
    }

    public Set<Object> getContextObjects() {
        return this._idCache.getContextObjects();
    }

    public void removeFromIdCache(Object glContext) {
        this._idCache.removeValue(glContext);
    }

    public void removeFromIdCache() {
        this._idCache.clear();
    }

    public void setTextureIdForContext(Object glContext, int textureId) {
        if (textureId == 0) {
            throw new IllegalArgumentException("textureId must != 0");
        }
        this._idCache.put(glContext, textureId);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TextureKey)) {
            return false;
        }
        TextureKey that = (TextureKey)other;
        if (this._source == null ? that._source != null : !this._source.equals(that._source)) {
            return false;
        }
        if (this._id == null && that._id != null) {
            return false;
        }
        if (this._id != null && !this._id.equals(that._id)) {
            return false;
        }
        if (this._minFilter != that._minFilter) {
            return false;
        }
        if (this._format != that._format) {
            return false;
        }
        return this._flipped == that._flipped;
    }

    public int hashCode() {
        if (this._code == Integer.MAX_VALUE) {
            this._code = Objects.hash(new Object[]{this.getSource(), this.getId(), this.getMinificationFilter(), this.getFormat(), this.isFlipped()});
        }
        return this._code;
    }

    public Texture.MinificationFilter getMinificationFilter() {
        return this._minFilter;
    }

    public TextureStoreFormat getFormat() {
        return this._format;
    }

    public boolean isFlipped() {
        return this._flipped;
    }

    public ResourceSource getSource() {
        return this._source;
    }

    public String getId() {
        return this._id;
    }

    public String toString() {
        String x = "tkey: src:" + this._source + " flip: " + this._flipped + " code: " + this.hashCode() + " imageType: " + (Object)((Object)this._format) + " id: " + this._id;
        return x;
    }

    public Class<? extends TextureKey> getClassTag() {
        return this.getClass();
    }

    public void write(OutputCapsule capsule) throws IOException {
        capsule.write((Savable)this._source, "source", null);
        capsule.write(this._flipped, "flipped", false);
        capsule.write((Enum)this._format, "format", (Enum)TextureStoreFormat.GuessCompressedFormat);
        capsule.write((Enum)this._minFilter, "minFilter", (Enum)Texture.MinificationFilter.Trilinear);
        capsule.write(this._id, "id", null);
    }

    public void read(InputCapsule capsule) throws IOException {
        this._source = (ResourceSource)capsule.readSavable("source", null);
        this._flipped = capsule.readBoolean("flipped", false);
        this._format = (TextureStoreFormat)capsule.readEnum("format", TextureStoreFormat.class, (Enum)TextureStoreFormat.GuessCompressedFormat);
        this._minFilter = (Texture.MinificationFilter)capsule.readEnum("minFilter", Texture.MinificationFilter.class, (Enum)Texture.MinificationFilter.Trilinear);
        this._id = capsule.readString("id", null);
        this._code = Integer.MAX_VALUE;
    }
}

