/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util;

import com.ardor3d.annotation.MainThread;
import com.ardor3d.image.Image;
import com.ardor3d.image.Texture;
import com.ardor3d.image.Texture2D;
import com.ardor3d.image.Texture3D;
import com.ardor3d.image.TextureCubeMap;
import com.ardor3d.image.TextureStoreFormat;
import com.ardor3d.image.util.ImageLoaderUtil;
import com.ardor3d.image.util.ImageUtils;
import com.ardor3d.renderer.ContextCleanListener;
import com.ardor3d.renderer.ContextManager;
import com.ardor3d.renderer.RenderContext;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.RendererCallable;
import com.ardor3d.renderer.state.TextureState;
import com.ardor3d.util.Constants;
import com.ardor3d.util.ContextIdReference;
import com.ardor3d.util.GameTaskQueueManager;
import com.ardor3d.util.TextureKey;
import com.ardor3d.util.resource.ResourceLocatorTool;
import com.ardor3d.util.resource.ResourceSource;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multimap;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Logger;

public final class TextureManager {
    private static final Logger logger = Logger.getLogger(TextureManager.class.getName());
    private static Map<TextureKey, Texture> _tCache = new MapMaker().weakKeys().weakValues().makeMap();
    private static ReferenceQueue<TextureKey> _textureRefQueue = new ReferenceQueue();

    private TextureManager() {
    }

    public static Texture load(String name, Texture.MinificationFilter minFilter, boolean flipVertically) {
        return TextureManager.load(ResourceLocatorTool.locateResource("texture", name), minFilter, TextureStoreFormat.GuessNoCompressedFormat, flipVertically);
    }

    public static Texture load(String name, Texture.MinificationFilter minFilter, TextureStoreFormat format, boolean flipVertically) {
        return TextureManager.load(ResourceLocatorTool.locateResource("texture", name), minFilter, format, flipVertically);
    }

    public static Texture load(ResourceSource source, Texture.MinificationFilter minFilter, boolean flipVertically) {
        return TextureManager.load(source, minFilter, TextureStoreFormat.GuessNoCompressedFormat, flipVertically);
    }

    public static Texture load(ResourceSource source, Texture.MinificationFilter minFilter, TextureStoreFormat format, boolean flipVertically) {
        if (null == source) {
            logger.warning("Could not load image...  source was null. defaultTexture used.");
            return TextureState.getDefaultTexture();
        }
        TextureKey tkey = TextureKey.getKey(source, flipVertically, format, minFilter);
        return TextureManager.loadFromKey(tkey, null, null);
    }

    public static Texture loadFromImage(Image image, Texture.MinificationFilter minFilter) {
        return TextureManager.loadFromImage(image, minFilter, TextureStoreFormat.GuessNoCompressedFormat);
    }

    public static Texture loadFromImage(Image image, Texture.MinificationFilter minFilter, TextureStoreFormat format) {
        TextureKey key = TextureKey.getKey(null, false, format, "img_" + image.hashCode(), minFilter);
        return TextureManager.loadFromKey(key, image, null);
    }

    public static Texture loadFromKey(TextureKey tkey, Image imageData, Texture store) {
        if (tkey == null) {
            logger.warning("TextureKey is null, cannot load");
            return TextureState.getDefaultTexture();
        }
        Texture result = store;
        Texture cache = TextureManager.findCachedTexture(tkey);
        if (cache != null) {
            if (result == null) {
                result = cache.createSimpleClone();
                if (result.getTextureKey() == null) {
                    result.setTextureKey(tkey);
                }
                return result;
            }
            cache.createSimpleClone(result);
            return result;
        }
        Image img = imageData;
        if (img == null) {
            img = ImageLoaderUtil.loadImage(tkey.getSource(), tkey.isFlipped());
        }
        if (null == img) {
            logger.warning("(image null) Could not load: " + tkey.getSource());
            return TextureState.getDefaultTexture();
        }
        if (result == null) {
            result = img.getDataSize() == 6 ? new TextureCubeMap() : (img.getDataSize() > 1 ? new Texture3D() : new Texture2D());
        }
        result.setTextureKey(tkey);
        result.setImage(img);
        result.setMinificationFilter(tkey.getMinificationFilter());
        result.setTextureStoreFormat(ImageUtils.getTextureStoreFormat(tkey.getFormat(), result.getImage()));
        TextureManager.addToCache(result);
        return result;
    }

    public static void addToCache(Texture texture) {
        if (TextureState.getDefaultTexture() == null || texture != TextureState.getDefaultTexture() && texture.getImage() != TextureState.getDefaultTextureImage()) {
            _tCache.put(texture.getTextureKey(), texture);
        }
    }

    public static Texture findCachedTexture(TextureKey textureKey) {
        return _tCache.get(textureKey);
    }

    public static Texture removeFromCache(TextureKey tk) {
        return _tCache.remove(tk);
    }

    public static void cleanAllTextures(Renderer deleter) {
        TextureManager.cleanAllTextures(deleter, null);
    }

    public static void cleanAllTextures(Renderer deleter, Map<Object, Future<Void>> futureStore) {
        ArrayListMultimap idMap = TextureManager.gatherGCdIds();
        for (TextureKey key : _tCache.keySet()) {
            if (idMap == null) {
                idMap = ArrayListMultimap.create();
            }
            if (Constants.useMultipleContexts) {
                Set<Object> contextObjects = key.getContextObjects();
                for (Object o : contextObjects) {
                    idMap.put(o, (Object)key.getTextureIdForContext(o));
                }
            } else {
                idMap.put(ContextManager.getCurrentContext().getGlContextRep(), (Object)key.getTextureIdForContext(null));
            }
            key.removeFromIdCache();
        }
        if (idMap != null && !idMap.isEmpty()) {
            TextureManager.handleTextureDelete(deleter, (Multimap<Object, Integer>)idMap, futureStore);
        }
    }

    public static void cleanAllTextures(Renderer deleter, RenderContext context, Map<Object, Future<Void>> futureStore) {
        ArrayListMultimap idMap = TextureManager.gatherGCdIds();
        Object glRep = context.getGlContextRep();
        for (TextureKey key : _tCache.keySet()) {
            Integer id;
            if (idMap == null) {
                idMap = ArrayListMultimap.create();
            }
            if ((id = key.getTextureIdForContext(glRep)) == 0) continue;
            idMap.put(context.getGlContextRep(), (Object)id);
            key.removeFromIdCache(glRep);
        }
        if (!idMap.isEmpty()) {
            TextureManager.handleTextureDelete(deleter, idMap, futureStore);
        }
    }

    public static void cleanExpiredTextures(Renderer deleter) {
        TextureManager.cleanExpiredTextures(deleter, null);
    }

    public static void cleanExpiredTextures(Renderer deleter, Map<Object, Future<Void>> futureStore) {
        Multimap<Object, Integer> idMap = TextureManager.gatherGCdIds();
        if (idMap != null) {
            TextureManager.handleTextureDelete(deleter, idMap, futureStore);
        }
    }

    private static Multimap<Object, Integer> gatherGCdIds() {
        ContextIdReference ref;
        ArrayListMultimap idMap = null;
        while ((ref = (ContextIdReference)_textureRefQueue.poll()) != null) {
            Integer id;
            if (idMap == null) {
                idMap = ArrayListMultimap.create();
            }
            if (Constants.useMultipleContexts) {
                Set<Object> contextObjects = ref.getContextObjects();
                for (Object o : contextObjects) {
                    id = ref.getValue(o);
                    if (id == null || id == 0) continue;
                    idMap.put(o, (Object)id);
                }
            } else {
                id = ref.getValue(null);
                if (id != null && id != 0) {
                    idMap.put(ContextManager.getCurrentContext().getGlContextRep(), (Object)id);
                }
            }
            ref.clear();
        }
        return idMap;
    }

    private static void handleTextureDelete(Renderer deleter, final Multimap<Object, Integer> idMap, Map<Object, Future<Void>> futureStore) {
        if (deleter == null) {
            return;
        }
        Object currentGLRef = null;
        if (ContextManager.getCurrentContext() != null) {
            currentGLRef = ContextManager.getCurrentContext().getGlContextRep();
        }
        for (final Object glref : idMap.keySet()) {
            if (currentGLRef != null && (!Constants.useMultipleContexts || glref.equals(currentGLRef))) {
                deleter.deleteTextureIds(idMap.get(glref));
                continue;
            }
            Future<Void> future = GameTaskQueueManager.getManager(ContextManager.getContextForRef(glref)).render(new RendererCallable<Void>(){

                @Override
                public Void call() throws Exception {
                    this.getRenderer().deleteTextureIds(idMap.get(glref));
                    return null;
                }
            });
            if (futureStore == null) continue;
            futureStore.put(glref, future);
        }
    }

    @MainThread
    public static void preloadCache(Renderer r) {
        for (Texture t : _tCache.values()) {
            if (t == null || t.getTextureKey().getSource() == null) continue;
            r.loadTexture(t, 0);
        }
    }

    static ReferenceQueue<TextureKey> getRefQueue() {
        return _textureRefQueue;
    }

    static {
        ContextManager.addContextCleanListener(new ContextCleanListener(){

            @Override
            public void cleanForContext(RenderContext renderContext) {
                TextureManager.cleanAllTextures(null, renderContext, null);
            }
        });
    }
}

