/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util;

import com.ardor3d.util.ReadOnlyTimer;

public class Timer
implements ReadOnlyTimer {
    private static final long TIMER_RESOLUTION = 1000000000L;
    private static final double INVERSE_TIMER_RESOLUTION = 1.0E-9;
    private long _startTime = System.nanoTime();
    private long _previousTime;
    private double _tpf;
    private double _fps;

    @Override
    public double getTimeInSeconds() {
        return (double)this.getTime() * 1.0E-9;
    }

    @Override
    public long getTime() {
        return System.nanoTime() - this._startTime;
    }

    @Override
    public long getResolution() {
        return 1000000000L;
    }

    @Override
    public double getFrameRate() {
        return this._fps;
    }

    @Override
    public double getTimePerFrame() {
        return this._tpf;
    }

    public void update() {
        long time = this.getTime();
        this._tpf = (double)(time - this._previousTime) * 1.0E-9;
        this._fps = 1.0 / this._tpf;
        this._previousTime = time;
    }

    public void reset() {
        this._startTime = System.nanoTime();
        this._previousTime = this.getTime();
    }
}

