/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.export.binary;

import com.ardor3d.math.MathUtils;
import com.ardor3d.util.export.Ardor3dExporter;
import com.ardor3d.util.export.ByteUtils;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.export.binary.BinaryClassField;
import com.ardor3d.util.export.binary.BinaryClassObject;
import com.ardor3d.util.export.binary.BinaryIdContentPair;
import com.ardor3d.util.export.binary.BinaryOutputCapsule;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;

public class BinaryExporter
implements Ardor3dExporter {
    private static final Logger logger = Logger.getLogger(BinaryExporter.class.getName());
    public static int DEFAULT_COMPRESSION = 9;
    protected final int _compression;
    protected int _aliasCount = 1;
    protected int _idCount = 1;
    protected final Map<Savable, BinaryIdContentPair> _contentTable = new IdentityHashMap<Savable, BinaryIdContentPair>();
    protected final Map<Integer, Integer> _locationTable = new HashMap<Integer, Integer>();
    protected final Map<String, BinaryClassObject> _classes = new HashMap<String, BinaryClassObject>();
    protected final List<Savable> _contentKeys = new ArrayList<Savable>();

    public BinaryExporter() {
        this(DEFAULT_COMPRESSION);
    }

    public BinaryExporter(int compression) {
        this._compression = compression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Savable object, OutputStream os) throws IOException {
        try {
            Object aliasBytes;
            GZIPOutputStream zos = new GZIPOutputStream(os){
                {
                    this.def.setLevel(BinaryExporter.this._compression);
                }
            };
            int id = this.processBinarySavable(object);
            int ttbytes = 0;
            int classNum = this._classes.keySet().size();
            int aliasWidth = (int)MathUtils.log((double)classNum, (double)256.0) + 1;
            zos.write(ByteUtils.convertToBytes((int)classNum));
            for (String key : this._classes.keySet()) {
                BinaryClassObject bco = this._classes.get(key);
                aliasBytes = this.fixClassAlias(bco._alias, aliasWidth);
                zos.write((byte[])aliasBytes);
                ttbytes += aliasWidth;
                byte[] classBytes = key.getBytes();
                zos.write(ByteUtils.convertToBytes((int)classBytes.length));
                zos.write(classBytes);
                ttbytes += 4 + classBytes.length;
                zos.write(ByteUtils.convertToBytes((int)bco._nameFields.size()));
                for (String fieldName : bco._nameFields.keySet()) {
                    BinaryClassField bcf = bco._nameFields.get(fieldName);
                    zos.write(bcf._alias);
                    zos.write(bcf._type);
                    byte[] fNameBytes = fieldName.getBytes();
                    zos.write(ByteUtils.convertToBytes((int)fNameBytes.length));
                    zos.write(fNameBytes);
                    ttbytes += 6 + fNameBytes.length;
                }
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int location = 0;
            HashMap<String, ArrayList<BinaryIdContentPair>> alreadySaved = new HashMap<String, ArrayList<BinaryIdContentPair>>(this._contentTable.size());
            aliasBytes = this._contentKeys.iterator();
            while (aliasBytes.hasNext()) {
                ArrayList<BinaryIdContentPair> bucket;
                Savable savable = (Savable)aliasBytes.next();
                String savableName = savable.getClassTag().getName();
                BinaryIdContentPair pair = this._contentTable.get(savable);
                int prevLoc = this.findPrevMatch(pair, (List<BinaryIdContentPair>)(bucket = (ArrayList<BinaryIdContentPair>)alreadySaved.get(savableName + this.getChunk(pair))));
                if (prevLoc != -1) {
                    this._locationTable.put(pair.getId(), prevLoc);
                    continue;
                }
                this._locationTable.put(pair.getId(), location);
                if (bucket == null) {
                    bucket = new ArrayList<BinaryIdContentPair>();
                    alreadySaved.put(savableName + this.getChunk(pair), bucket);
                }
                bucket.add(pair);
                byte[] aliasBytes2 = this.fixClassAlias(this._classes.get((Object)savableName)._alias, aliasWidth);
                out.write(aliasBytes2);
                location += aliasWidth;
                BinaryOutputCapsule cap = this._contentTable.get(savable).getContent();
                out.write(ByteUtils.convertToBytes((int)cap._bytes.length));
                location += 4;
                out.write(cap._bytes);
                location += cap._bytes.length;
            }
            int locNum = this._locationTable.keySet().size();
            zos.write(ByteUtils.convertToBytes((int)locNum));
            int locbytes = 0;
            for (Integer key : this._locationTable.keySet()) {
                zos.write(ByteUtils.convertToBytes((int)key));
                zos.write(ByteUtils.convertToBytes((int)this._locationTable.get(key)));
                locbytes += 8;
            }
            zos.write(ByteUtils.convertToBytes((int)1));
            zos.write(ByteUtils.convertToBytes((int)id));
            out.writeTo(zos);
            zos.finish();
            out = null;
            zos = null;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Stats:");
                logger.fine("classes: " + classNum);
                logger.fine("class table: " + ttbytes + " bytes");
                logger.fine("objects: " + locNum);
                logger.fine("location table: " + locbytes + " bytes");
                logger.fine("data: " + location + " bytes");
            }
        }
        finally {
            this._aliasCount = 1;
            this._idCount = 1;
            this._contentTable.clear();
            this._locationTable.clear();
            this._classes.clear();
            this._contentKeys.clear();
        }
    }

    protected String getChunk(BinaryIdContentPair pair) {
        return new String(pair.getContent()._bytes, 0, Math.min(64, pair.getContent()._bytes.length));
    }

    protected int findPrevMatch(BinaryIdContentPair oldPair, List<BinaryIdContentPair> bucket) {
        if (bucket == null) {
            return -1;
        }
        int x = bucket.size();
        while (--x >= 0) {
            BinaryIdContentPair pair = bucket.get(x);
            if (!pair.getContent().equals(oldPair.getContent())) continue;
            return this._locationTable.get(pair.getId());
        }
        return -1;
    }

    protected byte[] fixClassAlias(byte[] bytes, int width) {
        if (bytes.length != width) {
            byte[] newAlias = new byte[width];
            for (int x = width - bytes.length; x < width; ++x) {
                newAlias[x] = bytes[x - bytes.length];
            }
            return newAlias;
        }
        return bytes;
    }

    public void save(Savable object, File file) throws IOException {
        File parentDirectory = file.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists()) {
            parentDirectory.mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.save(object, fos);
        }
    }

    public int processBinarySavable(Savable object) throws IOException {
        if (object == null) {
            return -1;
        }
        BinaryClassObject bco = this._classes.get(object.getClassTag().getName());
        if (bco == null) {
            bco = new BinaryClassObject();
            bco._alias = this.generateTag();
            bco._nameFields = new HashMap();
            this._classes.put(object.getClassTag().getName(), bco);
        }
        if (this._contentTable.get(object) != null) {
            return this._contentTable.get(object).getId();
        }
        BinaryIdContentPair newPair = this.generateIdContentPair(bco);
        BinaryIdContentPair old = this._contentTable.put(object, newPair);
        if (old == null) {
            this._contentKeys.add(object);
        }
        object.write((OutputCapsule)this._contentTable.get(object).getContent());
        newPair.getContent().finish();
        return newPair.getId();
    }

    protected byte[] generateTag() {
        int width = (int)MathUtils.log((double)this._aliasCount, (double)256.0) + 1;
        int count = this._aliasCount++;
        byte[] bytes = new byte[width];
        for (int x = width - 1; x >= 0; --x) {
            int pow = (int)Math.pow(256.0, x);
            int factor = count / pow;
            bytes[width - x - 1] = (byte)factor;
            count %= pow;
        }
        return bytes;
    }

    protected BinaryIdContentPair generateIdContentPair(BinaryClassObject bco) {
        BinaryIdContentPair pair = new BinaryIdContentPair(this._idCount++, new BinaryOutputCapsule(this, bco));
        return pair;
    }
}

