/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.export.binary;

import com.ardor3d.annotation.SavableFactory;
import com.ardor3d.math.MathUtils;
import com.ardor3d.util.Ardor3dException;
import com.ardor3d.util.export.Ardor3dImporter;
import com.ardor3d.util.export.ByteUtils;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.ReadListener;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.export.binary.BinaryClassField;
import com.ardor3d.util.export.binary.BinaryClassObject;
import com.ardor3d.util.export.binary.BinaryInputCapsule;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class BinaryImporter
implements Ardor3dImporter {
    private static final Logger logger = Logger.getLogger(BinaryImporter.class.getName());
    protected final Map<String, BinaryClassObject> _classes = new HashMap<String, BinaryClassObject>();
    protected final Map<Integer, Savable> _contentTable = new HashMap<Integer, Savable>();
    protected final Map<Savable, BinaryInputCapsule> _capsuleTable = new IdentityHashMap<Savable, BinaryInputCapsule>();
    protected final Map<Integer, Integer> _locationTable = new HashMap<Integer, Integer>();
    protected byte[] _dataArray = null;
    protected int _aliasWidth = 0;

    public Savable load(InputStream is) throws IOException {
        return this.load(is, null, null);
    }

    public Savable load(InputStream is, ReadListener listener) throws IOException {
        return this.load(is, listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Savable load(InputStream is, ReadListener listener, ByteArrayOutputStream reuseableStream) throws IOException {
        try {
            ByteArrayOutputStream baos;
            int id;
            GZIPInputStream zis = new GZIPInputStream(is);
            BufferedInputStream bis = new BufferedInputStream(zis);
            int numClasses = ByteUtils.readInt((InputStream)bis);
            int bytes = 4;
            this._aliasWidth = (int)MathUtils.log((double)numClasses, (double)256.0) + 1;
            for (int i = 0; i < numClasses; ++i) {
                String alias = this.readString(bis, this._aliasWidth);
                int classLength = ByteUtils.readInt((InputStream)bis);
                String className = this.readString(bis, classLength);
                BinaryClassObject bco = new BinaryClassObject();
                bco._alias = alias.getBytes();
                bco._className = className;
                int fields = ByteUtils.readInt((InputStream)bis);
                bytes += 8 + this._aliasWidth + classLength;
                bco._nameFields = new HashMap(fields);
                bco._aliasFields = new HashMap(fields);
                for (int x = 0; x < fields; ++x) {
                    byte fieldAlias = (byte)bis.read();
                    byte fieldType = (byte)bis.read();
                    int fieldNameLength = ByteUtils.readInt((InputStream)bis);
                    String fieldName = this.readString(bis, fieldNameLength);
                    BinaryClassField bcf = new BinaryClassField(fieldName, fieldAlias, fieldType);
                    bco._nameFields.put(fieldName, bcf);
                    bco._aliasFields.put(fieldAlias, bcf);
                    bytes += 6 + fieldNameLength;
                }
                this._classes.put(alias, bco);
            }
            if (listener != null) {
                listener.readBytes(bytes);
            }
            int numLocs = ByteUtils.readInt((InputStream)bis);
            bytes = 4;
            for (int i = 0; i < numLocs; ++i) {
                id = ByteUtils.readInt((InputStream)bis);
                int loc = ByteUtils.readInt((InputStream)bis);
                this._locationTable.put(id, loc);
                bytes += 8;
            }
            int numbIDs = ByteUtils.readInt((InputStream)bis);
            id = ByteUtils.readInt((InputStream)bis);
            bytes += 8;
            if (listener != null) {
                listener.readBytes(bytes);
            }
            if ((baos = reuseableStream) == null) {
                baos = new ByteArrayOutputStream(bytes);
            } else {
                baos.reset();
            }
            int size = -1;
            byte[] cache = new byte[4096];
            while ((size = bis.read(cache)) != -1) {
                baos.write(cache, 0, size);
                if (listener == null) continue;
                listener.readBytes(size);
            }
            bis = null;
            this._dataArray = baos.toByteArray();
            baos = null;
            Savable rVal = this.readObject(id);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Importer Stats: ");
                logger.fine("Tags: " + numClasses);
                logger.fine("Objects: " + numLocs);
                logger.fine("Data Size: " + this._dataArray.length);
            }
            Savable savable = rVal;
            return savable;
        }
        finally {
            this._aliasWidth = 0;
            this._contentTable.clear();
            this._classes.clear();
            this._capsuleTable.clear();
            this._locationTable.clear();
            this._dataArray = null;
        }
    }

    public Savable load(URL url) throws IOException {
        return this.load(url, null);
    }

    public Savable load(URL url, ReadListener listener) throws IOException {
        try (InputStream is = url.openStream();){
            Savable rVal;
            Savable savable = rVal = this.load(is, listener);
            return savable;
        }
    }

    public Savable load(File file) throws IOException {
        return this.load(file, null);
    }

    public Savable load(File file, ReadListener listener) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            Savable rVal;
            Savable savable = rVal = this.load(fis, listener);
            return savable;
        }
    }

    public Savable load(byte[] data) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            Savable rVal;
            Savable savable = rVal = this.load(bais);
            return savable;
        }
    }

    protected String readString(InputStream is, int length) throws IOException {
        byte[] data = new byte[length];
        is.read(data, 0, length);
        return new String(data);
    }

    protected String readString(int length, int offset) throws IOException {
        byte[] data = new byte[length];
        for (int j = 0; j < length; ++j) {
            data[j] = this._dataArray[j + offset];
        }
        return new String(data);
    }

    public Savable readObject(int id) {
        if (this._contentTable.get(id) != null) {
            return this._contentTable.get(id);
        }
        try {
            Savable out;
            int loc = this._locationTable.get(id);
            String alias = this.readString(this._aliasWidth, loc);
            loc += this._aliasWidth;
            BinaryClassObject bco = this._classes.get(alias);
            if (bco == null) {
                logger.logp(Level.SEVERE, this.getClass().toString(), "readObject(int id)", "NULL class object: " + alias);
                return null;
            }
            int dataLength = ByteUtils.convertIntFromBytes((byte[])this._dataArray, (int)loc);
            BinaryInputCapsule cap = new BinaryInputCapsule(this, bco);
            cap.setContent(this._dataArray, loc += 4, loc + dataLength);
            try {
                Class<?> clazz = Class.forName(bco._className);
                SavableFactory ann = clazz.getAnnotation(SavableFactory.class);
                out = ann == null ? (Savable)clazz.newInstance() : (Savable)clazz.getMethod(ann.factoryMethod(), null).invoke(null, (Object[])null);
            }
            catch (InstantiationException e) {
                logger.logp(Level.SEVERE, this.getClass().toString(), "readObject(int)", "Could not access constructor of class '" + bco._className + "'! \nSome types may require the annotation SavableFactory.  Please double check.", e);
                throw new Ardor3dException(e);
            }
            catch (NoSuchMethodException e) {
                logger.logp(Level.SEVERE, this.getClass().toString(), "readObject(int)", e.getMessage() + " \nMethod specified in annotation does not appear to exist or has an invalid method signature.", e);
                throw new Ardor3dException(e);
            }
            this._capsuleTable.put(out, cap);
            this._contentTable.put(id, out);
            out.read((InputCapsule)this._capsuleTable.get(out));
            this._capsuleTable.remove(out);
            return out;
        }
        catch (Ardor3dException e) {
            throw e;
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "readObject(int)", "Exception", e);
            throw new Ardor3dException(e);
        }
    }
}

