/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.export.binary;

import com.ardor3d.util.export.ByteUtils;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.export.binary.BinaryClassField;
import com.ardor3d.util.export.binary.BinaryClassObject;
import com.ardor3d.util.export.binary.BinaryImporter;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BinaryInputCapsule
implements InputCapsule {
    private static final Logger logger = Logger.getLogger(BinaryInputCapsule.class.getName());
    protected BinaryImporter _importer;
    protected BinaryClassObject _cObj;
    protected HashMap<Byte, Object> _fieldData;
    protected int _index = 0;
    private static final int UTF8_START = 0;
    private static final int UTF8_2BYTE = 2;
    private static final int UTF8_3BYTE_1 = 3;
    private static final int UTF8_3BYTE_2 = 4;
    private static final int UTF8_ILLEGAL = 10;

    public BinaryInputCapsule(BinaryImporter importer, BinaryClassObject bco) {
        this._importer = importer;
        this._cObj = bco;
    }

    public void setContent(byte[] content, int start, int limit) {
        this._fieldData = new HashMap();
        this._index = start;
        block43: while (this._index < limit) {
            byte alias = content[this._index];
            ++this._index;
            try {
                byte type = this._cObj._aliasFields.get((Object)Byte.valueOf((byte)alias))._type;
                Object value = null;
                switch (type) {
                    case 80: {
                        value = this.readBitSet(content);
                        break;
                    }
                    case 60: {
                        value = this.readBoolean(content);
                        break;
                    }
                    case 61: {
                        value = this.readBooleanArray(content);
                        break;
                    }
                    case 62: {
                        value = this.readBooleanArray2D(content);
                        break;
                    }
                    case 0: {
                        value = this.readByte(content);
                        break;
                    }
                    case 1: {
                        value = this.readByteArray(content);
                        break;
                    }
                    case 2: {
                        value = this.readByteArray2D(content);
                        break;
                    }
                    case 122: {
                        value = this.readByteBuffer(content);
                        break;
                    }
                    case 30: {
                        value = this.readDouble(content);
                        break;
                    }
                    case 31: {
                        value = this.readDoubleArray(content);
                        break;
                    }
                    case 32: {
                        value = this.readDoubleArray2D(content);
                        break;
                    }
                    case 20: {
                        value = Float.valueOf(this.readFloat(content));
                        break;
                    }
                    case 21: {
                        value = this.readFloatArray(content);
                        break;
                    }
                    case 22: {
                        value = this.readFloatArray2D(content);
                        break;
                    }
                    case 120: {
                        value = this.readFloatBuffer(content);
                        break;
                    }
                    case 110: {
                        value = this.readFloatBufferArrayList(content);
                        break;
                    }
                    case 111: {
                        value = this.readByteBufferArrayList(content);
                        break;
                    }
                    case 10: {
                        value = this.readInt(content);
                        break;
                    }
                    case 11: {
                        value = this.readIntArray(content);
                        break;
                    }
                    case 12: {
                        value = this.readIntArray2D(content);
                        break;
                    }
                    case 121: {
                        value = this.readIntBuffer(content);
                        break;
                    }
                    case 40: {
                        value = this.readLong(content);
                        break;
                    }
                    case 41: {
                        value = this.readLongArray(content);
                        break;
                    }
                    case 42: {
                        value = this.readLongArray2D(content);
                        break;
                    }
                    case 90: {
                        value = this.readSavable(content);
                        break;
                    }
                    case 91: {
                        value = this.readSavableArray(content);
                        break;
                    }
                    case 92: {
                        value = this.readSavableArray2D(content);
                        break;
                    }
                    case 100: {
                        value = this.readSavableArray(content);
                        break;
                    }
                    case 101: {
                        value = this.readSavableArray2D(content);
                        break;
                    }
                    case 102: {
                        value = this.readSavableArray3D(content);
                        break;
                    }
                    case 105: {
                        value = this.readSavableMap(content);
                        break;
                    }
                    case 106: {
                        value = this.readStringSavableMap(content);
                        break;
                    }
                    case 50: {
                        value = this.readShort(content);
                        break;
                    }
                    case 51: {
                        value = this.readShortArray(content);
                        break;
                    }
                    case 52: {
                        value = this.readShortArray2D(content);
                        break;
                    }
                    case 123: {
                        value = this.readShortBuffer(content);
                        break;
                    }
                    case 70: {
                        value = this.readString(content);
                        break;
                    }
                    case 71: {
                        value = this.readStringArray(content);
                        break;
                    }
                    case 72: {
                        value = this.readStringArray2D(content);
                        break;
                    }
                    default: {
                        continue block43;
                    }
                }
                this._fieldData.put(alias, value);
            }
            catch (IOException e) {
                logger.logp(Level.SEVERE, this.getClass().toString(), "setContent(byte[] content)", "Exception", e);
            }
        }
    }

    public BitSet readBitSet(String name, BitSet defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (BitSet)this._fieldData.get(field._alias);
    }

    public boolean readBoolean(String name, boolean defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (Boolean)this._fieldData.get(field._alias);
    }

    public boolean[] readBooleanArray(String name, boolean[] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (boolean[])this._fieldData.get(field._alias);
    }

    public boolean[][] readBooleanArray2D(String name, boolean[][] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (boolean[][])this._fieldData.get(field._alias);
    }

    public byte readByte(String name, byte defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (Byte)this._fieldData.get(field._alias);
    }

    public byte[] readByteArray(String name, byte[] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (byte[])this._fieldData.get(field._alias);
    }

    public byte[][] readByteArray2D(String name, byte[][] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (byte[][])this._fieldData.get(field._alias);
    }

    public ByteBuffer readByteBuffer(String name, ByteBuffer defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (ByteBuffer)this._fieldData.get(field._alias);
    }

    public List<ByteBuffer> readByteBufferList(String name, List<ByteBuffer> defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (List)this._fieldData.get(field._alias);
    }

    public double readDouble(String name, double defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (Double)this._fieldData.get(field._alias);
    }

    public double[] readDoubleArray(String name, double[] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (double[])this._fieldData.get(field._alias);
    }

    public double[][] readDoubleArray2D(String name, double[][] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (double[][])this._fieldData.get(field._alias);
    }

    public float readFloat(String name, float defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return ((Float)this._fieldData.get(field._alias)).floatValue();
    }

    public float[] readFloatArray(String name, float[] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (float[])this._fieldData.get(field._alias);
    }

    public float[][] readFloatArray2D(String name, float[][] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (float[][])this._fieldData.get(field._alias);
    }

    public FloatBuffer readFloatBuffer(String name, FloatBuffer defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (FloatBuffer)this._fieldData.get(field._alias);
    }

    public List<FloatBuffer> readFloatBufferList(String name, List<FloatBuffer> defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (List)this._fieldData.get(field._alias);
    }

    public int readInt(String name, int defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (Integer)this._fieldData.get(field._alias);
    }

    public int[] readIntArray(String name, int[] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (int[])this._fieldData.get(field._alias);
    }

    public int[][] readIntArray2D(String name, int[][] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (int[][])this._fieldData.get(field._alias);
    }

    public IntBuffer readIntBuffer(String name, IntBuffer defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (IntBuffer)this._fieldData.get(field._alias);
    }

    public long readLong(String name, long defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (Long)this._fieldData.get(field._alias);
    }

    public long[] readLongArray(String name, long[] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (long[])this._fieldData.get(field._alias);
    }

    public long[][] readLongArray2D(String name, long[][] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (long[][])this._fieldData.get(field._alias);
    }

    public Savable readSavable(String name, Savable defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        Object value = this._fieldData.get(field._alias);
        if (value == null) {
            return null;
        }
        if (value instanceof ID) {
            value = this._importer.readObject(((ID)value).id);
            this._fieldData.put(field._alias, value);
            return (Savable)value;
        }
        return defVal;
    }

    public Savable[] readSavableArray(String name, Savable[] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        Object[] values = (Object[])this._fieldData.get(field._alias);
        if (values instanceof ID[]) {
            values = this.resolveIDs(values);
            this._fieldData.put(field._alias, values);
            return (Savable[])values;
        }
        return defVal;
    }

    private Savable[] resolveIDs(Object[] values) {
        if (values != null) {
            Savable[] savables = new Savable[values.length];
            for (int i = 0; i < values.length; ++i) {
                ID id = (ID)values[i];
                savables[i] = id != null ? this._importer.readObject(id.id) : null;
            }
            return savables;
        }
        return null;
    }

    public Savable[][] readSavableArray2D(String name, Savable[][] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        Object[][] values = (Object[][])this._fieldData.get(field._alias);
        if (values instanceof ID[][]) {
            Savable[][] savables = new Savable[values.length][];
            for (int i = 0; i < values.length; ++i) {
                savables[i] = values[i] != null ? this.resolveIDs(values[i]) : null;
            }
            values = savables;
            this._fieldData.put(field._alias, values);
        }
        return (Savable[][])values;
    }

    public Savable[][][] readSavableArray3D(String name, Savable[][][] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        Object[][][] values = (Object[][][])this._fieldData.get(field._alias);
        if (values instanceof ID[][][]) {
            Savable[][][] savables = new Savable[values.length][][];
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != null) {
                    savables[i] = new Savable[values[i].length][];
                    for (int j = 0; j < values[i].length; ++j) {
                        savables[i][j] = this.resolveIDs(values[i][j]);
                    }
                    continue;
                }
                savables[i] = null;
            }
            this._fieldData.put(field._alias, savables);
            return savables;
        }
        return defVal;
    }

    private List<Savable> savableArrayListFromArray(Savable[] savables) {
        if (savables == null) {
            return null;
        }
        ArrayList<Savable> list = new ArrayList<Savable>(savables.length);
        for (int x = 0; x < savables.length; ++x) {
            list.add(savables[x]);
        }
        return list;
    }

    private Map<Savable, Savable> savableMapFrom2DArray(Savable[][] savables) {
        if (savables == null) {
            return null;
        }
        HashMap<Savable, Savable> map = new HashMap<Savable, Savable>(savables.length);
        for (int x = 0; x < savables.length; ++x) {
            map.put(savables[x][0], savables[x][1]);
        }
        return map;
    }

    private Map<String, Savable> stringSavableMapFromKV(String[] keys, Savable[] values) {
        if (keys == null || values == null) {
            return null;
        }
        HashMap<String, Savable> map = new HashMap<String, Savable>(keys.length);
        for (int x = 0; x < keys.length; ++x) {
            map.put(keys[x], values[x]);
        }
        return map;
    }

    public <E extends Savable> List<E> readSavableList(String name, List<E> defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        List<Savable> value = this._fieldData.get(field._alias);
        if (value instanceof ID[]) {
            Savable[] savables = this.readSavableArray(name, null);
            value = this.savableArrayListFromArray(savables);
            this._fieldData.put(field._alias, value);
        }
        return value;
    }

    public <E extends Savable> List<E>[] readSavableListArray(String name, List<E>[] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        List<E>[] value = this._fieldData.get(field._alias);
        if (value instanceof ID[][]) {
            Savable[][] savables = this.readSavableArray2D(name, null);
            if (savables != null) {
                ArrayList[] arrayLists = new ArrayList[savables.length];
                for (int i = 0; i < savables.length; ++i) {
                    arrayLists[i] = this.savableArrayListFromArray(savables[i]);
                }
                value = arrayLists;
            } else {
                value = defVal;
            }
            this._fieldData.put(field._alias, value);
        }
        return value;
    }

    public <E extends Savable> List<E>[][] readSavableListArray2D(String name, List<E>[][] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        List<E>[][] value = this._fieldData.get(field._alias);
        if (value instanceof ID[][][]) {
            Savable[][][] savables = this.readSavableArray3D(name, null);
            if (savables != null && savables.length > 0) {
                ArrayList[][] arrayLists = new ArrayList[savables.length][];
                for (int i = 0; i < savables.length; ++i) {
                    arrayLists[i] = new ArrayList[savables[i].length];
                    for (int j = 0; j < savables[i].length; ++j) {
                        arrayLists[i][j] = this.savableArrayListFromArray(savables[i][j]);
                    }
                }
                value = arrayLists;
            } else {
                value = defVal;
            }
            this._fieldData.put(field._alias, value);
        }
        return value;
    }

    public <K extends Savable, V extends Savable> Map<K, V> readSavableMap(String name, Map<K, V> defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        Map<Savable, Savable> value = this._fieldData.get(field._alias);
        if (value instanceof ID[][]) {
            Savable[][] savables = this.readSavableArray2D(name, null);
            value = this.savableMapFrom2DArray(savables);
            this._fieldData.put(field._alias, value);
        }
        return value;
    }

    public <V extends Savable> Map<String, V> readStringSavableMap(String name, Map<String, V> defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        Map<String, Savable> value = this._fieldData.get(field._alias);
        if (value instanceof StringIDMap) {
            StringIDMap in = (StringIDMap)((Object)value);
            Savable[] values = this.resolveIDs(in.values);
            value = this.stringSavableMapFromKV(in.keys, values);
            this._fieldData.put(field._alias, value);
        }
        return value;
    }

    public short readShort(String name, short defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (Short)this._fieldData.get(field._alias);
    }

    public short[] readShortArray(String name, short[] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (short[])this._fieldData.get(field._alias);
    }

    public short[][] readShortArray2D(String name, short[][] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (short[][])this._fieldData.get(field._alias);
    }

    public ShortBuffer readShortBuffer(String name, ShortBuffer defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (ShortBuffer)this._fieldData.get(field._alias);
    }

    public String readString(String name, String defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (String)this._fieldData.get(field._alias);
    }

    public String[] readStringArray(String name, String[] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (String[])this._fieldData.get(field._alias);
    }

    public String[][] readStringArray2D(String name, String[][] defVal) throws IOException {
        BinaryClassField field = this._cObj._nameFields.get(name);
        if (field == null || !this._fieldData.containsKey(field._alias)) {
            return defVal;
        }
        return (String[][])this._fieldData.get(field._alias);
    }

    protected byte readByte(byte[] content) throws IOException {
        byte value = content[this._index];
        ++this._index;
        return value;
    }

    protected byte[] readByteArray(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        byte[] value = new byte[length];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readByte(content);
        }
        return value;
    }

    protected byte[][] readByteArray2D(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        byte[][] value = new byte[length][];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readByteArray(content);
        }
        return value;
    }

    protected int readInt(byte[] content) throws IOException {
        byte[] bytes = BinaryInputCapsule.inflateFrom(content, this._index);
        this._index += 1 + bytes.length;
        int value = ByteUtils.convertIntFromBytes((byte[])(bytes = ByteUtils.rightAlignBytes((byte[])bytes, (int)4)));
        if (value == -1 || value == -2) {
            this._index -= 4;
        }
        return value;
    }

    protected int[] readIntArray(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        int[] value = new int[length];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readInt(content);
        }
        return value;
    }

    protected int[][] readIntArray2D(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        int[][] value = new int[length][];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readIntArray(content);
        }
        return value;
    }

    protected float readFloat(byte[] content) throws IOException {
        float value = ByteUtils.convertFloatFromBytes((byte[])content, (int)this._index);
        this._index += 4;
        return value;
    }

    protected float[] readFloatArray(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        float[] value = new float[length];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readFloat(content);
        }
        return value;
    }

    protected float[][] readFloatArray2D(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        float[][] value = new float[length][];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readFloatArray(content);
        }
        return value;
    }

    protected double readDouble(byte[] content) throws IOException {
        double value = ByteUtils.convertDoubleFromBytes((byte[])content, (int)this._index);
        this._index += 8;
        return value;
    }

    protected double[] readDoubleArray(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        double[] value = new double[length];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readDouble(content);
        }
        return value;
    }

    protected double[][] readDoubleArray2D(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        double[][] value = new double[length][];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readDoubleArray(content);
        }
        return value;
    }

    protected long readLong(byte[] content) throws IOException {
        byte[] bytes = BinaryInputCapsule.inflateFrom(content, this._index);
        this._index += 1 + bytes.length;
        bytes = ByteUtils.rightAlignBytes((byte[])bytes, (int)8);
        long value = ByteUtils.convertLongFromBytes((byte[])bytes);
        return value;
    }

    protected long[] readLongArray(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        long[] value = new long[length];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readLong(content);
        }
        return value;
    }

    protected long[][] readLongArray2D(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        long[][] value = new long[length][];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readLongArray(content);
        }
        return value;
    }

    protected short readShort(byte[] content) throws IOException {
        short value = ByteUtils.convertShortFromBytes((byte[])content, (int)this._index);
        this._index += 2;
        return value;
    }

    protected short[] readShortArray(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        short[] value = new short[length];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readShort(content);
        }
        return value;
    }

    protected short[][] readShortArray2D(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        short[][] value = new short[length][];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readShortArray(content);
        }
        return value;
    }

    protected boolean readBoolean(byte[] content) throws IOException {
        boolean value = ByteUtils.convertBooleanFromBytes((byte[])content, (int)this._index);
        ++this._index;
        return value;
    }

    protected boolean[] readBooleanArray(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        boolean[] value = new boolean[length];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readBoolean(content);
        }
        return value;
    }

    protected boolean[][] readBooleanArray2D(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        boolean[][] value = new boolean[length][];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readBooleanArray(content);
        }
        return value;
    }

    protected String readString(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        byte[] bytes = new byte[length];
        int utf8State = 0;
        block6: for (int x = 0; x < length; ++x) {
            bytes[x] = content[this._index++];
            int b = bytes[x] & 0xFF;
            switch (utf8State) {
                case 0: {
                    if (b < 128) continue block6;
                    if ((b & 0xC0) == 192) {
                        utf8State = 2;
                        continue block6;
                    }
                    if ((b & 0xE0) == 224) {
                        utf8State = 3;
                        continue block6;
                    }
                    utf8State = 10;
                    continue block6;
                }
                case 2: 
                case 3: 
                case 4: {
                    utf8State = (b & 0x80) == 128 ? (utf8State == 3 ? 4 : 0) : 10;
                }
            }
        }
        try {
            if (utf8State == 0) {
                return new String(bytes, "UTF8");
            }
            logger.log(Level.WARNING, "Your export has been saved with an incorrect encoding for it's String fields which means it might not load correctly due to encoding issues.");
            return new String(bytes, "ISO8859_1");
        }
        catch (UnsupportedEncodingException uee) {
            logger.log(Level.SEVERE, "Your export has been saved with an incorrect encoding or your version of Java is unable to decode the stored string. While your export may load correctly by falling back, using it on different platforms or java versions might lead to very strange inconsitenties. You should probably re-export your work.");
            return new String(bytes);
        }
    }

    protected String[] readStringArray(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        String[] value = new String[length];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readString(content);
        }
        return value;
    }

    protected String[][] readStringArray2D(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        String[][] value = new String[length][];
        for (int x = 0; x < length; ++x) {
            value[x] = this.readStringArray(content);
        }
        return value;
    }

    protected BitSet readBitSet(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        BitSet value = new BitSet(length);
        for (int x = 0; x < length; ++x) {
            value.set(x, this.readBoolean(content));
        }
        return value;
    }

    protected static byte[] inflateFrom(byte[] contents, int index) {
        byte firstByte = contents[index];
        if (firstByte == -1) {
            return ByteUtils.convertToBytes((int)-1);
        }
        if (firstByte == -2) {
            return ByteUtils.convertToBytes((int)-2);
        }
        if (firstByte == 0) {
            return new byte[0];
        }
        byte[] rVal = new byte[firstByte];
        for (int x = 0; x < rVal.length; ++x) {
            rVal[x] = contents[x + 1 + index];
        }
        return rVal;
    }

    protected ID readSavable(byte[] content) throws IOException {
        int id = this.readInt(content);
        if (id == -1) {
            return null;
        }
        return new ID(id);
    }

    protected ID[] readSavableArray(byte[] content) throws IOException {
        int elements = this.readInt(content);
        if (elements == -1) {
            return null;
        }
        ID[] rVal = new ID[elements];
        for (int x = 0; x < elements; ++x) {
            rVal[x] = this.readSavable(content);
        }
        return rVal;
    }

    protected ID[][] readSavableArray2D(byte[] content) throws IOException {
        int elements = this.readInt(content);
        if (elements == -1) {
            return null;
        }
        ID[][] rVal = new ID[elements][];
        for (int x = 0; x < elements; ++x) {
            rVal[x] = this.readSavableArray(content);
        }
        return rVal;
    }

    protected ID[][][] readSavableArray3D(byte[] content) throws IOException {
        int elements = this.readInt(content);
        if (elements == -1) {
            return null;
        }
        ID[][][] rVal = new ID[elements][][];
        for (int x = 0; x < elements; ++x) {
            rVal[x] = this.readSavableArray2D(content);
        }
        return rVal;
    }

    protected ID[][] readSavableMap(byte[] content) throws IOException {
        int elements = this.readInt(content);
        if (elements == -1) {
            return null;
        }
        ID[][] rVal = new ID[elements][];
        for (int x = 0; x < elements; ++x) {
            rVal[x] = this.readSavableArray(content);
        }
        return rVal;
    }

    protected StringIDMap readStringSavableMap(byte[] content) throws IOException {
        int elements = this.readInt(content);
        if (elements == -1) {
            return null;
        }
        String[] keys = this.readStringArray(content);
        ID[] values = this.readSavableArray(content);
        StringIDMap rVal = new StringIDMap();
        rVal.keys = keys;
        rVal.values = values;
        return rVal;
    }

    protected List<FloatBuffer> readFloatBufferArrayList(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        ArrayList<FloatBuffer> rVal = new ArrayList<FloatBuffer>(length);
        for (int x = 0; x < length; ++x) {
            rVal.add(this.readFloatBuffer(content));
        }
        return rVal;
    }

    protected List<ByteBuffer> readByteBufferArrayList(byte[] content) throws IOException {
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        ArrayList<ByteBuffer> rVal = new ArrayList<ByteBuffer>(length);
        for (int x = 0; x < length; ++x) {
            rVal.add(this.readByteBuffer(content));
        }
        return rVal;
    }

    protected FloatBuffer readFloatBuffer(byte[] content) throws IOException {
        boolean contentCopyRequired;
        FloatBuffer value;
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        boolean direct = this.readBoolean(content);
        ByteBuffer buf = ByteBuffer.allocateDirect(length * 4).order(ByteOrder.LITTLE_ENDIAN);
        buf.put(content, this._index, length * 4).rewind();
        this._index += length * 4;
        if (direct) {
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                value = buf.asFloatBuffer();
                contentCopyRequired = false;
            } else {
                value = BufferUtils.createFloatBuffer(length);
                contentCopyRequired = true;
            }
        } else {
            value = BufferUtils.createFloatBufferOnHeap(length);
            contentCopyRequired = true;
        }
        if (contentCopyRequired) {
            value.put(buf.asFloatBuffer());
            value.rewind();
        }
        return value;
    }

    protected IntBuffer readIntBuffer(byte[] content) throws IOException {
        boolean contentCopyRequired;
        IntBuffer value;
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        boolean direct = this.readBoolean(content);
        ByteBuffer buf = ByteBuffer.allocateDirect(length * 4).order(ByteOrder.LITTLE_ENDIAN);
        buf.put(content, this._index, length * 4).rewind();
        this._index += length * 4;
        if (direct) {
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                value = buf.asIntBuffer();
                contentCopyRequired = false;
            } else {
                value = BufferUtils.createIntBuffer(length);
                contentCopyRequired = true;
            }
        } else {
            value = BufferUtils.createIntBufferOnHeap(length);
            contentCopyRequired = true;
        }
        if (contentCopyRequired) {
            value.put(buf.asIntBuffer());
            value.rewind();
        }
        return value;
    }

    protected ShortBuffer readShortBuffer(byte[] content) throws IOException {
        boolean contentCopyRequired;
        ShortBuffer value;
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        boolean direct = this.readBoolean(content);
        ByteBuffer buf = ByteBuffer.allocateDirect(length * 2).order(ByteOrder.LITTLE_ENDIAN);
        buf.put(content, this._index, length * 2).rewind();
        this._index += length * 2;
        if (direct) {
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                value = buf.asShortBuffer();
                contentCopyRequired = false;
            } else {
                value = BufferUtils.createShortBuffer(length);
                contentCopyRequired = true;
            }
        } else {
            value = BufferUtils.createShortBufferOnHeap(length);
            contentCopyRequired = true;
        }
        if (contentCopyRequired) {
            value.put(buf.asShortBuffer());
            value.rewind();
        }
        return value;
    }

    protected ByteBuffer readByteBuffer(byte[] content) throws IOException {
        boolean contentCopyRequired;
        ByteBuffer value;
        int length = this.readInt(content);
        if (length == -1) {
            return null;
        }
        boolean direct = this.readBoolean(content);
        ByteBuffer buf = ByteBuffer.allocateDirect(length).order(ByteOrder.LITTLE_ENDIAN);
        buf.put(content, this._index, length).rewind();
        this._index += length;
        if (direct) {
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                value = buf;
                contentCopyRequired = false;
            } else {
                value = BufferUtils.createByteBuffer(length);
                contentCopyRequired = true;
            }
        } else {
            value = BufferUtils.createByteBufferOnHeap(length);
            contentCopyRequired = true;
        }
        if (contentCopyRequired) {
            value.put(buf);
            value.rewind();
        }
        return value;
    }

    public <T extends Enum<T>> T readEnum(String name, Class<T> enumType, T defVal) throws IOException {
        String eVal = this.readString(name, defVal != null ? defVal.name() : null);
        if (eVal != null) {
            return Enum.valueOf(enumType, eVal);
        }
        return null;
    }

    public <T extends Enum<T>> T[] readEnumArray(String name, Class<T> enumType, T[] defVal) throws IOException {
        String[] eVals = this.readStringArray(name, null);
        if (eVals != null) {
            Enum[] rVal = (Enum[])Array.newInstance(enumType, eVals.length);
            int i = 0;
            for (String eVal : eVals) {
                rVal[i++] = Enum.valueOf(enumType, eVal);
            }
            return rVal;
        }
        return defVal;
    }

    private static class StringIDMap {
        public String[] keys;
        public ID[] values;

        private StringIDMap() {
        }
    }

    private static class ID {
        public int id;

        public ID(int id) {
            this.id = id;
        }
    }
}

