/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.export.binary;

import com.ardor3d.util.export.ByteUtils;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.export.binary.BinaryClassField;
import com.ardor3d.util.export.binary.BinaryClassObject;
import com.ardor3d.util.export.binary.BinaryExporter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;

public class BinaryOutputCapsule
implements OutputCapsule {
    public static final int NULL_OBJECT = -1;
    public static final int DEFAULT_OBJECT = -2;
    public static byte[] NULL_BYTES = new byte[]{-1};
    public static byte[] DEFAULT_BYTES = new byte[]{-2};
    protected ByteArrayOutputStream _baos = new ByteArrayOutputStream();
    protected byte[] _bytes;
    protected BinaryExporter _exporter;
    protected BinaryClassObject _cObj;
    protected boolean _forceDirectNioBuffers;

    public BinaryOutputCapsule(BinaryExporter exporter, BinaryClassObject bco) {
        this(exporter, bco, false);
    }

    public BinaryOutputCapsule(BinaryExporter exporter, BinaryClassObject bco, boolean forceDirectNioBuffers) {
        this._exporter = exporter;
        this._cObj = bco;
        this._forceDirectNioBuffers = forceDirectNioBuffers;
    }

    public void write(byte value, String name, byte defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)0);
        this.write(value);
    }

    public void write(byte[] value, String name, byte[] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)1);
        this.write(value);
    }

    public void write(byte[][] value, String name, byte[][] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)2);
        this.write(value);
    }

    public void write(int value, String name, int defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)10);
        this.write(value);
    }

    public void write(int[] value, String name, int[] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)11);
        this.write(value);
    }

    public void write(int[][] value, String name, int[][] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)12);
        this.write(value);
    }

    public void write(float value, String name, float defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)20);
        this.write(value);
    }

    public void write(float[] value, String name, float[] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)21);
        this.write(value);
    }

    public void write(float[][] value, String name, float[][] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)22);
        this.write(value);
    }

    public void write(double value, String name, double defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)30);
        this.write(value);
    }

    public void write(double[] value, String name, double[] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)31);
        this.write(value);
    }

    public void write(double[][] value, String name, double[][] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)32);
        this.write(value);
    }

    public void write(long value, String name, long defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)40);
        this.write(value);
    }

    public void write(long[] value, String name, long[] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)41);
        this.write(value);
    }

    public void write(long[][] value, String name, long[][] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)42);
        this.write(value);
    }

    public void write(short value, String name, short defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)50);
        this.write(value);
    }

    public void write(short[] value, String name, short[] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)51);
        this.write(value);
    }

    public void write(short[][] value, String name, short[][] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)52);
        this.write(value);
    }

    public void write(boolean value, String name, boolean defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)60);
        this.write(value);
    }

    public void write(boolean[] value, String name, boolean[] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)61);
        this.write(value);
    }

    public void write(boolean[][] value, String name, boolean[][] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)62);
        this.write(value);
    }

    public void write(String value, String name, String defVal) throws IOException {
        if (value == null ? defVal == null : value.equals(defVal)) {
            return;
        }
        this.writeAlias(name, (byte)70);
        this.write(value);
    }

    public void write(String[] value, String name, String[] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)71);
        this.write(value);
    }

    public void write(String[][] value, String name, String[][] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)72);
        this.write(value);
    }

    public void write(BitSet value, String name, BitSet defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)80);
        this.write(value);
    }

    public void write(Savable object, String name, Savable defVal) throws IOException {
        if (object == defVal) {
            return;
        }
        this.writeAlias(name, (byte)90);
        this.write(object);
    }

    public void write(Savable[] objects, String name, Savable[] defVal) throws IOException {
        if (objects == defVal) {
            return;
        }
        this.writeAlias(name, (byte)91);
        this.write(objects);
    }

    public void write(Savable[][] objects, String name, Savable[][] defVal) throws IOException {
        if (objects == defVal) {
            return;
        }
        this.writeAlias(name, (byte)92);
        this.write(objects);
    }

    public void write(FloatBuffer value, String name, FloatBuffer defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)120);
        this.write(value);
    }

    public void write(IntBuffer value, String name, IntBuffer defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)121);
        this.write(value);
    }

    public void write(ByteBuffer value, String name, ByteBuffer defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)122);
        this.write(value);
    }

    public void write(ShortBuffer value, String name, ShortBuffer defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)123);
        this.write(value);
    }

    public void writeFloatBufferList(List<FloatBuffer> array, String name, List<FloatBuffer> defVal) throws IOException {
        if (array == defVal) {
            return;
        }
        this.writeAlias(name, (byte)110);
        this.writeFloatBufferArrayList(array);
    }

    public void writeByteBufferList(List<ByteBuffer> array, String name, List<ByteBuffer> defVal) throws IOException {
        if (array == defVal) {
            return;
        }
        this.writeAlias(name, (byte)111);
        this.writeByteBufferArrayList(array);
    }

    public void writeSavableList(List<? extends Savable> array, String name, List<? extends Savable> defVal) throws IOException {
        if (array == defVal) {
            return;
        }
        this.writeAlias(name, (byte)100);
        this.writeSavableArrayList(array);
    }

    public void writeSavableListArray(List<? extends Savable>[] array, String name, List<? extends Savable>[] defVal) throws IOException {
        if (array == defVal) {
            return;
        }
        this.writeAlias(name, (byte)101);
        this.writeSavableArrayListArray(array);
    }

    public void writeSavableListArray2D(List<? extends Savable>[][] array, String name, List<? extends Savable>[][] defVal) throws IOException {
        if (array == defVal) {
            return;
        }
        this.writeAlias(name, (byte)102);
        this.writeSavableArrayListArray2D(array);
    }

    public void writeSavableMap(Map<? extends Savable, ? extends Savable> map, String name, Map<? extends Savable, ? extends Savable> defVal) throws IOException {
        if (map == defVal) {
            return;
        }
        this.writeAlias(name, (byte)105);
        this.writeSavableMap(map);
    }

    public void writeStringSavableMap(Map<String, ? extends Savable> map, String name, Map<String, ? extends Savable> defVal) throws IOException {
        if (map == defVal) {
            return;
        }
        this.writeAlias(name, (byte)106);
        this.writeStringSavableMap(map);
    }

    protected void writeAlias(String name, byte fieldType) throws IOException {
        if (this._cObj._nameFields.get(name) == null) {
            this.generateAlias(name, fieldType);
        }
        byte alias = this._cObj._nameFields.get((Object)name)._alias;
        this.write(alias);
    }

    protected void generateAlias(String name, byte type) {
        byte alias = (byte)this._cObj._nameFields.size();
        this._cObj._nameFields.put(name, new BinaryClassField(name, alias, type));
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof BinaryOutputCapsule)) {
            return false;
        }
        byte[] other = ((BinaryOutputCapsule)arg0)._bytes;
        if (this._bytes.length != other.length) {
            return false;
        }
        return Arrays.equals(this._bytes, other);
    }

    public int hashCode() {
        return Arrays.hashCode(this._bytes);
    }

    public void finish() {
        this._bytes = this._baos.toByteArray();
        this._baos = null;
    }

    protected void write(byte value) throws IOException {
        this._baos.write(value);
    }

    protected void write(byte[] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        this._baos.write(value);
    }

    protected void write(byte[][] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(int value) throws IOException {
        this._baos.write(BinaryOutputCapsule.deflate(ByteUtils.convertToBytes((int)value)));
    }

    protected void write(int[] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(int[][] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(float value) throws IOException {
        this._baos.write(ByteUtils.convertToBytes((float)value));
    }

    protected void write(float[] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(float[][] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(double value) throws IOException {
        this._baos.write(ByteUtils.convertToBytes((double)value));
    }

    protected void write(double[] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(double[][] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(long value) throws IOException {
        this._baos.write(BinaryOutputCapsule.deflate(ByteUtils.convertToBytes((long)value)));
    }

    protected void write(long[] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(long[][] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(short value) throws IOException {
        this._baos.write(ByteUtils.convertToBytes((short)value));
    }

    protected void write(short[] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(short[][] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(boolean value) throws IOException {
        this._baos.write(ByteUtils.convertToBytes((boolean)value));
    }

    protected void write(boolean[] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(boolean[][] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(String value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        byte[] bytes = value.getBytes("UTF8");
        this.write(bytes.length);
        this._baos.write(bytes);
    }

    protected void write(String[] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(String[][] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(BitSet value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.size());
        int max = value.size();
        for (int x = 0; x < max; ++x) {
            this.write(value.get(x));
        }
    }

    protected static byte[] deflate(byte[] bytes) {
        int size = bytes.length;
        if (size == 4) {
            int possibleMagic = ByteUtils.convertIntFromBytes((byte[])bytes);
            if (possibleMagic == -1) {
                return NULL_BYTES;
            }
            if (possibleMagic == -2) {
                return DEFAULT_BYTES;
            }
        }
        for (int x = 0; x < bytes.length && bytes[x] == 0; ++x) {
            --size;
        }
        if (size == 0) {
            return new byte[1];
        }
        byte[] rVal = new byte[1 + size];
        rVal[0] = (byte)size;
        for (int x = 1; x < rVal.length; ++x) {
            rVal[x] = bytes[bytes.length - size - 1 + x];
        }
        return rVal;
    }

    protected void write(Savable object) throws IOException {
        if (object == null) {
            this.write(-1);
            return;
        }
        int id = this._exporter.processBinarySavable(object);
        this.write(id);
    }

    protected void write(Savable[] objects) throws IOException {
        if (objects == null) {
            this.write(-1);
            return;
        }
        this.write(objects.length);
        for (int x = 0; x < objects.length; ++x) {
            this.write(objects[x]);
        }
    }

    protected void write(Savable[][] objects) throws IOException {
        if (objects == null) {
            this.write(-1);
            return;
        }
        this.write(objects.length);
        for (int x = 0; x < objects.length; ++x) {
            this.write(objects[x]);
        }
    }

    protected void writeSavableArrayList(List<? extends Savable> array) throws IOException {
        if (array == null) {
            this.write(-1);
            return;
        }
        this.write(array.size());
        for (Savable savable : array) {
            this.write(savable);
        }
    }

    protected void writeSavableArrayListArray(List<? extends Savable>[] array) throws IOException {
        if (array == null) {
            this.write(-1);
            return;
        }
        this.write(array.length);
        for (List<? extends Savable> bs : array) {
            this.writeSavableArrayList(bs);
        }
    }

    protected void writeSavableArrayListArray2D(List<? extends Savable>[][] array) throws IOException {
        if (array == null) {
            this.write(-1);
            return;
        }
        this.write(array.length);
        for (List<? extends Savable>[] bs : array) {
            this.writeSavableArrayListArray(bs);
        }
    }

    protected void writeSavableMap(Map<? extends Savable, ? extends Savable> array) throws IOException {
        if (array == null) {
            this.write(-1);
            return;
        }
        this.write(array.size());
        for (Map.Entry<? extends Savable, ? extends Savable> entry : array.entrySet()) {
            this.write(new Savable[]{entry.getKey(), entry.getValue()});
        }
    }

    protected void writeStringSavableMap(Map<String, ? extends Savable> array) throws IOException {
        if (array == null) {
            this.write(-1);
            return;
        }
        this.write(array.size());
        String[] keys = array.keySet().toArray(new String[array.keySet().size()]);
        this.write(keys);
        Savable[] values = array.values().toArray(new Savable[array.values().size()]);
        this.write(values);
    }

    protected void writeFloatBufferArrayList(List<FloatBuffer> array) throws IOException {
        if (array == null) {
            this.write(-1);
            return;
        }
        this.write(array.size());
        for (FloatBuffer buf : array) {
            this.write(buf);
        }
    }

    protected void writeByteBufferArrayList(List<ByteBuffer> array) throws IOException {
        if (array == null) {
            this.write(-1);
            return;
        }
        this.write(array.size());
        for (ByteBuffer buf : array) {
            this.write(buf);
        }
    }

    protected void write(FloatBuffer source) throws IOException {
        if (source == null) {
            this.write(-1);
            return;
        }
        int sizeof = 4;
        int length = source.limit();
        this.write(length);
        this.write(this._forceDirectNioBuffers || source.isDirect());
        byte[] array = new byte[length * 4];
        if (source.hasArray()) {
            float[] backingArray = source.array();
            ByteBuffer buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < backingArray.length; ++i) {
                buf.putFloat(backingArray[i]).rewind();
                buf.get(array, i * 4, 4).rewind();
            }
        } else {
            FloatBuffer value = source.duplicate();
            ByteBuffer buf = ByteBuffer.allocate(array.length).order(ByteOrder.LITTLE_ENDIAN);
            value.rewind();
            buf.asFloatBuffer().put(value);
            buf.rewind();
            buf.get(array);
        }
        this._baos.write(array);
    }

    protected void write(IntBuffer source) throws IOException {
        if (source == null) {
            this.write(-1);
            return;
        }
        int sizeof = 4;
        int length = source.limit();
        this.write(length);
        this.write(this._forceDirectNioBuffers || source.isDirect());
        byte[] array = new byte[length * 4];
        if (source.hasArray()) {
            int[] backingArray = source.array();
            ByteBuffer buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < backingArray.length; ++i) {
                buf.putInt(backingArray[i]).rewind();
                buf.get(array, i * 4, 4).rewind();
            }
        } else {
            IntBuffer value = source.duplicate();
            ByteBuffer buf = ByteBuffer.allocate(array.length).order(ByteOrder.LITTLE_ENDIAN);
            value.rewind();
            buf.asIntBuffer().put(value);
            buf.rewind();
            buf.get(array);
        }
        this._baos.write(array);
    }

    protected void write(ShortBuffer source) throws IOException {
        if (source == null) {
            this.write(-1);
            return;
        }
        int sizeof = 2;
        int length = source.limit();
        this.write(length);
        this.write(this._forceDirectNioBuffers || source.isDirect());
        byte[] array = new byte[length * 2];
        if (source.hasArray()) {
            short[] backingArray = source.array();
            ByteBuffer buf = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < backingArray.length; ++i) {
                buf.putShort(backingArray[i]).rewind();
                buf.get(array, i * 2, 2).rewind();
            }
        } else {
            ShortBuffer value = source.duplicate();
            ByteBuffer buf = ByteBuffer.allocate(array.length).order(ByteOrder.LITTLE_ENDIAN);
            value.rewind();
            buf.asShortBuffer().put(value);
            buf.rewind();
            buf.get(array);
        }
        this._baos.write(array);
    }

    protected void write(ByteBuffer source) throws IOException {
        byte[] array;
        if (source == null) {
            this.write(-1);
            return;
        }
        int length = source.limit();
        this.write(length);
        this.write(this._forceDirectNioBuffers || source.isDirect());
        if (source.hasArray()) {
            array = source.array();
        } else {
            ByteBuffer value = source.duplicate();
            array = new byte[length];
            value.rewind();
            value.get(array);
        }
        this._baos.write(array);
    }

    public void write(Enum<?> value, String name, Enum<?> defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        if (value == null) {
            this.write(-1);
        } else {
            this.write(value.name(), name, null);
        }
    }

    public void write(Enum<?>[] value, String name) throws IOException {
        if (value == null) {
            this.write(-1);
        } else {
            String[] toWrite = new String[value.length];
            int i = 0;
            for (Enum<?> val : value) {
                toWrite[i++] = val.name();
            }
            this.write(toWrite, name, null);
        }
    }
}

