/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.export.xml;

import com.ardor3d.annotation.SavableFactory;
import com.ardor3d.image.Texture;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.TextureState;
import com.ardor3d.util.Ardor3dException;
import com.ardor3d.util.TextureKey;
import com.ardor3d.util.TextureManager;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMInputCapsule
implements InputCapsule {
    private final Document _doc;
    private Element _currentElem;
    private boolean _isAtRoot = true;
    private final Map<String, Savable> _referencedSavables = new HashMap<String, Savable>();

    public DOMInputCapsule(Document doc) {
        this._doc = doc;
        this._currentElem = doc.getDocumentElement();
    }

    private static String decodeString(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("\\&quot;", "\"").replaceAll("\\&lt;", "<").replaceAll("\\&amp;", "&");
        return s;
    }

    private Element findFirstChildElement(Element parent) {
        Node ret;
        for (ret = parent.getFirstChild(); ret != null && !(ret instanceof Element); ret = ret.getNextSibling()) {
        }
        return (Element)ret;
    }

    private Element findChildElement(Element parent, String name) {
        Node ret;
        if (parent == null) {
            return null;
        }
        for (ret = parent.getFirstChild(); !(ret == null || ret instanceof Element && ret.getNodeName().equals(name)); ret = ret.getNextSibling()) {
        }
        return (Element)ret;
    }

    private Element findNextSiblingElement(Element current) {
        for (Node ret = current.getNextSibling(); ret != null; ret = ret.getNextSibling()) {
            if (!(ret instanceof Element)) continue;
            return (Element)ret;
        }
        return null;
    }

    public byte readByte(String name, byte defVal) throws IOException {
        byte ret = defVal;
        try {
            ret = Byte.parseByte(this._currentElem.getAttribute(name));
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public byte[] readByteArray(String name, byte[] defVal) throws IOException {
        byte[] ret = defVal;
        try {
            Element tmpEl = name != null ? this.findChildElement(this._currentElem, name) : this._currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            byte[] tmp = new byte[size];
            String[] strings = tmpEl.getAttribute("data").split("\\s+");
            for (int i = 0; i < size; ++i) {
                tmp[i] = Byte.parseByte(strings[i]);
            }
            ret = tmp;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public byte[][] readByteArray2D(String name, byte[][] defVal) throws IOException {
        Object ret = defVal;
        try {
            Element tmpEl = name != null ? this.findChildElement(this._currentElem, name) : this._currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            byte[][] tmp = new byte[size][];
            NodeList nodes = this._currentElem.getChildNodes();
            int strIndex = 0;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (!(n instanceof Element) || !n.getNodeName().contains("array")) continue;
                if (strIndex < size) {
                    tmp[strIndex++] = this.readByteArray(n.getNodeName(), null);
                    continue;
                }
                throw new IOException("String array contains more elements than specified!");
            }
            ret = tmp;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        this._currentElem = (Element)this._currentElem.getParentNode();
        return ret;
    }

    public int readInt(String name, int defVal) throws IOException {
        int ret = defVal;
        try {
            String s = this._currentElem.getAttribute(name);
            if (s.length() > 0) {
                ret = Integer.parseInt(s);
            }
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public int[] readIntArray(String name, int[] defVal) throws IOException {
        int[] ret = defVal;
        try {
            Element tmpEl = name != null ? this.findChildElement(this._currentElem, name) : this._currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            int[] tmp = new int[size];
            String[] strings = tmpEl.getAttribute("data").split("\\s+");
            for (int i = 0; i < size; ++i) {
                tmp[i] = Integer.parseInt(strings[i]);
            }
            ret = tmp;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public int[][] readIntArray2D(String name, int[][] defVal) throws IOException {
        Object ret = defVal;
        try {
            Element tmpEl = name != null ? this.findChildElement(this._currentElem, name) : this._currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            int[][] tmp = new int[size][];
            NodeList nodes = this._currentElem.getChildNodes();
            int strIndex = 0;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (!(n instanceof Element) || !n.getNodeName().contains("array")) continue;
                if (strIndex < size) {
                    tmp[strIndex++] = this.readIntArray(n.getNodeName(), null);
                    continue;
                }
                throw new IOException("String array contains more elements than specified!");
            }
            ret = tmp;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        this._currentElem = (Element)this._currentElem.getParentNode();
        return ret;
    }

    public float readFloat(String name, float defVal) throws IOException {
        float ret = defVal;
        try {
            String s = this._currentElem.getAttribute(name);
            if (s.length() > 0) {
                ret = Float.parseFloat(s);
            }
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public float[] readFloatArray(String name, float[] defVal) throws IOException {
        float[] ret = defVal;
        try {
            Element tmpEl = name != null ? this.findChildElement(this._currentElem, name) : this._currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            float[] tmp = new float[size];
            String[] strings = tmpEl.getAttribute("data").split("\\s+");
            for (int i = 0; i < size; ++i) {
                tmp[i] = Float.parseFloat(strings[i]);
            }
            ret = tmp;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public float[][] readFloatArray2D(String name, float[][] defVal) throws IOException {
        float[][] ret = defVal;
        try {
            Element tmpEl = name != null ? this.findChildElement(this._currentElem, name) : this._currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            int size_outer = Integer.parseInt(tmpEl.getAttribute("size_outer"));
            int size_inner = Integer.parseInt(tmpEl.getAttribute("size_outer"));
            float[][] tmp = new float[size_outer][size_inner];
            String[] strings = tmpEl.getAttribute("data").split("\\s+");
            for (int i = 0; i < size_outer; ++i) {
                tmp[i] = new float[size_inner];
                for (int k = 0; k < size_inner; ++k) {
                    tmp[i][k] = Float.parseFloat(strings[i]);
                }
            }
            ret = tmp;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public double readDouble(String name, double defVal) throws IOException {
        double ret = defVal;
        try {
            String s = this._currentElem.getAttribute(name);
            if (s.length() > 0) {
                ret = Double.parseDouble(s);
            }
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public double[] readDoubleArray(String name, double[] defVal) throws IOException {
        double[] ret = defVal;
        try {
            Element tmpEl = name != null ? this.findChildElement(this._currentElem, name) : this._currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            double[] tmp = new double[size];
            String[] strings = tmpEl.getAttribute("data").split("\\s+");
            for (int i = 0; i < size; ++i) {
                tmp[i] = Double.parseDouble(strings[i]);
            }
            ret = tmp;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public double[][] readDoubleArray2D(String name, double[][] defVal) throws IOException {
        Object ret = defVal;
        try {
            Element tmpEl = name != null ? this.findChildElement(this._currentElem, name) : this._currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            double[][] tmp = new double[size][];
            NodeList nodes = this._currentElem.getChildNodes();
            int strIndex = 0;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (!(n instanceof Element) || !n.getNodeName().contains("array")) continue;
                if (strIndex < size) {
                    tmp[strIndex++] = this.readDoubleArray(n.getNodeName(), null);
                    continue;
                }
                throw new IOException("String array contains more elements than specified!");
            }
            ret = tmp;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        this._currentElem = (Element)this._currentElem.getParentNode();
        return ret;
    }

    public long readLong(String name, long defVal) throws IOException {
        long ret = defVal;
        try {
            String s = this._currentElem.getAttribute(name);
            if (s.length() > 0) {
                ret = Long.parseLong(s);
            }
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public long[] readLongArray(String name, long[] defVal) throws IOException {
        long[] ret = defVal;
        try {
            Element tmpEl = name != null ? this.findChildElement(this._currentElem, name) : this._currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            long[] tmp = new long[size];
            String[] strings = tmpEl.getAttribute("data").split("\\s+");
            for (int i = 0; i < size; ++i) {
                tmp[i] = Long.parseLong(strings[i]);
            }
            ret = tmp;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public long[][] readLongArray2D(String name, long[][] defVal) throws IOException {
        Object ret = defVal;
        try {
            Element tmpEl = name != null ? this.findChildElement(this._currentElem, name) : this._currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            long[][] tmp = new long[size][];
            NodeList nodes = this._currentElem.getChildNodes();
            int strIndex = 0;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (!(n instanceof Element) || !n.getNodeName().contains("array")) continue;
                if (strIndex < size) {
                    tmp[strIndex++] = this.readLongArray(n.getNodeName(), null);
                    continue;
                }
                throw new IOException("String array contains more elements than specified!");
            }
            ret = tmp;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        this._currentElem = (Element)this._currentElem.getParentNode();
        return ret;
    }

    public short readShort(String name, short defVal) throws IOException {
        short ret = defVal;
        try {
            String s = this._currentElem.getAttribute(name);
            if (s.length() > 0) {
                ret = Short.parseShort(s);
            }
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public short[] readShortArray(String name, short[] defVal) throws IOException {
        short[] ret = defVal;
        try {
            Element tmpEl = name != null ? this.findChildElement(this._currentElem, name) : this._currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            short[] tmp = new short[size];
            String[] strings = tmpEl.getAttribute("data").split("\\s+");
            for (int i = 0; i < size; ++i) {
                tmp[i] = Short.parseShort(strings[i]);
            }
            ret = tmp;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public short[][] readShortArray2D(String name, short[][] defVal) throws IOException {
        Object ret = defVal;
        try {
            Element tmpEl = name != null ? this.findChildElement(this._currentElem, name) : this._currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            short[][] tmp = new short[size][];
            NodeList nodes = this._currentElem.getChildNodes();
            int strIndex = 0;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (!(n instanceof Element) || !n.getNodeName().contains("array")) continue;
                if (strIndex < size) {
                    tmp[strIndex++] = this.readShortArray(n.getNodeName(), null);
                    continue;
                }
                throw new IOException("String array contains more elements than specified!");
            }
            ret = tmp;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        this._currentElem = (Element)this._currentElem.getParentNode();
        return ret;
    }

    public boolean readBoolean(String name, boolean defVal) throws IOException {
        boolean ret = defVal;
        try {
            String s = this._currentElem.getAttribute(name);
            if (s.length() > 0) {
                ret = Boolean.parseBoolean(s);
            }
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public boolean[] readBooleanArray(String name, boolean[] defVal) throws IOException {
        boolean[] ret = defVal;
        try {
            Element tmpEl = name != null ? this.findChildElement(this._currentElem, name) : this._currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            boolean[] tmp = new boolean[size];
            String[] strings = tmpEl.getAttribute("data").split("\\s+");
            for (int i = 0; i < size; ++i) {
                tmp[i] = Boolean.parseBoolean(strings[i]);
            }
            ret = tmp;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public boolean[][] readBooleanArray2D(String name, boolean[][] defVal) throws IOException {
        Object ret = defVal;
        try {
            Element tmpEl = name != null ? this.findChildElement(this._currentElem, name) : this._currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            boolean[][] tmp = new boolean[size][];
            NodeList nodes = this._currentElem.getChildNodes();
            int strIndex = 0;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (!(n instanceof Element) || !n.getNodeName().contains("array")) continue;
                if (strIndex < size) {
                    tmp[strIndex++] = this.readBooleanArray(n.getNodeName(), null);
                    continue;
                }
                throw new IOException("String array contains more elements than specified!");
            }
            ret = tmp;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        this._currentElem = (Element)this._currentElem.getParentNode();
        return ret;
    }

    public String readString(String name, String defVal) throws IOException {
        String ret = defVal;
        try {
            ret = DOMInputCapsule.decodeString(this._currentElem.getAttribute(name));
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public String[] readStringArray(String name, String[] defVal) throws IOException {
        String[] ret = defVal;
        try {
            Element tmpEl = name != null ? this.findChildElement(this._currentElem, name) : this._currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            String[] tmp = new String[size];
            NodeList nodes = tmpEl.getChildNodes();
            int strIndex = 0;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (!(n instanceof Element) || !n.getNodeName().contains("String")) continue;
                if (strIndex < size) {
                    tmp[strIndex++] = ((Element)n).getAttributeNode("value").getValue();
                    continue;
                }
                throw new IOException("String array contains more elements than specified!");
            }
            ret = tmp;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public String[][] readStringArray2D(String name, String[][] defVal) throws IOException {
        String[][] ret = defVal;
        try {
            Element tmpEl = name != null ? this.findChildElement(this._currentElem, name) : this._currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            String[][] tmp = new String[size][];
            NodeList nodes = this._currentElem.getChildNodes();
            int strIndex = 0;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (!(n instanceof Element) || !n.getNodeName().contains("array")) continue;
                if (strIndex < size) {
                    tmp[strIndex++] = this.readStringArray(n.getNodeName(), null);
                    continue;
                }
                throw new IOException("String array contains more elements than specified!");
            }
            ret = tmp;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        this._currentElem = (Element)this._currentElem.getParentNode();
        return ret;
    }

    public BitSet readBitSet(String name, BitSet defVal) throws IOException {
        BitSet ret = defVal;
        try {
            BitSet set = new BitSet();
            String bitString = this._currentElem.getAttribute(name);
            String[] strings = bitString.split("\\s+");
            for (int i = 0; i < strings.length; ++i) {
                int isSet = Integer.parseInt(strings[i]);
                if (isSet != 1) continue;
                set.set(i);
            }
            ret = set;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public Savable readSavable(String name, Savable defVal) throws IOException {
        Savable ret = defVal;
        try {
            Element tmpEl = null;
            if (name != null) {
                tmpEl = this.findChildElement(this._currentElem, name);
                if (tmpEl == null) {
                    return defVal;
                }
            } else if (this._isAtRoot) {
                tmpEl = this._doc.getDocumentElement();
                this._isAtRoot = false;
            } else {
                tmpEl = this.findFirstChildElement(this._currentElem);
            }
            this._currentElem = tmpEl;
            ret = this.readSavableFromCurrentElem(defVal);
            this._currentElem = this._currentElem.getParentNode() instanceof Element ? (Element)this._currentElem.getParentNode() : null;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    private Savable readSavableFromCurrentElem(Savable defVal) throws InstantiationException, ClassNotFoundException, IOException, IllegalAccessException {
        Savable ret = defVal;
        Savable tmp = null;
        if (this._currentElem == null || this._currentElem.getNodeName().equals("null")) {
            return null;
        }
        String reference = this._currentElem.getAttribute("ref");
        if (reference.length() > 0) {
            ret = this._referencedSavables.get(reference);
        } else {
            String className = this._currentElem.getNodeName();
            if (defVal != null) {
                className = defVal.getClass().getName();
            } else if (this._currentElem.hasAttribute("class")) {
                className = this._currentElem.getAttribute("class");
            }
            try {
                Class<?> clazz = Class.forName(className);
                SavableFactory ann = clazz.getAnnotation(SavableFactory.class);
                tmp = ann == null ? (Savable)clazz.newInstance() : (Savable)clazz.getMethod(ann.factoryMethod(), null).invoke(null, (Object[])null);
            }
            catch (InstantiationException e) {
                Logger.getLogger(this.getClass().getName()).logp(Level.SEVERE, this.getClass().toString(), "readSavableFromCurrentElem(Savable)", "Could not access constructor of class '" + className + "'! \nSome types may require the annotation SavableFactory.  Please double check.");
                throw new Ardor3dException(e);
            }
            catch (NoSuchMethodException e) {
                Logger.getLogger(this.getClass().getName()).logp(Level.SEVERE, this.getClass().toString(), "readSavableFromCurrentElem(Savable)", e.getMessage() + " \nMethod specified in annotation does not appear to exist or has an invalid method signature.");
                throw new Ardor3dException(e);
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).logp(Level.SEVERE, this.getClass().toString(), "readSavableFromCurrentElem(Savable)", "Exception", e);
                return null;
            }
            String refID = this._currentElem.getAttribute("reference_ID");
            if (refID.length() > 0) {
                this._referencedSavables.put(refID, tmp);
            }
            if (tmp != null) {
                tmp.read((InputCapsule)this);
                ret = tmp;
            }
        }
        return ret;
    }

    private TextureState readTextureStateFromCurrent() {
        Element el = this._currentElem;
        TextureState ret = null;
        try {
            ret = (TextureState)this.readSavableFromCurrentElem(null);
            Savable[] savs = this.readSavableArray("texture", new Texture[0]);
            for (int i = 0; i < savs.length; ++i) {
                Texture t = (Texture)savs[i];
                TextureKey tKey = t.getTextureKey();
                t = TextureManager.loadFromKey(tKey, null, t);
                ret.setTexture(t, i);
            }
        }
        catch (Exception e) {
            Logger.getLogger(DOMInputCapsule.class.getName()).log(Level.SEVERE, null, e);
        }
        this._currentElem = el;
        return ret;
    }

    private Savable[] readRenderStateList(Element fromElement, Savable[] defVal) {
        Savable[] ret = defVal;
        try {
            ArrayList<TextureState> tmp = new ArrayList<TextureState>();
            this._currentElem = this.findFirstChildElement(fromElement);
            while (this._currentElem != null) {
                Element el = this._currentElem;
                RenderState rs = null;
                rs = el.getNodeName().equals("com.ardor3d.scene.state.TextureState") ? this.readTextureStateFromCurrent() : (RenderState)this.readSavableFromCurrentElem(null);
                if (rs != null) {
                    tmp.add((TextureState)rs);
                }
                this._currentElem = this.findNextSiblingElement(el);
            }
            ret = tmp.toArray(new RenderState[0]);
        }
        catch (Exception e) {
            Logger.getLogger(DOMInputCapsule.class.getName()).log(Level.SEVERE, null, e);
        }
        return ret;
    }

    public Savable[] readSavableArray(String name, Savable[] defVal) throws IOException {
        Savable[] ret = defVal;
        try {
            Element tmpEl = this.findChildElement(this._currentElem, name);
            if (tmpEl == null) {
                return defVal;
            }
            if (name.equals("renderStateList")) {
                ret = this.readRenderStateList(tmpEl, defVal);
            } else {
                int size = Integer.parseInt(tmpEl.getAttribute("size"));
                Savable[] tmp = new Savable[size];
                this._currentElem = this.findFirstChildElement(tmpEl);
                for (int i = 0; i < size; ++i) {
                    tmp[i] = this.readSavableFromCurrentElem(null);
                    if (i == size - 1) break;
                    this._currentElem = this.findNextSiblingElement(this._currentElem);
                }
                ret = tmp;
            }
            this._currentElem = (Element)tmpEl.getParentNode();
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public Savable[][] readSavableArray2D(String name, Savable[][] defVal) throws IOException {
        Savable[][] ret = defVal;
        try {
            Element tmpEl = this.findChildElement(this._currentElem, name);
            if (tmpEl == null) {
                return defVal;
            }
            int size_outer = Integer.parseInt(tmpEl.getAttribute("size_outer"));
            int size_inner = Integer.parseInt(tmpEl.getAttribute("size_outer"));
            Savable[][] tmp = new Savable[size_outer][size_inner];
            this._currentElem = this.findFirstChildElement(tmpEl);
            block2: for (int i = 0; i < size_outer; ++i) {
                for (int j = 0; j < size_inner; ++j) {
                    tmp[i][j] = this.readSavableFromCurrentElem(null);
                    if (i == size_outer - 1 && j == size_inner - 1) continue block2;
                    this._currentElem = this.findNextSiblingElement(this._currentElem);
                }
            }
            ret = tmp;
            this._currentElem = (Element)tmpEl.getParentNode();
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public <E extends Savable> List<E> readSavableList(String name, List<E> defVal) throws IOException {
        List<E> ret = defVal;
        try {
            Element tmpEl = this.findChildElement(this._currentElem, name);
            if (tmpEl == null) {
                return defVal;
            }
            String s = tmpEl.getAttribute("size");
            int size = Integer.parseInt(s);
            ArrayList<Savable> tmp = new ArrayList<Savable>();
            this._currentElem = this.findFirstChildElement(tmpEl);
            for (int i = 0; i < size; ++i) {
                tmp.add(this.readSavableFromCurrentElem(null));
                if (i == size - 1) break;
                this._currentElem = this.findNextSiblingElement(this._currentElem);
            }
            ret = tmp;
            this._currentElem = (Element)tmpEl.getParentNode();
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public <E extends Savable> List<E>[] readSavableListArray(String name, List<E>[] defVal) throws IOException {
        List<E>[] ret = defVal;
        try {
            Element tmpEl = this.findChildElement(this._currentElem, name);
            if (tmpEl == null) {
                return defVal;
            }
            this._currentElem = tmpEl;
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            ArrayList[] tmp = new ArrayList[size];
            for (int i = 0; i < size; ++i) {
                StringBuilder buf = new StringBuilder("SavableArrayList_");
                buf.append(i);
                List<E> al = this.readSavableList(buf.toString(), null);
                tmp[i] = al;
                if (i == size - 1) break;
            }
            ret = tmp;
            this._currentElem = (Element)tmpEl.getParentNode();
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public <E extends Savable> List<E>[][] readSavableListArray2D(String name, List<E>[][] defVal) throws IOException {
        List<E>[][] ret = defVal;
        try {
            Element tmpEl = this.findChildElement(this._currentElem, name);
            if (tmpEl == null) {
                return defVal;
            }
            this._currentElem = tmpEl;
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            ArrayList[][] tmp = new ArrayList[size][];
            for (int i = 0; i < size; ++i) {
                List<E>[] arr = this.readSavableListArray("SavableArrayListArray_" + i, null);
                tmp[i] = arr;
            }
            ret = tmp;
            this._currentElem = (Element)tmpEl.getParentNode();
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public List<FloatBuffer> readFloatBufferList(String name, List<FloatBuffer> defVal) throws IOException {
        List<FloatBuffer> ret = defVal;
        try {
            Element tmpEl = this.findChildElement(this._currentElem, name);
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            ArrayList<FloatBuffer> tmp = new ArrayList<FloatBuffer>(size);
            this._currentElem = this.findFirstChildElement(tmpEl);
            for (int i = 0; i < size; ++i) {
                tmp.add(this.readFloatBuffer(null, null));
                if (i == size - 1) break;
                this._currentElem = this.findNextSiblingElement(this._currentElem);
            }
            ret = tmp;
            this._currentElem = (Element)tmpEl.getParentNode();
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public <K extends Savable, V extends Savable> Map<K, V> readSavableMap(String name, Map<K, V> defVal) throws IOException {
        Element tempEl = name != null ? this.findChildElement(this._currentElem, name) : this._currentElem;
        HashMap<Savable, Savable> ret = new HashMap<Savable, Savable>();
        NodeList nodes = tempEl.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element elem;
            Node n = nodes.item(i);
            if (!(n instanceof Element) || !n.getNodeName().equals("MapEntry")) continue;
            this._currentElem = elem = (Element)n;
            Savable key = this.readSavable("Key", null);
            Savable val = this.readSavable("Value", null);
            ret.put(key, val);
        }
        this._currentElem = (Element)tempEl.getParentNode();
        return ret;
    }

    public <V extends Savable> Map<String, V> readStringSavableMap(String name, Map<String, V> defVal) throws IOException {
        HashMap<String, Savable> ret = null;
        Element tempEl = name != null ? this.findChildElement(this._currentElem, name) : this._currentElem;
        if (tempEl != null) {
            ret = new HashMap<String, Savable>();
            NodeList nodes = tempEl.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element elem;
                Node n = nodes.item(i);
                if (!(n instanceof Element) || !n.getNodeName().equals("MapEntry")) continue;
                this._currentElem = elem = (Element)n;
                String key = this._currentElem.getAttribute("key");
                Savable val = this.readSavable("Savable", null);
                ret.put(key, val);
            }
        } else {
            return defVal;
        }
        this._currentElem = (Element)tempEl.getParentNode();
        return ret;
    }

    public FloatBuffer readFloatBuffer(String name, FloatBuffer defVal) throws IOException {
        FloatBuffer ret = defVal;
        try {
            Element tmpEl = name != null ? this.findChildElement(this._currentElem, name) : this._currentElem;
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            FloatBuffer tmp = BufferUtils.createFloatBuffer(size);
            if (size > 0) {
                String[] strings;
                for (String s : strings = tmpEl.getAttribute("data").split("\\s+")) {
                    tmp.put(Float.parseFloat(s));
                }
                tmp.flip();
            }
            ret = tmp;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public IntBuffer readIntBuffer(String name, IntBuffer defVal) throws IOException {
        IntBuffer ret = defVal;
        try {
            Element tmpEl = this.findChildElement(this._currentElem, name);
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            IntBuffer tmp = BufferUtils.createIntBuffer(size);
            if (size > 0) {
                String[] strings;
                for (String s : strings = tmpEl.getAttribute("data").split("\\s+")) {
                    tmp.put(Integer.parseInt(s));
                }
                tmp.flip();
            }
            ret = tmp;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public ByteBuffer readByteBuffer(String name, ByteBuffer defVal) throws IOException {
        ByteBuffer ret = defVal;
        try {
            Element tmpEl = this.findChildElement(this._currentElem, name);
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            ByteBuffer tmp = BufferUtils.createByteBuffer(size);
            if (size > 0) {
                String[] strings;
                for (String s : strings = tmpEl.getAttribute("data").split("\\s+")) {
                    tmp.put(Byte.valueOf(s));
                }
                tmp.flip();
            }
            ret = tmp;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public ShortBuffer readShortBuffer(String name, ShortBuffer defVal) throws IOException {
        ShortBuffer ret = defVal;
        try {
            Element tmpEl = this.findChildElement(this._currentElem, name);
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            ShortBuffer tmp = BufferUtils.createShortBuffer(size);
            if (size > 0) {
                String[] strings;
                for (String s : strings = tmpEl.getAttribute("data").split("\\s+")) {
                    tmp.put(Short.valueOf(s));
                }
                tmp.flip();
            }
            ret = tmp;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public List<ByteBuffer> readByteBufferList(String name, List<ByteBuffer> defVal) throws IOException {
        List<ByteBuffer> ret = defVal;
        try {
            Element tmpEl = this.findChildElement(this._currentElem, name);
            if (tmpEl == null) {
                return defVal;
            }
            int size = Integer.parseInt(tmpEl.getAttribute("size"));
            ArrayList<ByteBuffer> tmp = new ArrayList<ByteBuffer>(size);
            this._currentElem = this.findFirstChildElement(tmpEl);
            for (int i = 0; i < size; ++i) {
                tmp.add(this.readByteBuffer(null, null));
                if (i == size - 1) break;
                this._currentElem = this.findNextSiblingElement(this._currentElem);
            }
            ret = tmp;
            this._currentElem = (Element)tmpEl.getParentNode();
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public <T extends Enum<T>> T readEnum(String name, Class<T> enumType, T defVal) throws IOException {
        T ret = defVal;
        try {
            String eVal = this._currentElem.getAttribute(name);
            if (eVal != null && eVal.length() > 0) {
                ret = Enum.valueOf(enumType, eVal);
            }
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ret;
    }

    public <T extends Enum<T>> T[] readEnumArray(String name, Class<T> enumType, T[] defVal) throws IOException {
        String[] eVals = this.readStringArray(name, null);
        if (eVals != null) {
            Enum[] rVal = (Enum[])Array.newInstance(enumType, eVals.length);
            int i = 0;
            for (String eVal : eVals) {
                rVal[i++] = Enum.valueOf(enumType, eVal);
            }
            return rVal;
        }
        return defVal;
    }
}

