/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.export.xml;

import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DOMOutputCapsule
implements OutputCapsule {
    private static final String _dataAttributeName = "data";
    private final Document _doc;
    private Element _currentElement;
    private final Map<Savable, Element> _writtenSavables = new IdentityHashMap<Savable, Element>();

    public DOMOutputCapsule(Document doc) {
        this._doc = doc;
        this._currentElement = null;
    }

    public Document getDoc() {
        return this._doc;
    }

    private Element appendElement(String name) {
        Element ret = null;
        ret = this._doc.createElement(name);
        if (this._currentElement == null) {
            this._doc.appendChild(ret);
        } else {
            this._currentElement.appendChild(ret);
        }
        this._currentElement = ret;
        return ret;
    }

    private static String encodeString(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("\\&", "&amp;").replaceAll("\\\"", "&quot;").replaceAll("\\<", "&lt;");
        return s;
    }

    public void write(byte value, String name, byte defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this._currentElement.setAttribute(name, String.valueOf(value));
    }

    public void write(byte[] value, String name, byte[] defVal) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (value == null) {
            value = defVal;
        }
        for (byte b : value) {
            buf.append(b);
            buf.append(' ');
        }
        buf.setLength(buf.length() - 1);
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        el.setAttribute(_dataAttributeName, buf.toString());
        this._currentElement = (Element)this._currentElement.getParentNode();
    }

    public void write(byte[][] value, String name, byte[][] defVal) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (value == null) {
            value = defVal;
        }
        byte[][] byArray = value;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte[] bs;
            for (byte b : bs = byArray[i]) {
                buf.append(b);
                buf.append(' ');
            }
            buf.append(' ');
        }
        buf.setLength(buf.length() - 2);
        Element el = this.appendElement(name);
        el.setAttribute("size_outer", String.valueOf(value.length));
        el.setAttribute("size_inner", String.valueOf(value[0].length));
        el.setAttribute(_dataAttributeName, buf.toString());
        this._currentElement = (Element)this._currentElement.getParentNode();
    }

    public void write(int value, String name, int defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this._currentElement.setAttribute(name, String.valueOf(value));
    }

    public void write(int[] value, String name, int[] defVal) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (value == null) {
            return;
        }
        if (Arrays.equals(value, defVal)) {
            return;
        }
        for (int b : value) {
            buf.append(b);
            buf.append(' ');
        }
        buf.setLength(Math.max(0, buf.length() - 1));
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        el.setAttribute(_dataAttributeName, buf.toString());
        this._currentElement = (Element)this._currentElement.getParentNode();
    }

    public void write(int[][] value, String name, int[][] defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        for (int i = 0; i < value.length; ++i) {
            int[] array = value[i];
            this.write(array, "array_" + i, defVal == null ? null : defVal[i]);
        }
        this._currentElement = (Element)el.getParentNode();
    }

    public void write(float value, String name, float defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this._currentElement.setAttribute(name, String.valueOf(value));
    }

    public void write(float[] value, String name, float[] defVal) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (value == null) {
            value = defVal;
        }
        for (float b : value) {
            buf.append(b);
            buf.append(' ');
        }
        buf.setLength(buf.length() - 1);
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        el.setAttribute(_dataAttributeName, buf.toString());
        this._currentElement = (Element)this._currentElement.getParentNode();
    }

    public void write(float[][] value, String name, float[][] defVal) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (value == null) {
            return;
        }
        if (Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            return;
        }
        float[][] fArray = value;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float[] bs;
            for (float b : bs = fArray[i]) {
                buf.append(b);
                buf.append(' ');
            }
        }
        buf.setLength(buf.length() - 1);
        Element el = this.appendElement(name);
        el.setAttribute("size_outer", String.valueOf(value.length));
        el.setAttribute("size_inner", String.valueOf(value[0].length));
        el.setAttribute(_dataAttributeName, buf.toString());
        this._currentElement = (Element)this._currentElement.getParentNode();
    }

    public void write(double value, String name, double defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this._currentElement.setAttribute(name, String.valueOf(value));
    }

    public void write(double[] value, String name, double[] defVal) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (value == null) {
            value = defVal;
        }
        for (double b : value) {
            buf.append(b);
            buf.append(' ');
        }
        buf.setLength(buf.length() - 1);
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        el.setAttribute(_dataAttributeName, buf.toString());
        this._currentElement = (Element)this._currentElement.getParentNode();
    }

    public void write(double[][] value, String name, double[][] defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        for (int i = 0; i < value.length; ++i) {
            double[] array = value[i];
            this.write(array, "array_" + i, defVal == null ? null : defVal[i]);
        }
        this._currentElement = (Element)el.getParentNode();
    }

    public void write(long value, String name, long defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this._currentElement.setAttribute(name, String.valueOf(value));
    }

    public void write(long[] value, String name, long[] defVal) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (value == null) {
            value = defVal;
        }
        for (long b : value) {
            buf.append(b);
            buf.append(' ');
        }
        buf.setLength(buf.length() - 1);
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        el.setAttribute(_dataAttributeName, buf.toString());
        this._currentElement = (Element)this._currentElement.getParentNode();
    }

    public void write(long[][] value, String name, long[][] defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        for (int i = 0; i < value.length; ++i) {
            long[] array = value[i];
            this.write(array, "array_" + i, defVal == null ? null : defVal[i]);
        }
        this._currentElement = (Element)el.getParentNode();
    }

    public void write(short value, String name, short defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this._currentElement.setAttribute(name, String.valueOf(value));
    }

    public void write(short[] value, String name, short[] defVal) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (value == null) {
            value = defVal;
        }
        for (short b : value) {
            buf.append(b);
            buf.append(' ');
        }
        buf.setLength(buf.length() - 1);
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        el.setAttribute(_dataAttributeName, buf.toString());
        this._currentElement = (Element)this._currentElement.getParentNode();
    }

    public void write(short[][] value, String name, short[][] defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        for (int i = 0; i < value.length; ++i) {
            short[] array = value[i];
            this.write(array, "array_" + i, defVal == null ? null : defVal[i]);
        }
        this._currentElement = (Element)el.getParentNode();
    }

    public void write(boolean value, String name, boolean defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this._currentElement.setAttribute(name, String.valueOf(value));
    }

    public void write(boolean[] value, String name, boolean[] defVal) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (value == null) {
            value = defVal;
        }
        for (boolean b : value) {
            buf.append(b);
            buf.append(' ');
        }
        buf.setLength(Math.max(0, buf.length() - 1));
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        el.setAttribute(_dataAttributeName, buf.toString());
        this._currentElement = (Element)this._currentElement.getParentNode();
    }

    public void write(boolean[][] value, String name, boolean[][] defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        for (int i = 0; i < value.length; ++i) {
            boolean[] array = value[i];
            this.write(array, "array_" + i, defVal == null ? null : defVal[i]);
        }
        this._currentElement = (Element)el.getParentNode();
    }

    public void write(String value, String name, String defVal) throws IOException {
        if (value == null || value.equals(defVal)) {
            return;
        }
        this._currentElement.setAttribute(name, DOMOutputCapsule.encodeString(value));
    }

    public void write(String[] value, String name, String[] defVal) throws IOException {
        Element el = this.appendElement(name);
        if (value == null) {
            value = defVal;
        }
        el.setAttribute("size", String.valueOf(value.length));
        for (int i = 0; i < value.length; ++i) {
            String b = value[i];
            this.appendElement("String_" + i);
            String val = DOMOutputCapsule.encodeString(b);
            this._currentElement.setAttribute("value", val);
            this._currentElement = el;
        }
        this._currentElement = (Element)this._currentElement.getParentNode();
    }

    public void write(String[][] value, String name, String[][] defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        for (int i = 0; i < value.length; ++i) {
            String[] array = value[i];
            this.write(array, "array_" + i, defVal == null ? null : defVal[i]);
        }
        this._currentElement = (Element)el.getParentNode();
    }

    public void write(BitSet value, String name, BitSet defVal) throws IOException {
        if (value == null || value.equals(defVal)) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        int i = value.nextSetBit(0);
        while (i >= 0) {
            buf.append(i);
            buf.append(' ');
            i = value.nextSetBit(i + 1);
        }
        buf.setLength(Math.max(0, buf.length() - 1));
        this._currentElement.setAttribute(name, buf.toString());
    }

    public void write(Savable object, String name, Savable defVal) throws IOException {
        if (object == null) {
            return;
        }
        if (object.equals(defVal)) {
            return;
        }
        Element old = this._currentElement;
        Element el = this._writtenSavables.get(object);
        String className = null;
        if (!object.getClass().getName().equals(name)) {
            className = object.getClass().getName();
        }
        try {
            this._doc.createElement(name);
        }
        catch (DOMException e) {
            name = "Object";
            className = object.getClass().getName();
        }
        if (el != null) {
            String refID = el.getAttribute("reference_ID");
            if (refID.length() == 0) {
                refID = object.getClassTag().getName() + "@" + object.hashCode();
                el.setAttribute("reference_ID", refID);
            }
            el = this.appendElement(name);
            el.setAttribute("ref", refID);
        } else {
            el = this.appendElement(name);
            this._writtenSavables.put(object, el);
            object.write((OutputCapsule)this);
        }
        if (className != null) {
            el.setAttribute("class", className);
        }
        this._currentElement = old;
    }

    public void write(Savable[] objects, String name, Savable[] defVal) throws IOException {
        if (objects == null) {
            return;
        }
        if (Arrays.equals(objects, defVal)) {
            return;
        }
        Element old = this._currentElement;
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(objects.length));
        for (int i = 0; i < objects.length; ++i) {
            Savable o = objects[i];
            if (o == null) {
                if (name.equals("renderStateList")) continue;
                Element before = this._currentElement;
                this.appendElement("null");
                this._currentElement = before;
                continue;
            }
            this.write(o, o.getClassTag().getName(), null);
        }
        this._currentElement = old;
    }

    public void write(Savable[][] value, String name, Savable[][] defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size_outer", String.valueOf(value.length));
        el.setAttribute("size_inner", String.valueOf(value[0].length));
        Savable[][] savableArray = value;
        int n = savableArray.length;
        for (int i = 0; i < n; ++i) {
            Savable[] bs;
            for (Savable b : bs = savableArray[i]) {
                this.write(b, b.getClassTag().getSimpleName(), null);
            }
        }
        this._currentElement = (Element)this._currentElement.getParentNode();
    }

    public void writeSavableList(List<? extends Savable> array, String name, List<? extends Savable> defVal) throws IOException {
        Element el;
        if (array == null) {
            return;
        }
        if (array.equals(defVal)) {
            return;
        }
        Element old = this._currentElement;
        this._currentElement = el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(array.size()));
        for (Savable savable : array) {
            if (savable == null) continue;
            if (savable instanceof Savable) {
                Savable s = savable;
                this.write(s, s.getClassTag().getName(), null);
                continue;
            }
            throw new ClassCastException("Not a Savable instance: " + savable);
        }
        this._currentElement = old;
    }

    public void writeSavableListArray(List<? extends Savable>[] objects, String name, List<? extends Savable>[] defVal) throws IOException {
        if (objects == null) {
            return;
        }
        if (Arrays.equals(objects, defVal)) {
            return;
        }
        Element old = this._currentElement;
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(objects.length));
        for (int i = 0; i < objects.length; ++i) {
            List<? extends Savable> o = objects[i];
            if (o == null) {
                Element before = this._currentElement;
                this.appendElement("null");
                this._currentElement = before;
                continue;
            }
            StringBuilder buf = new StringBuilder("SavableArrayList_");
            buf.append(i);
            this.writeSavableList(o, buf.toString(), null);
        }
        this._currentElement = old;
    }

    public void writeSavableListArray2D(List<? extends Savable>[][] value, String name, List<? extends Savable>[][] defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (Arrays.deepEquals(value, defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        int size = value.length;
        el.setAttribute("size", String.valueOf(size));
        for (int i = 0; i < size; ++i) {
            List<? extends Savable>[] vi = value[i];
            this.writeSavableListArray(vi, "SavableArrayListArray_" + i, null);
        }
        this._currentElement = (Element)el.getParentNode();
    }

    public void writeFloatBufferList(List<FloatBuffer> array, String name, List<FloatBuffer> defVal) throws IOException {
        if (array == null) {
            return;
        }
        if (array.equals(defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(array.size()));
        for (FloatBuffer o : array) {
            this.write(o, "FloatBuffer", null);
        }
        this._currentElement = (Element)el.getParentNode();
    }

    public void writeSavableMap(Map<? extends Savable, ? extends Savable> map, String name, Map<? extends Savable, ? extends Savable> defVal) throws IOException {
        if (map == null) {
            return;
        }
        if (map.equals(defVal)) {
            return;
        }
        Element stringMap = this.appendElement(name);
        for (Savable savable : map.keySet()) {
            this.appendElement("MapEntry");
            this.write(savable, "Key", null);
            Savable value = map.get(savable);
            this.write(value, "Value", null);
            this._currentElement = stringMap;
        }
        this._currentElement = (Element)stringMap.getParentNode();
    }

    public void writeStringSavableMap(Map<String, ? extends Savable> map, String name, Map<String, ? extends Savable> defVal) throws IOException {
        if (map == null) {
            return;
        }
        if (map.equals(defVal)) {
            return;
        }
        Element stringMap = this.appendElement(name);
        for (String key : map.keySet()) {
            Element mapEntry = this.appendElement("MapEntry");
            mapEntry.setAttribute("key", key);
            Savable s = map.get(key);
            this.write(s, "Savable", null);
            this._currentElement = stringMap;
        }
        this._currentElement = (Element)stringMap.getParentNode();
    }

    public void write(FloatBuffer value, String name, FloatBuffer defVal) throws IOException {
        if (value == null) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.limit()));
        StringBuilder buf = new StringBuilder();
        int pos = value.position();
        value.rewind();
        while (value.hasRemaining()) {
            buf.append(value.get());
            buf.append(' ');
        }
        buf.setLength(Math.max(0, buf.length() - 1));
        value.position(pos);
        el.setAttribute(_dataAttributeName, buf.toString());
        this._currentElement = (Element)el.getParentNode();
    }

    public void write(IntBuffer value, String name, IntBuffer defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (value.equals(defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.limit()));
        StringBuilder buf = new StringBuilder();
        int pos = value.position();
        value.rewind();
        while (value.hasRemaining()) {
            buf.append(value.get());
            buf.append(' ');
        }
        buf.setLength(buf.length() - 1);
        value.position(pos);
        el.setAttribute(_dataAttributeName, buf.toString());
        this._currentElement = (Element)el.getParentNode();
    }

    public void write(ByteBuffer value, String name, ByteBuffer defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (value.equals(defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.limit()));
        StringBuilder buf = new StringBuilder();
        int pos = value.position();
        value.rewind();
        while (value.hasRemaining()) {
            buf.append(value.get());
            buf.append(' ');
        }
        buf.setLength(buf.length() - 1);
        value.position(pos);
        el.setAttribute(_dataAttributeName, buf.toString());
        this._currentElement = (Element)el.getParentNode();
    }

    public void write(ShortBuffer value, String name, ShortBuffer defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (value.equals(defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.limit()));
        StringBuilder buf = new StringBuilder();
        int pos = value.position();
        value.rewind();
        while (value.hasRemaining()) {
            buf.append(value.get());
            buf.append(' ');
        }
        buf.setLength(buf.length() - 1);
        value.position(pos);
        el.setAttribute(_dataAttributeName, buf.toString());
        this._currentElement = (Element)el.getParentNode();
    }

    public void writeByteBufferList(List<ByteBuffer> array, String name, List<ByteBuffer> defVal) throws IOException {
        if (array == null) {
            return;
        }
        if (array.equals(defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(array.size()));
        for (ByteBuffer o : array) {
            this.write(o, "ByteBuffer", null);
        }
        this._currentElement = (Element)el.getParentNode();
    }

    public void write(Enum<?> value, String name, Enum<?> defVal) throws IOException {
        if (value == defVal || value == null) {
            return;
        }
        this._currentElement.setAttribute(name, String.valueOf(value));
    }

    public void write(Enum<?>[] value, String name) throws IOException {
        if (value == null) {
            return;
        }
        String[] toWrite = new String[value.length];
        int i = 0;
        for (Enum<?> val : value) {
            toWrite[i++] = val.name();
        }
        this.write(toWrite, name, null);
    }
}

