/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.export.xml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMSerializer {
    private String _indent = "";
    private String _lineSeparator = "\n";
    private String _encoding = "UTF8";
    private final boolean _displayAttributesOnSeperateLine = true;

    public void setLineSeparator(String lineSeparator) {
        this._lineSeparator = lineSeparator;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public void setIndent(int numSpaces) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < numSpaces; ++i) {
            buffer.append('\t');
        }
        this._indent = buffer.toString();
    }

    public void serialize(Document doc, OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, this._encoding);
        this.serialize(doc, writer);
    }

    public void serialize(Document doc, File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        this.serialize(doc, writer);
    }

    public void serialize(Document doc, Writer writer) throws IOException {
        this.serializeNode(doc, writer, "");
        writer.flush();
    }

    private void serializeNode(Node node, Writer writer, String indentLevel) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                Document doc = (Document)node;
                writer.write("<?xml version=\"");
                writer.write(doc.getXmlVersion());
                writer.write("\" encoding=\"UTF-8\" standalone=\"");
                if (doc.getXmlStandalone()) {
                    writer.write("yes");
                } else {
                    writer.write("no");
                }
                writer.write("\"");
                writer.write("?>");
                writer.write(this._lineSeparator);
                NodeList nodes = node.getChildNodes();
                if (nodes == null) break;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    this.serializeNode(nodes.item(i), writer, "");
                }
                break;
            }
            case 1: {
                String name = node.getNodeName();
                writer.write("<" + name);
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node current = attributes.item(i);
                    String attributeSeperator = " ";
                    if (i != 0) {
                        attributeSeperator = this._lineSeparator + indentLevel + this._indent;
                    }
                    String attributeStr = attributeSeperator + current.getNodeName() + "=\"";
                    writer.write(attributeStr);
                    this.print(writer, current.getNodeValue());
                    writer.write("\"");
                }
                writer.write(">");
                NodeList children = node.getChildNodes();
                if (children != null) {
                    if (children.item(0) == null || children.item(0).getNodeType() == 1) {
                        // empty if block
                    }
                    for (int i = 0; i < children.getLength(); ++i) {
                        this.serializeNode(children.item(i), writer, indentLevel + this._indent);
                    }
                    if (children.item(0) == null || children.item(children.getLength() - 1).getNodeType() == 1) {
                        // empty if block
                    }
                }
                writer.write("</" + name + ">");
                break;
            }
            case 3: {
                this.print(writer, node.getNodeValue());
                break;
            }
            case 4: {
                writer.write("<![CDATA[");
                this.print(writer, node.getNodeValue());
                writer.write("]]>");
                break;
            }
            case 8: {
                writer.write(indentLevel + "<!-- " + node.getNodeValue() + " -->");
                writer.write(this._lineSeparator);
                break;
            }
            case 7: {
                writer.write("<?" + node.getNodeName() + " " + node.getNodeValue() + "?>");
                writer.write(this._lineSeparator);
                break;
            }
            case 5: {
                writer.write("&" + node.getNodeName() + ";");
                break;
            }
            case 10: {
                DocumentType docType = (DocumentType)node;
                String publicId = docType.getPublicId();
                String systemId = docType.getSystemId();
                String internalSubset = docType.getInternalSubset();
                writer.write("<!DOCTYPE " + docType.getName());
                if (publicId != null) {
                    writer.write(" PUBLIC \"" + publicId + "\" ");
                } else {
                    writer.write(" SYSTEM ");
                }
                writer.write("\"" + systemId + "\"");
                if (internalSubset != null) {
                    writer.write(" [" + internalSubset + "]");
                }
                writer.write(">");
                writer.write(this._lineSeparator);
            }
        }
    }

    private void print(Writer writer, String s) throws IOException {
        if (s == null) {
            return;
        }
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    writer.write("&lt;");
                    continue block6;
                }
                case '>': {
                    writer.write("&gt;");
                    continue block6;
                }
                case '&': {
                    writer.write("&amp;");
                    continue block6;
                }
                case '\r': {
                    writer.write("&#xD;");
                    continue block6;
                }
                default: {
                    writer.write(c);
                }
            }
        }
    }
}

