/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.geom;

import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.Vector2;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.Vector4;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyVector2;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.math.type.ReadOnlyVector4;
import com.ardor3d.scenegraph.ByteBufferData;
import com.ardor3d.scenegraph.FloatBufferData;
import com.ardor3d.scenegraph.IndexBufferData;
import com.ardor3d.scenegraph.IntBufferData;
import com.ardor3d.scenegraph.ShortBufferData;
import com.ardor3d.util.Ardor3dException;
import com.ardor3d.util.Constants;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;

public final class BufferUtils {
    private static final Map<Buffer, Object> trackingHash = new WeakHashMap<Buffer, Object>();
    private static final Object ref = new Object();

    public static FloatBuffer createFloatBuffer(ReadOnlyColorRGBA ... data) {
        if (data == null) {
            return null;
        }
        return BufferUtils.createFloatBuffer(0, data.length, data);
    }

    public static FloatBuffer createFloatBuffer(int offset, int length, ReadOnlyColorRGBA ... data) {
        if (data == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBuffer(4 * length);
        for (int x = offset; x < length; ++x) {
            if (data[x] != null) {
                buff.put(data[x].getRed()).put(data[x].getGreen()).put(data[x].getBlue()).put(data[x].getAlpha());
                continue;
            }
            buff.put(0.0f).put(0.0f).put(0.0f).put(0.0f);
        }
        buff.flip();
        return buff;
    }

    public static FloatBuffer createColorBuffer(int colors) {
        FloatBuffer colorBuff = BufferUtils.createFloatBuffer(4 * colors);
        return colorBuff;
    }

    public static void setInBuffer(ReadOnlyColorRGBA color, FloatBuffer buf, int index) {
        buf.position(index * 4);
        buf.put(color.getRed());
        buf.put(color.getGreen());
        buf.put(color.getBlue());
        buf.put(color.getAlpha());
    }

    public static void populateFromBuffer(ColorRGBA store, FloatBuffer buf, int index) {
        store.setRed(buf.get(index * 4));
        store.setGreen(buf.get(index * 4 + 1));
        store.setBlue(buf.get(index * 4 + 2));
        store.setAlpha(buf.get(index * 4 + 3));
    }

    public static ColorRGBA[] getColorArray(FloatBuffer buff) {
        buff.rewind();
        ColorRGBA[] colors = new ColorRGBA[buff.limit() >> 2];
        for (int x = 0; x < colors.length; ++x) {
            ColorRGBA c;
            colors[x] = c = new ColorRGBA(buff.get(), buff.get(), buff.get(), buff.get());
        }
        return colors;
    }

    public static ColorRGBA[] getColorArray(FloatBufferData data, ReadOnlyColorRGBA defaults) {
        FloatBuffer buff = (FloatBuffer)data.getBuffer();
        buff.clear();
        ColorRGBA[] colors = new ColorRGBA[data.getTupleCount()];
        int tupleSize = data.getValuesPerTuple();
        for (int x = 0; x < colors.length; ++x) {
            ColorRGBA c = new ColorRGBA(defaults);
            c.setRed(buff.get());
            if (tupleSize > 1) {
                c.setGreen(buff.get());
            }
            if (tupleSize > 2) {
                c.setBlue(buff.get());
            }
            if (tupleSize > 3) {
                c.setAlpha(buff.get());
            }
            if (tupleSize > 4) {
                buff.position(buff.position() + tupleSize - 4);
            }
            colors[x] = c;
        }
        return colors;
    }

    public static void copyInternalColor(FloatBuffer buf, int fromPos, int toPos) {
        BufferUtils.copyInternal(buf, fromPos * 4, toPos * 4, 4);
    }

    public static boolean equals(ReadOnlyColorRGBA check, FloatBuffer buf, int index) {
        ColorRGBA temp = new ColorRGBA();
        BufferUtils.populateFromBuffer(temp, buf, index);
        return temp.equals((Object)check);
    }

    public static FloatBuffer createFloatBuffer(ReadOnlyVector4 ... data) {
        if (data == null) {
            return null;
        }
        return BufferUtils.createFloatBuffer(0, data.length, data);
    }

    public static FloatBuffer createFloatBuffer(int offset, int length, ReadOnlyVector4 ... data) {
        if (data == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBuffer(4 * length);
        for (int x = offset; x < length; ++x) {
            if (data[x] != null) {
                buff.put(data[x].getXf()).put(data[x].getYf()).put(data[x].getZf()).put(data[x].getWf());
                continue;
            }
            buff.put(0.0f).put(0.0f).put(0.0f);
        }
        buff.flip();
        return buff;
    }

    public static FloatBuffer createVector4Buffer(int vertices) {
        FloatBuffer vBuff = BufferUtils.createFloatBuffer(4 * vertices);
        return vBuff;
    }

    public static FloatBuffer createVector4Buffer(FloatBuffer buf, int vertices) {
        if (buf != null && buf.limit() == 4 * vertices) {
            buf.rewind();
            return buf;
        }
        return BufferUtils.createFloatBuffer(4 * vertices);
    }

    public static void setInBuffer(ReadOnlyVector4 vector, FloatBuffer buf, int index) {
        if (buf == null) {
            return;
        }
        if (vector == null) {
            buf.put(index * 4, 0.0f);
            buf.put(index * 4 + 1, 0.0f);
            buf.put(index * 4 + 2, 0.0f);
            buf.put(index * 4 + 3, 0.0f);
        } else {
            buf.put(index * 4, vector.getXf());
            buf.put(index * 4 + 1, vector.getYf());
            buf.put(index * 4 + 2, vector.getZf());
            buf.put(index * 4 + 3, vector.getWf());
        }
    }

    public static void populateFromBuffer(Vector4 vector, FloatBuffer buf, int index) {
        vector.setX((double)buf.get(index * 4));
        vector.setY((double)buf.get(index * 4 + 1));
        vector.setZ((double)buf.get(index * 4 + 2));
        vector.setW((double)buf.get(index * 4 + 3));
    }

    public static Vector4[] getVector4Array(FloatBuffer buff) {
        buff.clear();
        Vector4[] verts = new Vector4[buff.limit() / 4];
        for (int x = 0; x < verts.length; ++x) {
            Vector4 v;
            verts[x] = v = new Vector4((double)buff.get(), (double)buff.get(), (double)buff.get(), (double)buff.get());
        }
        return verts;
    }

    public static Vector4[] getVector4Array(FloatBufferData data, ReadOnlyVector4 defaults) {
        FloatBuffer buff = (FloatBuffer)data.getBuffer();
        buff.clear();
        Vector4[] verts = new Vector4[data.getTupleCount()];
        int tupleSize = data.getValuesPerTuple();
        for (int x = 0; x < verts.length; ++x) {
            Vector4 v = new Vector4(defaults);
            v.setX((double)buff.get());
            if (tupleSize > 1) {
                v.setY((double)buff.get());
            }
            if (tupleSize > 2) {
                v.setZ((double)buff.get());
            }
            if (tupleSize > 3) {
                v.setW((double)buff.get());
            }
            if (tupleSize > 4) {
                buff.position(buff.position() + tupleSize - 4);
            }
            verts[x] = v;
        }
        return verts;
    }

    public static void copyInternalVector4(FloatBuffer buf, int fromPos, int toPos) {
        BufferUtils.copyInternal(buf, fromPos * 4, toPos * 4, 4);
    }

    public static void normalizeVector4(FloatBuffer buf, int index) {
        Vector4 temp = Vector4.fetchTempInstance();
        BufferUtils.populateFromBuffer(temp, buf, index);
        temp.normalizeLocal();
        BufferUtils.setInBuffer((ReadOnlyVector4)temp, buf, index);
        Vector4.releaseTempInstance((Vector4)temp);
    }

    public static void addInBuffer(ReadOnlyVector4 toAdd, FloatBuffer buf, int index) {
        Vector4 temp = Vector4.fetchTempInstance();
        BufferUtils.populateFromBuffer(temp, buf, index);
        temp.addLocal(toAdd);
        BufferUtils.setInBuffer((ReadOnlyVector4)temp, buf, index);
        Vector4.releaseTempInstance((Vector4)temp);
    }

    public static void multInBuffer(ReadOnlyVector4 toMult, FloatBuffer buf, int index) {
        Vector4 temp = Vector4.fetchTempInstance();
        BufferUtils.populateFromBuffer(temp, buf, index);
        temp.multiplyLocal(toMult);
        BufferUtils.setInBuffer((ReadOnlyVector4)temp, buf, index);
        Vector4.releaseTempInstance((Vector4)temp);
    }

    public static boolean equals(ReadOnlyVector4 check, FloatBuffer buf, int index) {
        Vector4 temp = Vector4.fetchTempInstance();
        BufferUtils.populateFromBuffer(temp, buf, index);
        boolean equals = temp.equals((Object)check);
        Vector4.releaseTempInstance((Vector4)temp);
        return equals;
    }

    public static FloatBuffer createFloatBuffer(ReadOnlyVector3 ... data) {
        if (data == null) {
            return null;
        }
        return BufferUtils.createFloatBuffer(0, data.length, data);
    }

    public static FloatBuffer createFloatBuffer(int offset, int length, ReadOnlyVector3 ... data) {
        if (data == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBuffer(3 * length);
        for (int x = offset; x < length; ++x) {
            if (data[x] != null) {
                buff.put(data[x].getXf()).put(data[x].getYf()).put(data[x].getZf());
                continue;
            }
            buff.put(0.0f).put(0.0f).put(0.0f);
        }
        buff.flip();
        return buff;
    }

    public static FloatBuffer createVector3Buffer(int vertices) {
        FloatBuffer vBuff = BufferUtils.createFloatBuffer(3 * vertices);
        return vBuff;
    }

    public static FloatBuffer createVector3Buffer(FloatBuffer buf, int vertices) {
        if (buf != null && buf.limit() == 3 * vertices) {
            buf.rewind();
            return buf;
        }
        return BufferUtils.createFloatBuffer(3 * vertices);
    }

    public static void setInBuffer(ReadOnlyVector3 vector, FloatBuffer buf, int index) {
        if (buf == null) {
            return;
        }
        if (vector == null) {
            buf.put(index * 3, 0.0f);
            buf.put(index * 3 + 1, 0.0f);
            buf.put(index * 3 + 2, 0.0f);
        } else {
            buf.put(index * 3, vector.getXf());
            buf.put(index * 3 + 1, vector.getYf());
            buf.put(index * 3 + 2, vector.getZf());
        }
    }

    public static void populateFromBuffer(Vector3 vector, FloatBuffer buf, int index) {
        vector.setX((double)buf.get(index * 3));
        vector.setY((double)buf.get(index * 3 + 1));
        vector.setZ((double)buf.get(index * 3 + 2));
    }

    public static Vector3[] getVector3Array(FloatBuffer buff) {
        buff.clear();
        Vector3[] verts = new Vector3[buff.limit() / 3];
        for (int x = 0; x < verts.length; ++x) {
            Vector3 v;
            verts[x] = v = new Vector3((double)buff.get(), (double)buff.get(), (double)buff.get());
        }
        return verts;
    }

    public static Vector3[] getVector3Array(FloatBufferData data, ReadOnlyVector3 defaults) {
        FloatBuffer buff = (FloatBuffer)data.getBuffer();
        buff.clear();
        Vector3[] verts = new Vector3[data.getTupleCount()];
        int tupleSize = data.getValuesPerTuple();
        for (int x = 0; x < verts.length; ++x) {
            Vector3 v = new Vector3(defaults);
            v.setX((double)buff.get());
            if (tupleSize > 1) {
                v.setY((double)buff.get());
            }
            if (tupleSize > 2) {
                v.setZ((double)buff.get());
            }
            if (tupleSize > 3) {
                buff.position(buff.position() + tupleSize - 3);
            }
            verts[x] = v;
        }
        return verts;
    }

    public static void copyInternalVector3(FloatBuffer buf, int fromPos, int toPos) {
        BufferUtils.copyInternal(buf, fromPos * 3, toPos * 3, 3);
    }

    public static void normalizeVector3(FloatBuffer buf, int index) {
        Vector3 temp = Vector3.fetchTempInstance();
        BufferUtils.populateFromBuffer(temp, buf, index);
        temp.normalizeLocal();
        BufferUtils.setInBuffer((ReadOnlyVector3)temp, buf, index);
        Vector3.releaseTempInstance((Vector3)temp);
    }

    public static void addInBuffer(ReadOnlyVector3 toAdd, FloatBuffer buf, int index) {
        Vector3 temp = Vector3.fetchTempInstance();
        BufferUtils.populateFromBuffer(temp, buf, index);
        temp.addLocal(toAdd);
        BufferUtils.setInBuffer((ReadOnlyVector3)temp, buf, index);
        Vector3.releaseTempInstance((Vector3)temp);
    }

    public static void multInBuffer(ReadOnlyVector3 toMult, FloatBuffer buf, int index) {
        Vector3 temp = Vector3.fetchTempInstance();
        BufferUtils.populateFromBuffer(temp, buf, index);
        temp.multiplyLocal(toMult);
        BufferUtils.setInBuffer((ReadOnlyVector3)temp, buf, index);
        Vector3.releaseTempInstance((Vector3)temp);
    }

    public static boolean equals(ReadOnlyVector3 check, FloatBuffer buf, int index) {
        Vector3 temp = Vector3.fetchTempInstance();
        BufferUtils.populateFromBuffer(temp, buf, index);
        boolean equals = temp.equals((Object)check);
        Vector3.releaseTempInstance((Vector3)temp);
        return equals;
    }

    public static FloatBuffer createFloatBuffer(ReadOnlyVector2 ... data) {
        if (data == null) {
            return null;
        }
        return BufferUtils.createFloatBuffer(0, data.length, data);
    }

    public static FloatBuffer createFloatBuffer(int offset, int length, ReadOnlyVector2 ... data) {
        if (data == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBuffer(2 * length);
        for (int x = offset; x < length; ++x) {
            if (data[x] != null) {
                buff.put(data[x].getXf()).put(data[x].getYf());
                continue;
            }
            buff.put(0.0f).put(0.0f);
        }
        buff.flip();
        return buff;
    }

    public static FloatBuffer createVector2Buffer(int vertices) {
        FloatBuffer vBuff = BufferUtils.createFloatBuffer(2 * vertices);
        return vBuff;
    }

    public static FloatBuffer createVector2Buffer(FloatBuffer buf, int vertices) {
        if (buf != null && buf.limit() == 2 * vertices) {
            buf.rewind();
            return buf;
        }
        return BufferUtils.createFloatBuffer(2 * vertices);
    }

    public static void setInBuffer(ReadOnlyVector2 vector, FloatBuffer buf, int index) {
        buf.put(index * 2, vector.getXf());
        buf.put(index * 2 + 1, vector.getYf());
    }

    public static void populateFromBuffer(Vector2 vector, FloatBuffer buf, int index) {
        vector.setX((double)buf.get(index * 2));
        vector.setY((double)buf.get(index * 2 + 1));
    }

    public static Vector2[] getVector2Array(FloatBuffer buff) {
        buff.clear();
        Vector2[] verts = new Vector2[buff.limit() / 2];
        for (int x = 0; x < verts.length; ++x) {
            Vector2 v;
            verts[x] = v = new Vector2((double)buff.get(), (double)buff.get());
        }
        return verts;
    }

    public static Vector2[] getVector2Array(FloatBufferData data, ReadOnlyVector2 defaults) {
        FloatBuffer buff = (FloatBuffer)data.getBuffer();
        buff.clear();
        Vector2[] verts = new Vector2[data.getTupleCount()];
        int tupleSize = data.getValuesPerTuple();
        for (int x = 0; x < verts.length; ++x) {
            Vector2 v = new Vector2(defaults);
            v.setX((double)buff.get());
            if (tupleSize > 1) {
                v.setY((double)buff.get());
            }
            if (tupleSize > 2) {
                buff.position(buff.position() + tupleSize - 2);
            }
            verts[x] = v;
        }
        return verts;
    }

    public static void copyInternalVector2(FloatBuffer buf, int fromPos, int toPos) {
        BufferUtils.copyInternal(buf, fromPos * 2, toPos * 2, 2);
    }

    public static void normalizeVector2(FloatBuffer buf, int index) {
        Vector2 temp = Vector2.fetchTempInstance();
        BufferUtils.populateFromBuffer(temp, buf, index);
        temp.normalizeLocal();
        BufferUtils.setInBuffer((ReadOnlyVector2)temp, buf, index);
        Vector2.releaseTempInstance((Vector2)temp);
    }

    public static void addInBuffer(ReadOnlyVector2 toAdd, FloatBuffer buf, int index) {
        Vector2 temp = Vector2.fetchTempInstance();
        BufferUtils.populateFromBuffer(temp, buf, index);
        temp.addLocal(toAdd);
        BufferUtils.setInBuffer((ReadOnlyVector2)temp, buf, index);
        Vector2.releaseTempInstance((Vector2)temp);
    }

    public static void multInBuffer(ReadOnlyVector2 toMult, FloatBuffer buf, int index) {
        Vector2 temp = Vector2.fetchTempInstance();
        BufferUtils.populateFromBuffer(temp, buf, index);
        temp.multiplyLocal(toMult);
        BufferUtils.setInBuffer((ReadOnlyVector2)temp, buf, index);
        Vector2.releaseTempInstance((Vector2)temp);
    }

    public static boolean equals(ReadOnlyVector2 check, FloatBuffer buf, int index) {
        Vector2 temp = Vector2.fetchTempInstance();
        BufferUtils.populateFromBuffer(temp, buf, index);
        boolean equals = temp.equals((Object)check);
        Vector2.releaseTempInstance((Vector2)temp);
        return equals;
    }

    public static IntBuffer createIntBuffer(int ... data) {
        if (data == null) {
            return null;
        }
        IntBuffer buff = BufferUtils.createIntBuffer(data.length);
        buff.clear();
        buff.put(data);
        buff.flip();
        return buff;
    }

    public static int[] getIntArray(IntBuffer buff) {
        if (buff == null) {
            return null;
        }
        buff.rewind();
        int[] inds = new int[buff.limit()];
        for (int x = 0; x < inds.length; ++x) {
            inds[x] = buff.get();
        }
        return inds;
    }

    public static int[] getIntArray(IndexBufferData<?> buff) {
        if (buff == null || buff.getBufferLimit() == 0) {
            return null;
        }
        ((Buffer)buff.getBuffer()).rewind();
        int[] inds = new int[buff.getBufferLimit()];
        for (int x = 0; x < inds.length; ++x) {
            inds[x] = buff.get();
        }
        return inds;
    }

    public static float[] getFloatArray(FloatBuffer buff) {
        if (buff == null) {
            return null;
        }
        buff.clear();
        float[] inds = new float[buff.limit()];
        for (int x = 0; x < inds.length; ++x) {
            inds[x] = buff.get();
        }
        return inds;
    }

    public static DoubleBuffer createDoubleBufferOnHeap(int size) {
        DoubleBuffer buf = ByteBuffer.allocate(8 * size).order(ByteOrder.nativeOrder()).asDoubleBuffer();
        buf.clear();
        return buf;
    }

    public static DoubleBuffer createDoubleBuffer(int size) {
        DoubleBuffer buf = ByteBuffer.allocateDirect(8 * size).order(ByteOrder.nativeOrder()).asDoubleBuffer();
        buf.clear();
        if (Constants.trackDirectMemory) {
            trackingHash.put(buf, ref);
        }
        return buf;
    }

    public static DoubleBuffer createDoubleBuffer(DoubleBuffer buf, int size) {
        if (buf != null && buf.limit() == size) {
            buf.rewind();
            return buf;
        }
        buf = BufferUtils.createDoubleBuffer(size);
        return buf;
    }

    public static DoubleBuffer clone(DoubleBuffer buf) {
        if (buf == null) {
            return null;
        }
        buf.rewind();
        DoubleBuffer copy = buf.isDirect() ? BufferUtils.createDoubleBuffer(buf.limit()) : BufferUtils.createDoubleBufferOnHeap(buf.limit());
        copy.put(buf);
        return copy;
    }

    public static FloatBuffer createFloatBuffer(int size) {
        FloatBuffer buf = ByteBuffer.allocateDirect(4 * size).order(ByteOrder.nativeOrder()).asFloatBuffer();
        buf.clear();
        if (Constants.trackDirectMemory) {
            trackingHash.put(buf, ref);
        }
        return buf;
    }

    public static FloatBuffer createFloatBufferOnHeap(int size) {
        FloatBuffer buf = ByteBuffer.allocate(4 * size).order(ByteOrder.nativeOrder()).asFloatBuffer();
        buf.clear();
        return buf;
    }

    public static FloatBuffer createFloatBuffer(float ... data) {
        return BufferUtils.createFloatBuffer(null, data);
    }

    public static FloatBuffer createFloatBuffer(FloatBuffer reuseStore, float ... data) {
        FloatBuffer buff;
        if (data == null) {
            return null;
        }
        if (reuseStore == null || reuseStore.capacity() != data.length) {
            buff = BufferUtils.createFloatBuffer(data.length);
        } else {
            buff = reuseStore;
            buff.clear();
        }
        buff.clear();
        buff.put(data);
        buff.flip();
        return buff;
    }

    public static FloatBuffer createFloatBufferOnHeap(int offset, int length, ReadOnlyVector2 ... data) {
        if (data == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBufferOnHeap(2 * length);
        for (int x = offset; x < length; ++x) {
            if (data[x] != null) {
                buff.put(data[x].getXf()).put(data[x].getYf());
                continue;
            }
            buff.put(0.0f).put(0.0f);
        }
        buff.flip();
        return buff;
    }

    public static FloatBuffer createFloatBufferOnHeap(int offset, int length, ReadOnlyVector3 ... data) {
        if (data == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBufferOnHeap(3 * length);
        for (int x = offset; x < length; ++x) {
            if (data[x] != null) {
                buff.put(data[x].getXf()).put(data[x].getYf()).put(data[x].getZf());
                continue;
            }
            buff.put(0.0f).put(0.0f).put(0.0f);
        }
        buff.flip();
        return buff;
    }

    public static FloatBuffer createFloatBufferOnHeap(int offset, int length, ReadOnlyColorRGBA ... data) {
        if (data == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBufferOnHeap(4 * length);
        for (int x = offset; x < length; ++x) {
            if (data[x] != null) {
                buff.put(data[x].getRed()).put(data[x].getGreen()).put(data[x].getBlue()).put(data[x].getAlpha());
                continue;
            }
            buff.put(0.0f).put(0.0f).put(0.0f).put(0.0f);
        }
        buff.flip();
        return buff;
    }

    public static IntBuffer createIntBuffer(IntBuffer reuseStore, int ... data) {
        IntBuffer buff;
        if (data == null) {
            return null;
        }
        if (reuseStore == null || reuseStore.capacity() != data.length) {
            buff = BufferUtils.createIntBuffer(data.length);
        } else {
            buff = reuseStore;
            buff.clear();
        }
        buff.clear();
        buff.put(data);
        buff.flip();
        return buff;
    }

    public static void copy(FloatBuffer source, int fromPos, FloatBuffer destination, int toPos, int length) {
        int oldLimit = source.limit();
        source.position(fromPos);
        source.limit(fromPos + length);
        destination.position(toPos);
        destination.put(source);
        source.limit(oldLimit);
    }

    public static void copyInternal(FloatBuffer buf, int fromPos, int toPos, int length) {
        float[] data = new float[length];
        buf.position(fromPos);
        buf.get(data);
        buf.position(toPos);
        buf.put(data);
    }

    public static FloatBuffer clone(FloatBuffer buf) {
        if (buf == null) {
            return null;
        }
        buf.rewind();
        FloatBuffer copy = buf.isDirect() ? BufferUtils.createFloatBuffer(buf.limit()) : BufferUtils.createFloatBufferOnHeap(buf.limit());
        copy.put(buf);
        return copy;
    }

    public static IntBuffer createIntBufferOnHeap(int size) {
        IntBuffer buf = ByteBuffer.allocate(4 * size).order(ByteOrder.nativeOrder()).asIntBuffer();
        buf.clear();
        return buf;
    }

    public static IntBuffer createIntBuffer(int size) {
        IntBuffer buf = ByteBuffer.allocateDirect(4 * size).order(ByteOrder.nativeOrder()).asIntBuffer();
        buf.clear();
        if (Constants.trackDirectMemory) {
            trackingHash.put(buf, ref);
        }
        return buf;
    }

    public static IntBuffer createIntBuffer(IntBuffer buf, int size) {
        if (buf != null && buf.limit() == size) {
            buf.rewind();
            return buf;
        }
        buf = BufferUtils.createIntBuffer(size);
        return buf;
    }

    public static IntBuffer clone(IntBuffer buf) {
        if (buf == null) {
            return null;
        }
        buf.rewind();
        IntBuffer copy = buf.isDirect() ? BufferUtils.createIntBuffer(buf.limit()) : BufferUtils.createIntBufferOnHeap(buf.limit());
        copy.put(buf);
        return copy;
    }

    public static ByteBuffer createByteBuffer(int size) {
        ByteBuffer buf = ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
        buf.clear();
        if (Constants.trackDirectMemory) {
            trackingHash.put(buf, ref);
        }
        return buf;
    }

    public static ByteBuffer createByteBuffer(ByteBuffer buf, int size) {
        if (buf != null && buf.limit() == size) {
            buf.rewind();
            return buf;
        }
        buf = BufferUtils.createByteBuffer(size);
        return buf;
    }

    public static ByteBuffer clone(ByteBuffer buf) {
        if (buf == null) {
            return null;
        }
        buf.rewind();
        ByteBuffer copy = buf.isDirect() ? BufferUtils.createByteBuffer(buf.limit()) : BufferUtils.createByteBufferOnHeap(buf.limit());
        copy.put(buf);
        return copy;
    }

    public static ShortBuffer createShortBufferOnHeap(int size) {
        ShortBuffer buf = ByteBuffer.allocate(2 * size).order(ByteOrder.nativeOrder()).asShortBuffer();
        buf.clear();
        return buf;
    }

    public static ShortBuffer createShortBuffer(int size) {
        ShortBuffer buf = ByteBuffer.allocateDirect(2 * size).order(ByteOrder.nativeOrder()).asShortBuffer();
        buf.clear();
        if (Constants.trackDirectMemory) {
            trackingHash.put(buf, ref);
        }
        return buf;
    }

    public static ShortBuffer createShortBuffer(short ... data) {
        if (data == null) {
            return null;
        }
        ShortBuffer buff = BufferUtils.createShortBuffer(data.length);
        buff.clear();
        buff.put(data);
        buff.flip();
        return buff;
    }

    public static ShortBuffer createShortBuffer(ShortBuffer buf, int size) {
        if (buf != null && buf.limit() == size) {
            buf.rewind();
            return buf;
        }
        buf = BufferUtils.createShortBuffer(size);
        return buf;
    }

    public static ShortBuffer clone(ShortBuffer buf) {
        if (buf == null) {
            return null;
        }
        buf.rewind();
        ShortBuffer copy = buf.isDirect() ? BufferUtils.createShortBuffer(buf.limit()) : BufferUtils.createShortBufferOnHeap(buf.limit());
        copy.put(buf);
        return copy;
    }

    public static FloatBuffer ensureLargeEnough(FloatBuffer buffer, int required) {
        if (buffer == null || buffer.remaining() < required) {
            int position = buffer != null ? buffer.position() : 0;
            FloatBuffer newVerts = BufferUtils.createFloatBuffer(position + required);
            if (buffer != null) {
                buffer.rewind();
                newVerts.put(buffer);
                newVerts.position(position);
            }
            buffer = newVerts;
        }
        return buffer;
    }

    public static IndexBufferData<?> createIndexBufferData(int size, int maxValue) {
        if (maxValue < 256) {
            return BufferUtils.createIndexBufferData(size, ByteBufferData.class);
        }
        if (maxValue < 65536) {
            return BufferUtils.createIndexBufferData(size, ShortBufferData.class);
        }
        return BufferUtils.createIndexBufferData(size, IntBufferData.class);
    }

    public static IndexBufferData<?> createIndexBufferDataOnHeap(int size, int maxValue) {
        if (maxValue < 256) {
            return new ByteBufferData(BufferUtils.createByteBufferOnHeap(size));
        }
        if (maxValue < 65536) {
            return new ShortBufferData(BufferUtils.createShortBufferOnHeap(size));
        }
        return new IntBufferData(BufferUtils.createIntBufferOnHeap(size));
    }

    public static IndexBufferData<?> createIndexBufferData(int[] contents, int maxValue) {
        IndexBufferData<?> buffer = maxValue < 256 ? BufferUtils.createIndexBufferData(contents.length, ByteBufferData.class) : (maxValue < 65536 ? BufferUtils.createIndexBufferData(contents.length, ShortBufferData.class) : BufferUtils.createIndexBufferData(contents.length, IntBufferData.class));
        buffer.put(contents);
        return buffer;
    }

    public static IndexBufferData<?> createIndexBufferData(int size, Class<? extends IndexBufferData<?>> clazz) {
        try {
            return clazz.getConstructor(Integer.TYPE).newInstance(size);
        }
        catch (Exception ex) {
            throw new Ardor3dException(ex.getMessage(), ex);
        }
    }

    public static IndexBufferData<?> clone(IndexBufferData<?> buf) {
        if (buf == null) {
            return null;
        }
        IndexBufferData<?> copy = BufferUtils.createIndexBufferData(buf.getBufferLimit(), buf.getClass());
        if (buf.getBuffer() == null) {
            copy.setBuffer(null);
        } else {
            ((Buffer)buf.getBuffer()).rewind();
            copy.put(buf);
        }
        return copy;
    }

    public static ByteBuffer createByteBufferOnHeap(int size) {
        ByteBuffer buf = ByteBuffer.allocate(size).order(ByteOrder.nativeOrder());
        buf.clear();
        return buf;
    }

    public static ByteBuffer createByteBufferOnHeap(ByteBuffer buf, int size) {
        if (buf != null && buf.limit() == size) {
            buf.rewind();
            return buf;
        }
        buf = BufferUtils.createByteBufferOnHeap(size);
        return buf;
    }

    public static ByteBuffer cloneOnHeap(ByteBuffer buf) {
        if (buf == null) {
            return null;
        }
        buf.rewind();
        ByteBuffer copy = BufferUtils.createByteBufferOnHeap(buf.limit());
        copy.put(buf);
        return copy;
    }

    public static void printCurrentDirectMemory(StringBuilder store) {
        boolean printStout;
        long totalHeld = 0L;
        ArrayList<Buffer> bufs = new ArrayList<Buffer>(trackingHash.keySet());
        int fBufs = 0;
        int bBufs = 0;
        int iBufs = 0;
        int sBufs = 0;
        int dBufs = 0;
        int fBufsM = 0;
        int bBufsM = 0;
        int iBufsM = 0;
        int sBufsM = 0;
        int dBufsM = 0;
        for (Buffer b : bufs) {
            if (b instanceof ByteBuffer) {
                totalHeld += (long)b.capacity();
                bBufsM += b.capacity();
                ++bBufs;
                continue;
            }
            if (b instanceof FloatBuffer) {
                totalHeld += (long)(b.capacity() * 4);
                fBufsM += b.capacity() * 4;
                ++fBufs;
                continue;
            }
            if (b instanceof IntBuffer) {
                totalHeld += (long)(b.capacity() * 4);
                iBufsM += b.capacity() * 4;
                ++iBufs;
                continue;
            }
            if (b instanceof ShortBuffer) {
                totalHeld += (long)(b.capacity() * 2);
                sBufsM += b.capacity() * 2;
                ++sBufs;
                continue;
            }
            if (!(b instanceof DoubleBuffer)) continue;
            totalHeld += (long)(b.capacity() * 8);
            dBufsM += b.capacity() * 8;
            ++dBufs;
        }
        boolean bl = printStout = store == null;
        if (store == null) {
            store = new StringBuilder();
        }
        store.append("Existing buffers: ").append(bufs.size()).append('\n');
        store.append("(b: ").append(bBufs).append("  f: ").append(fBufs).append("  i: ").append(iBufs).append("  s: ").append(sBufs).append("  d: ").append(dBufs).append(')').append('\n');
        store.append("Total direct memory held: ").append(totalHeld / 1024L).append("kb\n");
        store.append("(b: ").append(bBufsM / 1024).append("kb  f: ").append(fBufsM / 1024).append("kb  i: ").append(iBufsM / 1024).append("kb  s: ").append(sBufsM / 1024).append("kb  d: ").append(dBufsM / 1024).append("kb)").append('\n');
        if (printStout) {
            System.out.println(store.toString());
        }
    }
}

