/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.geom;

import com.ardor3d.bounding.BoundingBox;
import com.ardor3d.bounding.BoundingSphere;
import com.ardor3d.bounding.BoundingVolume;
import com.ardor3d.bounding.OrientedBoundingBox;
import com.ardor3d.image.Texture2D;
import com.ardor3d.image.TextureStoreFormat;
import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.MathUtils;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.Camera;
import com.ardor3d.renderer.ContextManager;
import com.ardor3d.renderer.IndexMode;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.TextureRenderer;
import com.ardor3d.renderer.TextureRendererFactory;
import com.ardor3d.renderer.queue.RenderBucketType;
import com.ardor3d.renderer.state.BlendState;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.TextureState;
import com.ardor3d.renderer.state.WireframeState;
import com.ardor3d.renderer.state.ZBufferState;
import com.ardor3d.scenegraph.IndexBufferData;
import com.ardor3d.scenegraph.Line;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.scenegraph.Node;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.hint.CullHint;
import com.ardor3d.scenegraph.hint.LightCombineMode;
import com.ardor3d.scenegraph.hint.NormalsMode;
import com.ardor3d.scenegraph.shape.AxisRods;
import com.ardor3d.scenegraph.shape.Box;
import com.ardor3d.scenegraph.shape.OrientedBox;
import com.ardor3d.scenegraph.shape.Quad;
import com.ardor3d.scenegraph.shape.Sphere;
import com.ardor3d.util.ExtendedCamera;
import com.ardor3d.util.geom.BufferUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public final class Debugger {
    private static final Sphere boundingSphere = new Sphere("bsphere", 10, 10, 1.0);
    private static final Box boundingBox;
    private static final OrientedBox boundingOB;
    private static final Line normalLines;
    private static final Vector3 _normalVect;
    private static final Vector3 _normalVect2;
    public static final ColorRGBA NORMAL_COLOR_BASE;
    public static final ColorRGBA NORMAL_COLOR_TIP;
    public static final ColorRGBA TANGENT_COLOR_BASE;
    public static final ColorRGBA TANGENT_COLOR_TIP;
    protected static final BoundingBox measureBox;
    public static double AUTO_NORMAL_RATIO;
    private static final AxisRods rods;
    private static boolean axisInited;
    public static final int NORTHWEST = 0;
    public static final int NORTHEAST = 1;
    public static final int SOUTHEAST = 2;
    public static final int SOUTHWEST = 3;
    private static final Quad bQuad;
    private static Texture2D bufTexture;
    private static TextureRenderer bufTexRend;
    private static Line lineFrustum;
    private static final ExtendedCamera extendedCamera;

    public static void drawBounds(Spatial se, Renderer r) {
        Debugger.drawBounds(se, r, true);
    }

    public static void drawBounds(Spatial se, Renderer r, boolean doChildren) {
        Node n;
        if (se == null) {
            return;
        }
        if (se.getWorldBound() != null && se.getSceneHints().getCullHint() != CullHint.Always) {
            Camera cam = Camera.getCurrentCamera();
            int state = cam.getPlaneState();
            if (cam.contains(se.getWorldBound()) != Camera.FrustumIntersect.Outside) {
                Debugger.drawBounds(se.getWorldBound(), r);
            } else {
                doChildren = false;
            }
            cam.setPlaneState(state);
        }
        if (doChildren && se instanceof Node && (n = (Node)se).getNumberOfChildren() != 0) {
            int i = n.getNumberOfChildren();
            while (--i >= 0) {
                Debugger.drawBounds(n.getChild(i), r, true);
            }
        }
    }

    public static void drawBounds(BoundingVolume bv, Renderer r) {
        switch (bv.getType()) {
            case AABB: {
                Debugger.drawBoundingBox((BoundingBox)bv, r);
                break;
            }
            case Sphere: {
                Debugger.drawBoundingSphere((BoundingSphere)bv, r);
                break;
            }
            case OBB: {
                Debugger.drawOBB((OrientedBoundingBox)bv, r);
                break;
            }
        }
    }

    public static void setBoundsColor(ReadOnlyColorRGBA color) {
        boundingBox.setDefaultColor(color);
        boundingOB.setDefaultColor(color);
        boundingSphere.setDefaultColor(color);
    }

    public static void drawBoundingSphere(BoundingSphere sphere, Renderer r) {
        boundingSphere.setData(sphere.getCenter(), 10, 10, sphere.getRadius());
        boundingSphere.draw(r);
    }

    public static void drawBoundingBox(BoundingBox box, Renderer r) {
        boundingBox.setData(box.getCenter(), box.getXExtent(), box.getYExtent(), box.getZExtent());
        boundingBox.draw(r);
    }

    public static void drawOBB(OrientedBoundingBox box, Renderer r) {
        boundingOB.getCenter().set(box.getCenter());
        boundingOB.getxAxis().set(box.getXAxis());
        boundingOB.getYAxis().set(box.getYAxis());
        boundingOB.getZAxis().set(box.getZAxis());
        boundingOB.getExtent().set(box.getExtent());
        boundingOB.computeInformation();
        boundingOB.draw(r);
    }

    public static void drawNormals(Spatial element, Renderer r) {
        Debugger.drawNormals(element, r, -1.0, true);
    }

    public static void drawTangents(Spatial element, Renderer r) {
        Debugger.drawTangents(element, r, -1.0, true);
    }

    public static void drawNormals(Spatial element, Renderer r, double size, boolean doChildren) {
        Node n;
        if (element == null) {
            return;
        }
        Camera cam = Camera.getCurrentCamera();
        int state = cam.getPlaneState();
        if (element.getWorldBound() != null && cam.contains(element.getWorldBound()) == Camera.FrustumIntersect.Outside) {
            cam.setPlaneState(state);
            return;
        }
        cam.setPlaneState(state);
        if (element instanceof Mesh && element.getSceneHints().getCullHint() != CullHint.Always) {
            Mesh mesh = (Mesh)element;
            double rSize = size;
            if (rSize == -1.0) {
                BoundingVolume vol = element.getWorldBound();
                if (vol != null) {
                    measureBox.setCenter(vol.getCenter());
                    measureBox.setXExtent(0.0);
                    measureBox.setYExtent(0.0);
                    measureBox.setZExtent(0.0);
                    measureBox.mergeLocal(vol);
                    rSize = AUTO_NORMAL_RATIO * ((measureBox.getXExtent() + measureBox.getYExtent() + measureBox.getZExtent()) / 3.0);
                } else {
                    rSize = 1.0;
                }
                if (Double.isInfinite(rSize) || Double.isNaN(rSize)) {
                    rSize = 1.0;
                }
            }
            FloatBuffer norms = mesh.getMeshData().getNormalBuffer();
            FloatBuffer verts = mesh.getMeshData().getVertexBuffer();
            if (norms != null && verts != null && norms.limit() == verts.limit()) {
                FloatBuffer lineVerts = normalLines.getMeshData().getVertexBuffer();
                if (lineVerts.capacity() < 3 * (2 * mesh.getMeshData().getVertexCount())) {
                    normalLines.getMeshData().setVertexBuffer(null);
                    lineVerts = BufferUtils.createVector3Buffer(mesh.getMeshData().getVertexCount() * 2);
                    normalLines.getMeshData().setVertexBuffer(lineVerts);
                } else {
                    lineVerts.clear();
                    lineVerts.limit(6 * mesh.getMeshData().getVertexCount());
                    normalLines.getMeshData().setVertexBuffer(lineVerts);
                }
                FloatBuffer lineColors = normalLines.getMeshData().getColorBuffer();
                if (lineColors.capacity() < 4 * (2 * mesh.getMeshData().getVertexCount())) {
                    normalLines.getMeshData().setColorBuffer(null);
                    lineColors = BufferUtils.createColorBuffer(mesh.getMeshData().getVertexCount() * 2);
                    normalLines.getMeshData().setColorBuffer(lineColors);
                } else {
                    lineColors.clear();
                }
                IndexBufferData<?> lineInds = normalLines.getMeshData().getIndices();
                if (lineInds == null || lineInds.getBufferCapacity() < normalLines.getMeshData().getVertexCount()) {
                    normalLines.getMeshData().setIndices(null);
                    lineInds = BufferUtils.createIndexBufferData(mesh.getMeshData().getVertexCount() * 2, normalLines.getMeshData().getVertexCount() - 1);
                    normalLines.getMeshData().setIndices(lineInds);
                } else {
                    ((Buffer)lineInds.getBuffer()).clear();
                    ((Buffer)lineInds.getBuffer()).limit(normalLines.getMeshData().getVertexCount());
                }
                verts.rewind();
                norms.rewind();
                lineVerts.rewind();
                ((Buffer)lineInds.getBuffer()).rewind();
                for (int x = 0; x < mesh.getMeshData().getVertexCount(); ++x) {
                    _normalVect.set((double)verts.get(), (double)verts.get(), (double)verts.get());
                    mesh.getWorldTransform().applyForward(_normalVect);
                    lineVerts.put(_normalVect.getXf());
                    lineVerts.put(_normalVect.getYf());
                    lineVerts.put(_normalVect.getZf());
                    lineColors.put(NORMAL_COLOR_BASE.getRed());
                    lineColors.put(NORMAL_COLOR_BASE.getGreen());
                    lineColors.put(NORMAL_COLOR_BASE.getBlue());
                    lineColors.put(NORMAL_COLOR_BASE.getAlpha());
                    lineInds.put(x * 2);
                    _normalVect2.set((double)norms.get(), (double)norms.get(), (double)norms.get());
                    mesh.getWorldTransform().applyForwardVector(_normalVect2).normalizeLocal().multiplyLocal(rSize);
                    _normalVect.addLocal((ReadOnlyVector3)_normalVect2);
                    lineVerts.put(_normalVect.getXf());
                    lineVerts.put(_normalVect.getYf());
                    lineVerts.put(_normalVect.getZf());
                    lineColors.put(NORMAL_COLOR_TIP.getRed());
                    lineColors.put(NORMAL_COLOR_TIP.getGreen());
                    lineColors.put(NORMAL_COLOR_TIP.getBlue());
                    lineColors.put(NORMAL_COLOR_TIP.getAlpha());
                    lineInds.put(x * 2 + 1);
                }
                normalLines.onDraw(r);
            }
        }
        if (doChildren && element instanceof Node && (n = (Node)element).getNumberOfChildren() != 0) {
            int i = n.getNumberOfChildren();
            while (--i >= 0) {
                Debugger.drawNormals(n.getChild(i), r, size, true);
            }
        }
    }

    public static void drawTangents(Spatial element, Renderer r, double size, boolean doChildren) {
        Node n;
        if (element == null) {
            return;
        }
        Camera cam = Camera.getCurrentCamera();
        int state = cam.getPlaneState();
        if (element.getWorldBound() != null && cam.contains(element.getWorldBound()) == Camera.FrustumIntersect.Outside) {
            cam.setPlaneState(state);
            return;
        }
        cam.setPlaneState(state);
        if (element instanceof Mesh && element.getSceneHints().getCullHint() != CullHint.Always) {
            Mesh mesh = (Mesh)element;
            double rSize = size;
            if (rSize == -1.0) {
                BoundingVolume vol = element.getWorldBound();
                if (vol != null) {
                    measureBox.setCenter(vol.getCenter());
                    measureBox.setXExtent(0.0);
                    measureBox.setYExtent(0.0);
                    measureBox.setZExtent(0.0);
                    measureBox.mergeLocal(vol);
                    rSize = AUTO_NORMAL_RATIO * ((measureBox.getXExtent() + measureBox.getYExtent() + measureBox.getZExtent()) / 3.0);
                } else {
                    rSize = 1.0;
                }
            }
            FloatBuffer norms = mesh.getMeshData().getTangentBuffer();
            FloatBuffer verts = mesh.getMeshData().getVertexBuffer();
            if (norms != null && verts != null && norms.limit() == verts.limit()) {
                FloatBuffer lineVerts = normalLines.getMeshData().getVertexBuffer();
                if (lineVerts.capacity() < 3 * (2 * mesh.getMeshData().getVertexCount())) {
                    normalLines.getMeshData().setVertexBuffer(null);
                    lineVerts = BufferUtils.createVector3Buffer(mesh.getMeshData().getVertexCount() * 2);
                    normalLines.getMeshData().setVertexBuffer(lineVerts);
                } else {
                    lineVerts.clear();
                    lineVerts.limit(6 * mesh.getMeshData().getVertexCount());
                    normalLines.getMeshData().setVertexBuffer(lineVerts);
                }
                FloatBuffer lineColors = normalLines.getMeshData().getColorBuffer();
                if (lineColors.capacity() < 4 * (2 * mesh.getMeshData().getVertexCount())) {
                    normalLines.getMeshData().setColorBuffer(null);
                    lineColors = BufferUtils.createColorBuffer(mesh.getMeshData().getVertexCount() * 2);
                    normalLines.getMeshData().setColorBuffer(lineColors);
                } else {
                    lineColors.clear();
                }
                IndexBufferData<?> lineInds = normalLines.getMeshData().getIndices();
                if (lineInds == null || lineInds.getBufferCapacity() < normalLines.getMeshData().getVertexCount()) {
                    normalLines.getMeshData().setIndices(null);
                    lineInds = BufferUtils.createIndexBufferData(mesh.getMeshData().getVertexCount() * 2, normalLines.getMeshData().getVertexCount() - 1);
                    normalLines.getMeshData().setIndices(lineInds);
                } else {
                    ((Buffer)lineInds.getBuffer()).clear();
                    ((Buffer)lineInds.getBuffer()).limit(normalLines.getMeshData().getVertexCount());
                }
                verts.rewind();
                norms.rewind();
                lineVerts.rewind();
                ((Buffer)lineInds.getBuffer()).rewind();
                for (int x = 0; x < mesh.getMeshData().getVertexCount(); ++x) {
                    _normalVect.set((double)verts.get(), (double)verts.get(), (double)verts.get());
                    _normalVect.multiplyLocal(mesh.getWorldScale());
                    lineVerts.put(_normalVect.getXf());
                    lineVerts.put(_normalVect.getYf());
                    lineVerts.put(_normalVect.getZf());
                    lineColors.put(TANGENT_COLOR_BASE.getRed());
                    lineColors.put(TANGENT_COLOR_BASE.getGreen());
                    lineColors.put(TANGENT_COLOR_BASE.getBlue());
                    lineColors.put(TANGENT_COLOR_BASE.getAlpha());
                    lineInds.put(x * 2);
                    _normalVect.addLocal((double)norms.get() * rSize, (double)norms.get() * rSize, (double)norms.get() * rSize);
                    lineVerts.put(_normalVect.getXf());
                    lineVerts.put(_normalVect.getYf());
                    lineVerts.put(_normalVect.getZf());
                    lineColors.put(TANGENT_COLOR_TIP.getRed());
                    lineColors.put(TANGENT_COLOR_TIP.getGreen());
                    lineColors.put(TANGENT_COLOR_TIP.getBlue());
                    lineColors.put(TANGENT_COLOR_TIP.getAlpha());
                    lineInds.put(x * 2 + 1);
                }
                normalLines.setWorldTranslation(mesh.getWorldTranslation());
                normalLines.setWorldRotation(mesh.getWorldRotation());
                normalLines.onDraw(r);
            }
        }
        if (doChildren && element instanceof Node && (n = (Node)element).getNumberOfChildren() != 0) {
            int i = n.getNumberOfChildren();
            while (--i >= 0) {
                Debugger.drawTangents(n.getChild(i), r, size, true);
            }
        }
    }

    public static void drawAxis(Spatial spat, Renderer r) {
        Debugger.drawAxis(spat, r, true, false);
    }

    public static void drawAxis(Spatial spat, Renderer r, boolean drawChildren, boolean drawAll) {
        if (!axisInited) {
            BlendState blendState = new BlendState();
            blendState.setBlendEnabled(true);
            blendState.setSourceFunction(BlendState.SourceFunction.SourceAlpha);
            blendState.setDestinationFunction(BlendState.DestinationFunction.OneMinusSourceAlpha);
            rods.setRenderState(blendState);
            rods.updateGeometricState(0.0, false);
            axisInited = true;
        }
        if (drawAll || spat instanceof Mesh) {
            if (spat.getWorldBound() != null) {
                double rSize;
                BoundingVolume vol = spat.getWorldBound();
                if (vol != null) {
                    measureBox.setCenter(vol.getCenter());
                    measureBox.setXExtent(0.0);
                    measureBox.setYExtent(0.0);
                    measureBox.setZExtent(0.0);
                    measureBox.mergeLocal(vol);
                    rSize = 1.0 * ((measureBox.getXExtent() + measureBox.getYExtent() + measureBox.getZExtent()) / 3.0);
                } else {
                    rSize = 1.0;
                }
                rods.setTranslation(spat.getWorldBound().getCenter());
                rods.setScale(rSize);
            } else {
                rods.setTranslation(spat.getWorldTranslation());
                rods.setScale(spat.getWorldScale());
            }
            rods.setRotation(spat.getWorldRotation());
            rods.updateGeometricState(0.0, false);
            rods.draw(r);
        }
        if (spat instanceof Node && drawChildren) {
            Node n = (Node)spat;
            if (n.getNumberOfChildren() == 0) {
                return;
            }
            int count = n.getNumberOfChildren();
            for (int x = 0; x < count; ++x) {
                Debugger.drawAxis(n.getChild(x), r, drawChildren, drawAll);
            }
        }
    }

    public static void drawBuffer(TextureStoreFormat rttFormat, int location, Renderer r) {
        Camera cam = Camera.getCurrentCamera();
        Debugger.drawBuffer(rttFormat, location, r, (double)cam.getWidth() / 6.25);
    }

    public static void drawBuffer(TextureStoreFormat rttFormat, int location, Renderer r, double size) {
        int height;
        int width;
        Camera cam = Camera.getCurrentCamera();
        r.flushGraphics();
        double locationX = cam.getWidth();
        double locationY = cam.getHeight();
        bQuad.resize(size, (double)cam.getHeight() / (double)cam.getWidth() * size);
        if (bQuad.getLocalRenderState(RenderState.StateType.Texture) == null) {
            TextureState ts = new TextureState();
            bufTexture = new Texture2D();
            ts.setTexture(bufTexture);
            bQuad.setRenderState(ts);
        }
        if (!MathUtils.isPowerOfTwo((int)(width = cam.getWidth()))) {
            int newWidth = 2;
            while ((newWidth <<= 1) < width) {
            }
            bQuad.getMeshData().getTextureBuffer(0).put(4, (float)width / (float)newWidth);
            bQuad.getMeshData().getTextureBuffer(0).put(6, (float)width / (float)newWidth);
            width = newWidth;
        }
        if (!MathUtils.isPowerOfTwo((int)(height = cam.getHeight()))) {
            int newHeight = 2;
            while ((newHeight <<= 1) < height) {
            }
            bQuad.getMeshData().getTextureBuffer(0).put(1, (float)height / (float)newHeight);
            bQuad.getMeshData().getTextureBuffer(0).put(7, (float)height / (float)newHeight);
            height = newHeight;
        }
        if (bufTexRend == null) {
            bufTexRend = TextureRendererFactory.INSTANCE.createTextureRenderer(width, height, r, ContextManager.getCurrentContext().getCapabilities());
            bufTexRend.setupTexture(bufTexture);
        }
        bufTexRend.copyToTexture(bufTexture, 0, 0, width, height, 0, 0);
        double loc = size * 0.75;
        switch (location) {
            case 0: {
                locationX = loc;
                locationY -= loc;
                break;
            }
            case 1: {
                locationX -= loc;
                locationY -= loc;
                break;
            }
            case 2: {
                locationX -= loc;
                locationY = loc;
                break;
            }
            default: {
                locationX = loc;
                locationY = loc;
            }
        }
        bQuad.setWorldTranslation(locationX, locationY, 0.0);
        bQuad.updateGeometricState(0.0);
        bQuad.onDraw(r);
        r.flushGraphics();
    }

    public static void drawCameraFrustum(Renderer r, Camera camera, ReadOnlyColorRGBA color, short pattern, boolean drawOriginConnector) {
        Debugger.drawCameraFrustum(r, camera, camera.getFrustumNear(), camera.getFrustumFar(), color, pattern, drawOriginConnector);
    }

    public static void drawCameraFrustum(Renderer r, Camera camera, double fNear, double fFar, ReadOnlyColorRGBA color, short pattern, boolean drawOriginConnector) {
        if (lineFrustum == null) {
            FloatBuffer verts = BufferUtils.createVector3Buffer(24);
            FloatBuffer colors = BufferUtils.createColorBuffer(24);
            lineFrustum = new Line("Lines", verts, null, colors, null);
            lineFrustum.getMeshData().setIndexModes(new IndexMode[]{IndexMode.LineLoop, IndexMode.LineLoop, IndexMode.Lines, IndexMode.Lines});
            lineFrustum.getMeshData().setIndexLengths(new int[]{4, 4, 8, 8});
            lineFrustum.setLineWidth(2.0f);
            lineFrustum.getSceneHints().setLightCombineMode(LightCombineMode.Off);
            BlendState lineBlendState = new BlendState();
            lineBlendState.setEnabled(true);
            lineBlendState.setBlendEnabled(true);
            lineBlendState.setTestEnabled(true);
            lineBlendState.setSourceFunction(BlendState.SourceFunction.SourceAlpha);
            lineBlendState.setDestinationFunction(BlendState.DestinationFunction.OneMinusSourceAlpha);
            lineFrustum.setRenderState(lineBlendState);
            ZBufferState zstate = new ZBufferState();
            lineFrustum.setRenderState(zstate);
            lineFrustum.updateGeometricState(0.0);
            lineFrustum.getSceneHints().setRenderBucketType(RenderBucketType.Skip);
        }
        lineFrustum.setDefaultColor(color);
        lineFrustum.setStipplePattern(pattern);
        extendedCamera.set(camera);
        extendedCamera.calculateFrustum(fNear, fFar);
        FloatBuffer colors = lineFrustum.getMeshData().getColorBuffer();
        for (int i = 0; i < 16; ++i) {
            BufferUtils.setInBuffer(color, colors, i);
        }
        float alpha = drawOriginConnector ? 0.4f : 0.0f;
        for (int i = 16; i < 24; ++i) {
            colors.position(i * 4);
            colors.put(color.getRed());
            colors.put(color.getGreen());
            colors.put(color.getBlue());
            colors.put(alpha);
        }
        Vector3[] corners = extendedCamera.getCorners();
        FloatBuffer verts = lineFrustum.getMeshData().getVertexBuffer();
        BufferUtils.setInBuffer((ReadOnlyVector3)corners[0], verts, 0);
        BufferUtils.setInBuffer((ReadOnlyVector3)corners[1], verts, 1);
        BufferUtils.setInBuffer((ReadOnlyVector3)corners[2], verts, 2);
        BufferUtils.setInBuffer((ReadOnlyVector3)corners[3], verts, 3);
        BufferUtils.setInBuffer((ReadOnlyVector3)corners[4], verts, 4);
        BufferUtils.setInBuffer((ReadOnlyVector3)corners[5], verts, 5);
        BufferUtils.setInBuffer((ReadOnlyVector3)corners[6], verts, 6);
        BufferUtils.setInBuffer((ReadOnlyVector3)corners[7], verts, 7);
        BufferUtils.setInBuffer((ReadOnlyVector3)corners[0], verts, 8);
        BufferUtils.setInBuffer((ReadOnlyVector3)corners[4], verts, 9);
        BufferUtils.setInBuffer((ReadOnlyVector3)corners[1], verts, 10);
        BufferUtils.setInBuffer((ReadOnlyVector3)corners[5], verts, 11);
        BufferUtils.setInBuffer((ReadOnlyVector3)corners[2], verts, 12);
        BufferUtils.setInBuffer((ReadOnlyVector3)corners[6], verts, 13);
        BufferUtils.setInBuffer((ReadOnlyVector3)corners[3], verts, 14);
        BufferUtils.setInBuffer((ReadOnlyVector3)corners[7], verts, 15);
        BufferUtils.setInBuffer(extendedCamera.getLocation(), verts, 16);
        BufferUtils.setInBuffer((ReadOnlyVector3)corners[0], verts, 17);
        BufferUtils.setInBuffer(extendedCamera.getLocation(), verts, 18);
        BufferUtils.setInBuffer((ReadOnlyVector3)corners[1], verts, 19);
        BufferUtils.setInBuffer(extendedCamera.getLocation(), verts, 20);
        BufferUtils.setInBuffer((ReadOnlyVector3)corners[2], verts, 21);
        BufferUtils.setInBuffer(extendedCamera.getLocation(), verts, 22);
        BufferUtils.setInBuffer((ReadOnlyVector3)corners[3], verts, 23);
        lineFrustum.draw(r);
    }

    static {
        boundingSphere.getSceneHints().setRenderBucketType(RenderBucketType.Skip);
        boundingSphere.getSceneHints().setNormalsMode(NormalsMode.Off);
        boundingSphere.setRenderState(new WireframeState());
        boundingSphere.setRenderState(new ZBufferState());
        boundingSphere.updateWorldRenderStates(false);
        boundingBox = new Box("bbox", (ReadOnlyVector3)new Vector3(), 1.0, 1.0, 1.0);
        boundingBox.getSceneHints().setRenderBucketType(RenderBucketType.Skip);
        boundingBox.getSceneHints().setNormalsMode(NormalsMode.Off);
        boundingBox.setRenderState(new WireframeState());
        boundingBox.setRenderState(new ZBufferState());
        boundingBox.updateWorldRenderStates(false);
        boundingOB = new OrientedBox("bobox");
        boundingOB.getSceneHints().setRenderBucketType(RenderBucketType.Skip);
        boundingOB.getSceneHints().setNormalsMode(NormalsMode.Off);
        boundingOB.setRenderState(new WireframeState());
        boundingOB.setRenderState(new ZBufferState());
        boundingOB.updateWorldRenderStates(false);
        normalLines = new Line("normLine");
        normalLines.getSceneHints().setRenderBucketType(RenderBucketType.Skip);
        normalLines.setRenderState(new ZBufferState());
        normalLines.setLineWidth(3.0f);
        normalLines.getMeshData().setIndexMode(IndexMode.Lines);
        normalLines.getMeshData().setVertexBuffer(BufferUtils.createVector3Buffer(500));
        normalLines.getMeshData().setColorBuffer(BufferUtils.createColorBuffer(500));
        normalLines.updateWorldRenderStates(false);
        _normalVect = new Vector3();
        _normalVect2 = new Vector3();
        NORMAL_COLOR_BASE = new ColorRGBA(ColorRGBA.RED);
        NORMAL_COLOR_TIP = new ColorRGBA(ColorRGBA.PINK);
        TANGENT_COLOR_BASE = new ColorRGBA(ColorRGBA.ORANGE);
        TANGENT_COLOR_TIP = new ColorRGBA(ColorRGBA.YELLOW);
        measureBox = new BoundingBox();
        AUTO_NORMAL_RATIO = 0.05;
        rods = new AxisRods("debug_rods", true, 1.0);
        rods.getSceneHints().setRenderBucketType(RenderBucketType.Skip);
        axisInited = false;
        bQuad = new Quad("", 128.0, 128.0);
        bQuad.getSceneHints().setRenderBucketType(RenderBucketType.Ortho);
        bQuad.getSceneHints().setCullHint(CullHint.Never);
        extendedCamera = new ExtendedCamera();
    }
}

