/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.geom;

import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.Vector2;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyVector2;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.FloatBufferData;
import com.ardor3d.scenegraph.IndexBufferData;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.scenegraph.MeshData;
import com.ardor3d.scenegraph.Node;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.util.geom.BufferUtils;
import com.ardor3d.util.geom.VertGroupData;
import com.ardor3d.util.geom.VertKey;
import com.ardor3d.util.geom.VertMap;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public class GeometryTool {
    private static final Logger logger = Logger.getLogger(GeometryTool.class.getName());
    private final boolean nioBuffersAllocationOnHeapEnabled;

    public GeometryTool() {
        this(false);
    }

    public GeometryTool(boolean nioBuffersAllocationOnHeapEnabled) {
        this.nioBuffersAllocationOnHeapEnabled = nioBuffersAllocationOnHeapEnabled;
    }

    public VertMap minimizeVerts(Mesh mesh, EnumSet<MatchCondition> conditions) {
        VertGroupData groupData = new VertGroupData();
        groupData.setGroupConditions(0L, conditions);
        return this.minimizeVerts(mesh, groupData);
    }

    public VertMap minimizeVerts(Mesh mesh, VertGroupData groupData) {
        long start = System.currentTimeMillis();
        int vertCount = -1;
        int oldCount = mesh.getMeshData().getVertexCount();
        int newCount = 0;
        VertMap result = new VertMap(mesh);
        while (vertCount != newCount) {
            IndexBufferData<?> indexBuffer;
            int x;
            vertCount = mesh.getMeshData().getVertexCount();
            Vector3[] verts = BufferUtils.getVector3Array(mesh.getMeshData().getVertexCoords(), Vector3.ZERO);
            Vector3[] norms = null;
            if (mesh.getMeshData().getNormalBuffer() != null) {
                norms = BufferUtils.getVector3Array(mesh.getMeshData().getNormalCoords(), Vector3.UNIT_Y);
            }
            ColorRGBA[] colors = null;
            if (mesh.getMeshData().getColorBuffer() != null) {
                colors = BufferUtils.getColorArray(mesh.getMeshData().getColorCoords(), ColorRGBA.WHITE);
            }
            Vector2[][] tex = new Vector2[mesh.getMeshData().getNumberOfUnits()][];
            for (int x2 = 0; x2 < tex.length; ++x2) {
                if (mesh.getMeshData().getTextureCoords(x2) == null) continue;
                tex[x2] = BufferUtils.getVector2Array(mesh.getMeshData().getTextureCoords(x2), Vector2.ZERO);
            }
            HashMap<VertKey, Integer> store = new HashMap<VertKey, Integer>();
            HashMap<Integer, Integer> indexRemap = new HashMap<Integer, Integer>();
            int good = 0;
            int max = verts.length;
            for (x = 0; x < max; ++x) {
                long group = groupData.getGroupForVertex(x);
                VertKey vkey = new VertKey(verts[x], norms != null ? norms[x] : null, colors != null ? colors[x] : null, this.getTexs(tex, x), groupData.getGroupConditions(group), group);
                if (store.containsKey(vkey)) {
                    int newInd = (Integer)store.get(vkey);
                    if (indexRemap.containsKey(x)) {
                        indexRemap.put(max, newInd);
                    } else {
                        indexRemap.put(x, newInd);
                    }
                    if (x != --max) {
                        indexRemap.put(max, x);
                        verts[x] = verts[max];
                        verts[max] = null;
                        if (norms != null) {
                            norms[newInd].addLocal((ReadOnlyVector3)norms[x].normalizeLocal());
                            norms[x] = norms[max];
                        }
                        if (colors != null) {
                            colors[x] = colors[max];
                        }
                        for (int y = 0; y < tex.length; ++y) {
                            if (mesh.getMeshData().getTextureCoords(y) == null) continue;
                            tex[y][x] = tex[y][max];
                        }
                        --x;
                        continue;
                    }
                    verts[max] = null;
                    continue;
                }
                store.put(vkey, x);
                ++good;
            }
            if (norms != null) {
                for (Vector3 norm : norms) {
                    norm.normalizeLocal();
                }
            }
            mesh.getMeshData().setVertexBuffer(this.nioBuffersAllocationOnHeapEnabled ? BufferUtils.createFloatBufferOnHeap(0, good, (ReadOnlyVector3[])verts) : BufferUtils.createFloatBuffer(0, good, (ReadOnlyVector3[])verts));
            if (norms != null) {
                mesh.getMeshData().setNormalBuffer(this.nioBuffersAllocationOnHeapEnabled ? BufferUtils.createFloatBufferOnHeap(0, good, (ReadOnlyVector3[])norms) : BufferUtils.createFloatBuffer(0, good, (ReadOnlyVector3[])norms));
            }
            if (colors != null) {
                mesh.getMeshData().setColorBuffer(this.nioBuffersAllocationOnHeapEnabled ? BufferUtils.createFloatBufferOnHeap(0, good, (ReadOnlyColorRGBA[])colors) : BufferUtils.createFloatBuffer(0, good, (ReadOnlyColorRGBA[])colors));
            }
            for (x = 0; x < tex.length; ++x) {
                if (tex[x] == null) continue;
                mesh.getMeshData().setTextureBuffer(this.nioBuffersAllocationOnHeapEnabled ? BufferUtils.createFloatBufferOnHeap(0, good, (ReadOnlyVector2[])tex[x]) : BufferUtils.createFloatBuffer(0, good, (ReadOnlyVector2[])tex[x]), x);
            }
            if (mesh.getMeshData().getIndices() == null || mesh.getMeshData().getIndices().getBufferCapacity() == 0) {
                indexBuffer = this.nioBuffersAllocationOnHeapEnabled ? BufferUtils.createIndexBufferDataOnHeap(oldCount, oldCount) : BufferUtils.createIndexBufferData(oldCount, oldCount);
                mesh.getMeshData().setIndices(indexBuffer);
                for (int i = 0; i < oldCount; ++i) {
                    if (indexRemap.containsKey(i)) {
                        indexBuffer.put((Integer)indexRemap.get(i));
                        continue;
                    }
                    indexBuffer.put(i);
                }
            } else {
                indexBuffer = mesh.getMeshData().getIndices();
                int[] inds = BufferUtils.getIntArray(indexBuffer);
                indexBuffer.rewind();
                for (int i : inds) {
                    if (indexRemap.containsKey(i)) {
                        indexBuffer.put((Integer)indexRemap.get(i));
                        continue;
                    }
                    indexBuffer.put(i);
                }
            }
            result.applyRemapping(indexRemap);
            newCount = mesh.getMeshData().getVertexCount();
        }
        logger.info("Vertex reduction complete on: " + mesh + "  old vertex count: " + oldCount + " new vertex count: " + newCount + " (in " + (System.currentTimeMillis() - start) + " ms)");
        return result;
    }

    private Vector2[] getTexs(Vector2[][] tex, int i) {
        Vector2[] res = new Vector2[tex.length];
        for (int x = 0; x < tex.length; ++x) {
            if (tex[x] == null) continue;
            res[x] = tex[x][i];
        }
        return res;
    }

    public void trimEmptyBranches(Spatial spatial) {
        if (spatial instanceof Node) {
            Node node = (Node)spatial;
            int i = node.getNumberOfChildren();
            while (--i >= 0) {
                this.trimEmptyBranches(node.getChild(i));
            }
            if (node.getNumberOfChildren() <= 0) {
                spatial.removeFromParent();
            }
        }
    }

    public void convertIndexedGeometryIntoNonIndexedGeometry(MeshData meshData) {
        IndexBufferData<?> indices = meshData.getIndices();
        if (indices != null) {
            int numberOfUnits;
            FloatBuffer previousTangentBuffer;
            FloatBuffer previousFogBuffer;
            FloatBuffer previousColorBuffer;
            FloatBuffer previousNormalBuffer;
            FloatBuffer previousVertexBuffer = meshData.getVertexBuffer();
            if (previousVertexBuffer != null) {
                int valuesPerVertexTuple = meshData.getVertexCoords().getValuesPerTuple();
                FloatBuffer nextVertexBuffer = this.nioBuffersAllocationOnHeapEnabled ? BufferUtils.createFloatBufferOnHeap(indices.capacity() * valuesPerVertexTuple) : BufferUtils.createFloatBuffer(indices.capacity() * valuesPerVertexTuple);
                for (int indexIndex = 0; indexIndex < indices.capacity(); ++indexIndex) {
                    int vertexIndex = indices.get(indexIndex);
                    for (int coordIndex = 0; coordIndex < valuesPerVertexTuple; ++coordIndex) {
                        float vertexCoordValue = previousVertexBuffer.get(vertexIndex * valuesPerVertexTuple + coordIndex);
                        nextVertexBuffer.put(indexIndex * valuesPerVertexTuple + coordIndex, vertexCoordValue);
                    }
                }
                meshData.setVertexCoords(new FloatBufferData(nextVertexBuffer, valuesPerVertexTuple));
            }
            if ((previousNormalBuffer = meshData.getNormalBuffer()) != null) {
                int valuesPerNormalTuple = meshData.getNormalCoords().getValuesPerTuple();
                FloatBuffer nextNormalBuffer = this.nioBuffersAllocationOnHeapEnabled ? BufferUtils.createFloatBufferOnHeap(indices.capacity() * valuesPerNormalTuple) : BufferUtils.createFloatBuffer(indices.capacity() * valuesPerNormalTuple);
                for (int indexIndex = 0; indexIndex < indices.capacity(); ++indexIndex) {
                    int vertexIndex = indices.get(indexIndex);
                    for (int coordIndex = 0; coordIndex < valuesPerNormalTuple; ++coordIndex) {
                        float normalCoordValue = previousNormalBuffer.get(vertexIndex * valuesPerNormalTuple + coordIndex);
                        nextNormalBuffer.put(indexIndex * valuesPerNormalTuple + coordIndex, normalCoordValue);
                    }
                }
                meshData.setNormalCoords(new FloatBufferData(nextNormalBuffer, valuesPerNormalTuple));
            }
            if ((previousColorBuffer = meshData.getColorBuffer()) != null) {
                int valuesPerColorTuple = meshData.getColorCoords().getValuesPerTuple();
                FloatBuffer nextColorBuffer = this.nioBuffersAllocationOnHeapEnabled ? BufferUtils.createFloatBufferOnHeap(indices.capacity() * valuesPerColorTuple) : BufferUtils.createFloatBuffer(indices.capacity() * valuesPerColorTuple);
                for (int indexIndex = 0; indexIndex < indices.capacity(); ++indexIndex) {
                    int vertexIndex = indices.get(indexIndex);
                    for (int coordIndex = 0; coordIndex < valuesPerColorTuple; ++coordIndex) {
                        float colorCoordValue = previousColorBuffer.get(vertexIndex * valuesPerColorTuple + coordIndex);
                        nextColorBuffer.put(indexIndex * valuesPerColorTuple + coordIndex, colorCoordValue);
                    }
                }
                meshData.setColorCoords(new FloatBufferData(nextColorBuffer, valuesPerColorTuple));
            }
            if ((previousFogBuffer = meshData.getFogBuffer()) != null) {
                int valuesPerFogTuple = meshData.getFogCoords().getValuesPerTuple();
                FloatBuffer nextFogBuffer = this.nioBuffersAllocationOnHeapEnabled ? BufferUtils.createFloatBufferOnHeap(indices.capacity() * valuesPerFogTuple) : BufferUtils.createFloatBuffer(indices.capacity() * valuesPerFogTuple);
                for (int indexIndex = 0; indexIndex < indices.capacity(); ++indexIndex) {
                    int vertexIndex = indices.get(indexIndex);
                    for (int coordIndex = 0; coordIndex < valuesPerFogTuple; ++coordIndex) {
                        float fogCoordValue = previousFogBuffer.get(vertexIndex * valuesPerFogTuple + coordIndex);
                        nextFogBuffer.put(indexIndex * valuesPerFogTuple + coordIndex, fogCoordValue);
                    }
                }
                meshData.setFogCoords(new FloatBufferData(nextFogBuffer, valuesPerFogTuple));
            }
            if ((previousTangentBuffer = meshData.getTangentBuffer()) != null) {
                int valuesPerTangentTuple = meshData.getTangentCoords().getValuesPerTuple();
                FloatBuffer nextTangentBuffer = this.nioBuffersAllocationOnHeapEnabled ? BufferUtils.createFloatBufferOnHeap(indices.capacity() * valuesPerTangentTuple) : BufferUtils.createFloatBuffer(indices.capacity() * valuesPerTangentTuple);
                for (int indexIndex = 0; indexIndex < indices.capacity(); ++indexIndex) {
                    int vertexIndex = indices.get(indexIndex);
                    for (int coordIndex = 0; coordIndex < valuesPerTangentTuple; ++coordIndex) {
                        float tangentCoordValue = previousTangentBuffer.get(vertexIndex * valuesPerTangentTuple + coordIndex);
                        nextTangentBuffer.put(indexIndex * valuesPerTangentTuple + coordIndex, tangentCoordValue);
                    }
                }
                meshData.setTangentCoords(new FloatBufferData(nextTangentBuffer, valuesPerTangentTuple));
            }
            if ((numberOfUnits = meshData.getNumberOfUnits()) > 0) {
                List<FloatBufferData> previousTextureCoordsList = meshData.getTextureCoords();
                ArrayList<FloatBufferData> nextTextureCoordsList = new ArrayList<FloatBufferData>();
                for (int unitIndex = 0; unitIndex < numberOfUnits; ++unitIndex) {
                    FloatBufferData previousTextureCoords = previousTextureCoordsList.get(unitIndex);
                    if (previousTextureCoords == null) {
                        nextTextureCoordsList.add(null);
                        continue;
                    }
                    FloatBuffer previousTextureBuffer = (FloatBuffer)previousTextureCoords.getBuffer();
                    int valuesPerTextureTuple = previousTextureCoords.getValuesPerTuple();
                    FloatBuffer nextTextureBuffer = this.nioBuffersAllocationOnHeapEnabled ? BufferUtils.createFloatBufferOnHeap(indices.capacity() * valuesPerTextureTuple) : BufferUtils.createFloatBuffer(indices.capacity() * valuesPerTextureTuple);
                    for (int indexIndex = 0; indexIndex < indices.capacity(); ++indexIndex) {
                        int vertexIndex = indices.get(indexIndex);
                        for (int coordIndex = 0; coordIndex < valuesPerTextureTuple; ++coordIndex) {
                            float textureCoordValue = previousTextureBuffer.get(vertexIndex * valuesPerTextureTuple + coordIndex);
                            nextTextureBuffer.put(indexIndex * valuesPerTextureTuple + coordIndex, textureCoordValue);
                        }
                    }
                    nextTextureCoordsList.add(new FloatBufferData(nextTextureBuffer, valuesPerTextureTuple));
                }
                meshData.setTextureCoords(nextTextureCoordsList);
            }
            meshData.setIndices(null);
        }
    }

    public static enum MatchCondition {
        Normal,
        UVs,
        Color,
        Group;

    }
}

