/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.geom;

import com.ardor3d.renderer.IndexMode;
import com.ardor3d.scenegraph.IndexBufferData;
import com.ardor3d.scenegraph.MeshData;
import com.ardor3d.util.geom.BufferUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;

class IndexCombiner {
    Multimap<IndexMode, int[]> sectionMap = ArrayListMultimap.create();

    IndexCombiner() {
    }

    public void addEntry(MeshData source, int vertexOffset) {
        if (source.getIndices() == null) {
            int offset = 0;
            int indexModeCounter = 0;
            IndexMode[] modes = source.getIndexModes();
            int maxI = source.getSectionCount();
            for (int i = 0; i < maxI; ++i) {
                int size = source.getIndexLengths() != null ? source.getIndexLengths()[i] : source.getVertexCount();
                int[] indices = new int[size];
                for (int j = 0; j < size; ++j) {
                    indices[j] = j + vertexOffset + offset;
                }
                this.sectionMap.put((Object)modes[indexModeCounter], (Object)indices);
                offset += size;
                if (indexModeCounter >= modes.length - 1) continue;
                ++indexModeCounter;
            }
        } else {
            IndexBufferData<?> ib = source.getIndices();
            ib.rewind();
            int offset = 0;
            int indexModeCounter = 0;
            IndexMode[] modes = source.getIndexModes();
            int maxI = source.getSectionCount();
            for (int i = 0; i < maxI; ++i) {
                int size = source.getIndexLengths() != null ? source.getIndexLengths()[i] : source.getIndices().capacity();
                int[] indices = new int[size];
                for (int j = 0; j < size; ++j) {
                    indices[j] = ib.get(j + offset) + vertexOffset;
                }
                this.sectionMap.put((Object)modes[indexModeCounter], (Object)indices);
                offset += size;
                if (indexModeCounter >= modes.length - 1) continue;
                ++indexModeCounter;
            }
        }
    }

    public void saveTo(MeshData data) {
        ArrayList<Object> sections = new ArrayList<Object>();
        ArrayList<IndexMode> modes = new ArrayList<IndexMode>();
        int max = 0;
        block5: for (IndexMode mode : this.sectionMap.keySet()) {
            Collection sources = this.sectionMap.get((Object)mode);
            switch (mode) {
                case Triangles: 
                case Quads: 
                case Lines: 
                case Points: {
                    Object indices2;
                    int size = 0;
                    for (Object indices2 : sources) {
                        size += ((int[])indices2).length;
                    }
                    max += size;
                    Object newSection = BufferUtils.createIntBufferOnHeap(size);
                    indices2 = sources.iterator();
                    while (indices2.hasNext()) {
                        int[] indices3 = (int[])indices2.next();
                        ((IntBuffer)newSection).put(indices3);
                    }
                    sections.add(newSection);
                    modes.add(mode);
                    break;
                }
                case TriangleFan: 
                case QuadStrip: 
                case LineLoop: 
                case LineStrip: {
                    int size;
                    for (int[] indices : sources) {
                        size = indices.length;
                        max += size;
                        IntBuffer newSection = BufferUtils.createIntBufferOnHeap(size);
                        newSection.put(indices);
                        sections.add(newSection);
                        modes.add(mode);
                    }
                    continue block5;
                }
                case TriangleStrip: {
                    int size = 0;
                    for (int[] indices : sources) {
                        size += indices.length + 2;
                    }
                    max += (size -= 2);
                    Object newSection = BufferUtils.createIntBufferOnHeap(size);
                    int i = 0;
                    for (int[] indices : sources) {
                        if (i != 0) {
                            ((IntBuffer)newSection).put(indices[0]);
                        }
                        ((IntBuffer)newSection).put(indices);
                        if (i < sources.size() - 1) {
                            ((IntBuffer)newSection).put(indices[indices.length - 1]);
                        }
                        ++i;
                    }
                    sections.add(newSection);
                    modes.add(mode);
                    break;
                }
            }
        }
        IndexBufferData<?> finalIndices = BufferUtils.createIndexBufferData(max, data.getVertexCount() - 1);
        data.setIndices(finalIndices);
        int[] sectionCounts = new int[sections.size()];
        for (int i = 0; i < sectionCounts.length; ++i) {
            IntBuffer ib = (IntBuffer)sections.get(i);
            ib.rewind();
            sectionCounts[i] = ib.remaining();
            while (ib.hasRemaining()) {
                finalIndices.put(ib.get());
            }
        }
        data.setIndexLengths(sectionCounts);
        data.setIndexModes(modes.toArray(new IndexMode[modes.size()]));
    }
}

