/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.geom;

import com.ardor3d.bounding.BoundingVolume;
import com.ardor3d.renderer.IndexMode;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.scenegraph.FloatBufferData;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.scenegraph.MeshData;
import com.ardor3d.scenegraph.Node;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.visitor.Visitor;
import com.ardor3d.util.geom.IndexCombiner;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;

public class MeshCombiner {
    public static final float[] DEFAULT_COLOR = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    public static final float[] DEFAULT_NORMAL = new float[]{0.0f, 1.0f, 0.0f};
    public static final float[] DEFAULT_TEXCOORD = new float[]{0.0f};

    public static final Mesh combine(Node source) {
        return MeshCombiner.combine(source, new MeshCombineLogic());
    }

    public static final Mesh combine(Spatial source, MeshCombineLogic logic) {
        final ArrayList<Mesh> sources = new ArrayList<Mesh>();
        source.acceptVisitor(new Visitor(){

            @Override
            public void visit(Spatial spatial) {
                if (spatial instanceof Mesh) {
                    sources.add((Mesh)spatial);
                }
            }
        }, true);
        return MeshCombiner.combine(sources, logic);
    }

    public static final Mesh combine(Mesh ... sources) {
        return MeshCombiner.combine(new ArrayList<Mesh>(Arrays.asList(sources)));
    }

    public static final Mesh combine(Collection<Mesh> sources) {
        return MeshCombiner.combine(sources, new MeshCombineLogic());
    }

    public static final Mesh combine(Collection<Mesh> sources, MeshCombineLogic logic) {
        if (sources == null || sources.isEmpty()) {
            return null;
        }
        for (Mesh mesh : sources) {
            logic.addSource(mesh);
        }
        logic.initDataBuffers();
        logic.combineSources();
        return logic.getCombinedMesh();
    }

    public static class MeshCombineLogic {
        protected boolean useIndices = false;
        protected boolean useNormals = false;
        protected boolean useTextures = false;
        protected boolean useColors = false;
        protected boolean first = true;
        protected int maxTextures = 0;
        protected int totalVertices = 0;
        protected int totalIndices = 0;
        protected int texCoords = 2;
        protected int vertCoords = 3;
        protected IndexMode mode = null;
        protected EnumMap<RenderState.StateType, RenderState> states = null;
        protected MeshData data = new MeshData();
        protected BoundingVolume volumeType = null;
        protected List<Mesh> sources = new ArrayList<Mesh>();
        private FloatBufferData vertices;
        private FloatBufferData colors;
        private FloatBufferData normals;
        private List<FloatBufferData> texCoordsList;

        public Mesh getMesh() {
            Mesh mesh = new Mesh("combined");
            mesh.setMeshData(this.data);
            return mesh;
        }

        public Mesh getCombinedMesh() {
            Mesh mesh = this.getMesh();
            mesh.setModelBound(this.volumeType);
            for (RenderState state : this.states.values()) {
                mesh.setRenderState(state);
            }
            return mesh;
        }

        public void combineSources() {
            IndexCombiner iCombiner = new IndexCombiner();
            int vertexOffset = 0;
            for (Mesh mesh : this.sources) {
                int i;
                MeshData md = mesh.getMeshData();
                md.getVertexBuffer().rewind();
                ((FloatBuffer)this.vertices.getBuffer()).put(mesh.getWorldVectors(null));
                if (this.useNormals) {
                    FloatBuffer nb = md.getNormalBuffer();
                    if (nb != null) {
                        nb.rewind();
                        ((FloatBuffer)this.normals.getBuffer()).put(mesh.getWorldNormals(null));
                    } else {
                        for (i = 0; i < md.getVertexCount(); ++i) {
                            ((FloatBuffer)this.normals.getBuffer()).put(DEFAULT_NORMAL);
                        }
                    }
                }
                if (this.useColors) {
                    FloatBuffer cb = md.getColorBuffer();
                    if (cb != null) {
                        cb.rewind();
                        ((FloatBuffer)this.colors.getBuffer()).put(cb);
                    } else {
                        for (i = 0; i < md.getVertexCount(); ++i) {
                            ((FloatBuffer)this.colors.getBuffer()).put(DEFAULT_COLOR);
                        }
                    }
                }
                if (this.useTextures) {
                    for (int i2 = 0; i2 < this.maxTextures; ++i2) {
                        FloatBuffer dest = (FloatBuffer)this.texCoordsList.get(i2).getBuffer();
                        FloatBuffer tb = md.getTextureBuffer(i2);
                        if (tb != null) {
                            tb.rewind();
                            dest.put(tb);
                            continue;
                        }
                        for (int j = 0; j < md.getVertexCount() * this.texCoords; ++j) {
                            dest.put(DEFAULT_TEXCOORD);
                        }
                    }
                }
                if (!this.useIndices) continue;
                iCombiner.addEntry(md, vertexOffset);
                vertexOffset += md.getVertexCount();
            }
            if (this.useIndices) {
                iCombiner.saveTo(this.data);
            } else {
                this.data.setIndexLengths(null);
                this.data.setIndexMode(this.mode);
            }
        }

        public void initDataBuffers() {
            this.vertices = new FloatBufferData(this.totalVertices * this.vertCoords, this.vertCoords);
            this.data.setVertexCoords(this.vertices);
            this.colors = this.useColors ? new FloatBufferData(this.totalVertices * 4, 4) : null;
            this.data.setColorCoords(this.colors);
            this.normals = this.useNormals ? new FloatBufferData(this.totalVertices * 3, 3) : null;
            this.data.setNormalCoords(this.normals);
            this.texCoordsList = new ArrayList<FloatBufferData>(this.maxTextures);
            for (int i = 0; i < this.maxTextures; ++i) {
                this.texCoordsList.add(new FloatBufferData(this.totalVertices * this.texCoords, this.texCoords));
            }
            this.data.setTextureCoords(this.useTextures ? this.texCoordsList : null);
        }

        public void addSource(Mesh mesh) {
            this.sources.add(mesh);
            mesh.updateWorldTransform(false);
            MeshData md = mesh.getMeshData();
            if (this.first) {
                this.vertCoords = md.getVertexCoords().getValuesPerTuple();
                this.volumeType = mesh.getModelBound(null);
                this.states = mesh.getLocalRenderStates();
                this.first = false;
            } else if (this.vertCoords != md.getVertexCoords().getValuesPerTuple()) {
                throw new IllegalArgumentException("all MeshData vertex coords must use same tuple size.");
            }
            this.totalVertices += md.getVertexCount();
            if (this.useIndices || md.getIndices() != null) {
                this.useIndices = true;
                this.totalIndices = md.getIndices() != null ? (this.totalIndices += md.getIndices().capacity()) : (this.totalIndices += md.getVertexCount());
            } else {
                this.mode = md.getIndexMode(0);
            }
            if (!this.useNormals && md.getNormalBuffer() != null) {
                this.useNormals = true;
            }
            if (!this.useColors && md.getColorBuffer() != null) {
                this.useColors = true;
            }
            if (md.getNumberOfUnits() > 0) {
                if (!this.useTextures) {
                    this.useTextures = true;
                    this.texCoords = md.getTextureCoords(0).getValuesPerTuple();
                } else if (md.getTextureCoords(0) != null && this.texCoords != md.getTextureCoords(0).getValuesPerTuple()) {
                    throw new IllegalArgumentException("all MeshData objects with texcoords must use same tuple size.");
                }
                this.maxTextures = Math.max(this.maxTextures, md.getNumberOfUnits());
            }
        }
    }
}

