/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.geom;

import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.Mesh;
import java.util.Arrays;

public class NonIndexedNormalGenerator {
    private final Vector3 _temp1 = new Vector3();
    private final Vector3 _temp2 = new Vector3();
    private final Vector3 _temp3 = new Vector3();
    private int[] _indices;
    private double _creaseAngle;
    private double[] _faceNormals;
    private int[] _normalsToSet;

    public double[] generateNormals(double[] vertices, int[] indices, double creaseAngle) {
        this._indices = indices;
        this._creaseAngle = creaseAngle;
        this._normalsToSet = new int[10];
        Arrays.fill(this._normalsToSet, -1);
        this.initFaceNormals(vertices);
        if (creaseAngle < 1.0E-4 || indices == null) {
            return this.getFacetedVertexNormals();
        }
        return this.getVertexNormals();
    }

    private void initFaceNormals(double[] vertices) {
        this._faceNormals = new double[vertices.length / 3];
        int i = 0;
        while (i * 9 < vertices.length) {
            this._temp1.set(vertices[i * 9 + 0], vertices[i * 9 + 1], vertices[i * 9 + 2]);
            this._temp2.set(vertices[i * 9 + 3], vertices[i * 9 + 4], vertices[i * 9 + 5]);
            this._temp3.set(vertices[i * 9 + 6], vertices[i * 9 + 7], vertices[i * 9 + 8]);
            this._temp2.subtractLocal((ReadOnlyVector3)this._temp1);
            this._temp3.subtractLocal((ReadOnlyVector3)this._temp1);
            this._temp2.cross((ReadOnlyVector3)this._temp3, this._temp1);
            this._temp1.normalizeLocal();
            this._faceNormals[i * 3 + 0] = this._temp1.getX();
            this._faceNormals[i * 3 + 1] = this._temp1.getY();
            this._faceNormals[i * 3 + 2] = this._temp1.getZ();
            ++i;
        }
    }

    private double[] getVertexNormals() {
        double[] normals = new double[this._faceNormals.length * 3];
        boolean[] setNormals = new boolean[this._faceNormals.length];
        int i = 0;
        while (i * 3 < this._faceNormals.length) {
            for (int j = 0; j < 3; ++j) {
                if (setNormals[i * 3 + j]) continue;
                this.setInterpolatedNormal(normals, setNormals, i, j);
            }
            ++i;
        }
        return normals;
    }

    private void setInterpolatedNormal(double[] normals, boolean[] setNormals, int face, int vertex) {
        int i;
        this._temp1.set(this._faceNormals[face * 3 + 0], this._faceNormals[face * 3 + 1], this._faceNormals[face * 3 + 2]);
        this._temp2.set((ReadOnlyVector3)this._temp1);
        int vertIndex = this._indices[face * 3 + vertex];
        this._normalsToSet[0] = face * 3 + vertex;
        int count = 1;
        for (i = face * 3 + vertex + 1; i < this._indices.length; ++i) {
            if (this._indices[i] != vertIndex || setNormals[face * 3 + vertex]) continue;
            this._temp3.set(this._faceNormals[i / 3 * 3 + 0], this._faceNormals[i / 3 * 3 + 1], this._faceNormals[i / 3 * 3 + 2]);
            if (!(this._temp1.smallestAngleBetween((ReadOnlyVector3)this._temp3) < this._creaseAngle)) continue;
            this._normalsToSet = this.setValue(this._normalsToSet, count, i);
            ++count;
            this._temp2.addLocal((ReadOnlyVector3)this._temp3);
        }
        this._temp2.normalizeLocal();
        for (i = 0; i < this._normalsToSet.length && this._normalsToSet[i] != -1; ++i) {
            normals[this._normalsToSet[i] * 3 + 0] = this._temp2.getX();
            normals[this._normalsToSet[i] * 3 + 1] = this._temp2.getY();
            normals[this._normalsToSet[i] * 3 + 2] = this._temp2.getZ();
            setNormals[this._normalsToSet[i]] = true;
            this._normalsToSet[i] = -1;
        }
    }

    private int[] setValue(int[] array, int index, int value) {
        if (index >= array.length) {
            int[] temp = new int[array.length + 3];
            Arrays.fill(temp, -1);
            System.arraycopy(array, 0, temp, 0, array.length);
            array = temp;
        }
        array[index] = value;
        return array;
    }

    private double[] getFacetedVertexNormals() {
        double[] normals = new double[this._faceNormals.length * 3];
        int i = 0;
        while (i * 3 < this._faceNormals.length) {
            for (int j = 0; j < 3; ++j) {
                normals[i * 9 + j + 0] = this._faceNormals[i * 3 + j];
                normals[i * 9 + j + 3] = this._faceNormals[i * 3 + j];
                normals[i * 9 + j + 6] = this._faceNormals[i * 3 + j];
            }
            ++i;
        }
        return normals;
    }

    public void generateNormals(Mesh mesh) {
    }
}

