/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.geom;

import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.Vector2;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyVector2;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.IndexMode;
import com.ardor3d.scenegraph.IndexBufferData;
import com.ardor3d.scenegraph.IntBufferData;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.geom.BufferUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;

public class NormalGenerator {
    private static final Logger logger = Logger.getLogger(NormalGenerator.class.getName());
    private float _creaseAngle;
    private Vector3[] _sourceVerts;
    private ColorRGBA[] _sourceColors;
    private Vector2[] _sourceTexCoords;
    private int[] _sourceInds;
    private LinkedList<Triangle> _triangles;
    private List<Vector3> _destVerts;
    private List<ColorRGBA> _destColors;
    private List<Vector2> _destTexCoords;
    private LinkedList<Triangle> _destTris;
    private LinkedList<Edge> _edges;
    private LinkedList<LinkedList<Triangle>> _splitMeshes;
    private LinkedList<LinkedList<Edge>> _splitMeshBorders;
    private Vector3[] _splitVerts;
    private ColorRGBA[] _splitColors;
    private Vector2[] _splitTexCoords;
    private Vector3[] _splitNormals;
    private int[] _splitIndices;
    private boolean[] _borderIndices;
    private final Vector3 _compVect0 = new Vector3();
    private final Vector3 _compVect1 = new Vector3();

    public void generateNormals(Mesh mesh, float creaseAngle) {
        if (mesh != null) {
            this._creaseAngle = creaseAngle;
            this.generateNormals(mesh);
            this.cleanup();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void generateNormals(Mesh mesh) {
        void var4_9;
        IntBufferData indices;
        if (mesh.getMeshData().getIndexMode(0) != IndexMode.Triangles) {
            logger.info("Invalid triangles mode in " + mesh);
            return;
        }
        this._sourceInds = BufferUtils.getIntArray(mesh.getMeshData().getIndices());
        this._sourceVerts = BufferUtils.getVector3Array(mesh.getMeshData().getVertexBuffer());
        this._sourceColors = mesh.getMeshData().getColorBuffer() != null ? BufferUtils.getColorArray(mesh.getMeshData().getColorBuffer()) : null;
        this._sourceTexCoords = mesh.getMeshData().getTextureCoords(0) != null ? BufferUtils.getVector2Array((FloatBuffer)mesh.getMeshData().getTextureCoords(0).getBuffer()) : null;
        this.initialize();
        while (!this._triangles.isEmpty()) {
            this.createMeshSplit();
        }
        if (!this._splitMeshes.isEmpty()) {
            this._borderIndices = new boolean[this._sourceVerts.length];
            this.fillBorderIndices();
            this.duplicateCreaseVertices();
        }
        this._splitVerts = this._destVerts.toArray(new Vector3[this._destVerts.size()]);
        this._splitColors = this._destColors != null ? this._destColors.toArray(new ColorRGBA[this._destColors.size()]) : null;
        this._splitTexCoords = this._destTexCoords != null ? this._destTexCoords.toArray(new Vector2[this._destTexCoords.size()]) : null;
        this._splitNormals = new Vector3[this._destVerts.size()];
        for (int j = 0; j < this._splitNormals.length; ++j) {
            this._splitNormals[j] = new Vector3();
        }
        int numTris = 0;
        for (LinkedList linkedList : this._splitMeshes) {
            numTris += linkedList.size();
        }
        this._splitIndices = new int[numTris * 3];
        this.computeNormalsAndIndices();
        FloatBuffer vertices = mesh.getMeshData().getVertexBuffer();
        if (vertices.capacity() < this._splitVerts.length * 3) {
            vertices = BufferUtils.createFloatBuffer((ReadOnlyVector3[])this._splitVerts);
        } else {
            vertices.clear();
            for (Vector3 vertex : this._splitVerts) {
                vertices.put((float)vertex.getX()).put((float)vertex.getY()).put((float)vertex.getZ());
            }
            vertices.flip();
        }
        FloatBuffer floatBuffer = mesh.getMeshData().getNormalBuffer();
        if (floatBuffer == null || floatBuffer.capacity() < this._splitNormals.length * 3) {
            FloatBuffer floatBuffer2 = BufferUtils.createFloatBuffer((ReadOnlyVector3[])this._splitNormals);
        } else {
            floatBuffer.clear();
            for (Vector3 normal : this._splitNormals) {
                floatBuffer.put((float)normal.getX()).put((float)normal.getY()).put((float)normal.getZ());
            }
            floatBuffer.flip();
        }
        FloatBuffer colors = null;
        if (this._splitColors != null) {
            colors = mesh.getMeshData().getColorBuffer();
            if (colors.capacity() < this._splitColors.length * 4) {
                colors = BufferUtils.createFloatBuffer((ReadOnlyColorRGBA[])this._splitColors);
            } else {
                colors.clear();
                for (ColorRGBA color : this._splitColors) {
                    colors.put(color.getRed()).put(color.getGreen()).put(color.getBlue()).put(color.getAlpha());
                }
                colors.flip();
            }
        }
        FloatBuffer texCoords = null;
        if (this._splitTexCoords != null) {
            texCoords = (FloatBuffer)mesh.getMeshData().getTextureCoords(0).getBuffer();
            if (texCoords.capacity() < this._splitTexCoords.length * 2) {
                texCoords = BufferUtils.createFloatBuffer((ReadOnlyVector2[])this._splitTexCoords);
            } else {
                texCoords.clear();
                for (Vector2 texCoord : this._splitTexCoords) {
                    texCoords.put((float)texCoord.getX()).put((float)texCoord.getY());
                }
                texCoords.flip();
            }
        }
        if (((Buffer)(indices = mesh.getMeshData().getIndices()).getBuffer()).capacity() < this._splitIndices.length) {
            indices = new IntBufferData(BufferUtils.createIntBuffer(this._splitIndices));
        } else {
            ((Buffer)indices.getBuffer()).clear();
            for (int i : this._splitIndices) {
                ((IndexBufferData)indices).put(i);
            }
            ((Buffer)indices.getBuffer()).flip();
        }
        mesh.getMeshData().setVertexBuffer(vertices);
        mesh.getMeshData().setNormalBuffer((FloatBuffer)var4_9);
        if (colors != null) {
            mesh.getMeshData().setColorBuffer(colors);
        }
        mesh.getMeshData().getTextureCoords().clear();
        if (texCoords != null) {
            mesh.getMeshData().setTextureBuffer(texCoords, 0);
        }
        mesh.getMeshData().setIndices(indices);
    }

    private void initialize() {
        int i;
        this._destVerts = new ArrayList<Vector3>(this._sourceVerts.length);
        for (i = 0; i < this._sourceVerts.length; ++i) {
            this._destVerts.add(this._sourceVerts[i]);
        }
        if (this._sourceColors != null) {
            this._destColors = new ArrayList<ColorRGBA>(this._sourceColors.length);
            for (i = 0; i < this._sourceColors.length; ++i) {
                this._destColors.add(this._sourceColors[i]);
            }
        } else {
            this._destColors = null;
        }
        if (this._sourceTexCoords != null) {
            this._destTexCoords = new ArrayList<Vector2>(this._sourceTexCoords.length);
            for (i = 0; i < this._sourceTexCoords.length; ++i) {
                this._destTexCoords.add(this._sourceTexCoords[i]);
            }
        } else {
            this._destTexCoords = null;
        }
        this._triangles = new LinkedList();
        i = 0;
        while (i * 3 < this._sourceInds.length) {
            Triangle tri = new Triangle(this._sourceInds[i * 3 + 0], this._sourceInds[i * 3 + 1], this._sourceInds[i * 3 + 2]);
            tri.computeNormal(this._sourceVerts);
            this._triangles.add(tri);
            ++i;
        }
        if (this._splitMeshes == null) {
            this._splitMeshes = new LinkedList();
        } else {
            this._splitMeshes.clear();
        }
        if (this._splitMeshBorders == null) {
            this._splitMeshBorders = new LinkedList();
        } else {
            this._splitMeshBorders.clear();
        }
    }

    private void createMeshSplit() {
        Triangle newTri;
        this._destTris = new LinkedList();
        this._edges = new LinkedList();
        Triangle tri = this._triangles.removeFirst();
        this._destTris.addLast(tri);
        this._edges.addLast(tri.edges[0]);
        this._edges.addLast(tri.edges[1]);
        this._edges.addLast(tri.edges[2]);
        while ((newTri = this.insertTriangle()) != null) {
        }
        this._splitMeshes.addLast(this._destTris);
        this._splitMeshBorders.addLast(this._edges);
    }

    private Triangle insertTriangle() {
        int i;
        ListIterator triIt = this._triangles.listIterator();
        ListIterator<Edge> edgeIt = null;
        Triangle result = null;
        int connected = -1;
        Edge borderEdge = null;
        while (result == null && triIt.hasNext()) {
            Triangle tri = (Triangle)triIt.next();
            edgeIt = this._edges.listIterator();
            while (result == null && edgeIt.hasNext()) {
                borderEdge = (Edge)edgeIt.next();
                for (i = 0; i < tri.edges.length && result == null; ++i) {
                    if (!borderEdge.isConnectedTo(tri.edges[i]) || !this.checkAngle(tri, borderEdge.parent)) continue;
                    connected = i;
                    result = tri;
                }
            }
        }
        if (result != null) {
            triIt.remove();
            this._destTris.addLast(result);
            borderEdge.connected = result;
            Edge resultEdge = result.edges[connected];
            resultEdge.connected = borderEdge.parent;
            edgeIt.remove();
            edgeIt.add(result.edges[(connected + 1) % 3]);
            edgeIt.add(result.edges[(connected + 2) % 3]);
            if (borderEdge.newI0 > -1) {
                resultEdge.newI1 = borderEdge.newI0;
                result.edges[(connected + 1) % 3].newI0 = borderEdge.newI0;
            }
            if (borderEdge.newI1 > -1) {
                resultEdge.newI0 = borderEdge.newI1;
                result.edges[(connected + 2) % 3].newI1 = borderEdge.newI1;
            }
            for (i = connected + 1; i < connected + 3; ++i) {
                this.connectEdge(result, i % 3);
            }
        }
        return result;
    }

    private void connectEdge(Triangle triangle, int i) {
        Edge edge = triangle.edges[i];
        ListIterator edgeIt = this._edges.listIterator();
        boolean found = false;
        while (!found && edgeIt.hasNext()) {
            Edge borderEdge = (Edge)edgeIt.next();
            if (!borderEdge.isConnectedTo(edge)) continue;
            found = true;
            edgeIt.remove();
            this._edges.remove(edge);
            if (!this.checkAngle(triangle, borderEdge.parent)) {
                this.duplicateValues(edge.i0);
                triangle.edges[(i + 2) % 3].newI1 = edge.newI0 = this._destVerts.size() - 1;
                this.duplicateValues(edge.i1);
                triangle.edges[(i + 1) % 3].newI0 = edge.newI1 = this._destVerts.size() - 1;
                continue;
            }
            if (borderEdge.newI0 > -1) {
                edge.newI1 = borderEdge.newI0;
                triangle.edges[(i + 1) % 3].newI0 = borderEdge.newI0;
            }
            if (borderEdge.newI1 <= -1) continue;
            edge.newI0 = borderEdge.newI1;
            triangle.edges[(i + 2) % 3].newI1 = borderEdge.newI1;
        }
    }

    private boolean checkAngle(Triangle tri1, Triangle tri2) {
        return tri1.normal.smallestAngleBetween((ReadOnlyVector3)tri2.normal) <= (double)this._creaseAngle + 1.0E-4;
    }

    private void duplicateValues(int index) {
        this._destVerts.add(this._destVerts.get(index));
        if (this._destColors != null) {
            this._destColors.add(this._destColors.get(index));
        }
        if (this._destTexCoords != null) {
            this._destTexCoords.add(this._destTexCoords.get(index));
        }
    }

    private void fillBorderIndices() {
        Arrays.fill(this._borderIndices, false);
        LinkedList<Edge> edges0 = this._splitMeshBorders.getFirst();
        for (Edge edge : edges0) {
            this._borderIndices[edge.i0] = true;
            this._borderIndices[edge.i1] = true;
        }
    }

    private void duplicateCreaseVertices() {
        if (this._splitMeshBorders.size() < 2) {
            return;
        }
        int[] replacementIndices = new int[this._sourceVerts.length];
        ListIterator borderIt = this._splitMeshBorders.listIterator();
        borderIt.next();
        ListIterator meshIt = this._splitMeshes.listIterator();
        meshIt.next();
        while (borderIt.hasNext()) {
            Arrays.fill(replacementIndices, -1);
            LinkedList edges0 = (LinkedList)borderIt.next();
            LinkedList destTris0 = (LinkedList)meshIt.next();
            ListIterator edgeIt = edges0.listIterator();
            while (edgeIt.hasNext()) {
                Edge edge = (Edge)edgeIt.next();
                if (edge.newI0 == -1) {
                    if (this._borderIndices[edge.i0]) {
                        if (replacementIndices[edge.i0] == -1) {
                            this.duplicateValues(edge.i0);
                            replacementIndices[edge.i0] = this._destVerts.size() - 1;
                        }
                    } else {
                        replacementIndices[edge.i0] = edge.i0;
                    }
                }
                if (edge.newI1 != -1) continue;
                if (this._borderIndices[edge.i1]) {
                    if (replacementIndices[edge.i1] != -1) continue;
                    this.duplicateValues(edge.i1);
                    replacementIndices[edge.i1] = this._destVerts.size() - 1;
                    continue;
                }
                replacementIndices[edge.i1] = edge.i1;
            }
            for (int i = 0; i < this._borderIndices.length; ++i) {
                if (this._borderIndices[i]) {
                    for (Triangle tri : destTris0) {
                        this.replaceIndex(tri, i, replacementIndices[i]);
                    }
                    continue;
                }
                if (replacementIndices[i] <= -1) continue;
                this._borderIndices[i] = true;
            }
        }
    }

    private void replaceIndex(Triangle tri, int index, int replacement) {
        for (int i = 0; i < 3; ++i) {
            Edge edge = tri.edges[i];
            if (edge.newI0 == -1 && edge.i0 == index) {
                edge.newI0 = replacement;
            }
            if (edge.newI1 != -1 || edge.i1 != index) continue;
            edge.newI1 = replacement;
        }
    }

    private void computeNormalsAndIndices() {
        int count = 0;
        for (LinkedList linkedList : this._splitMeshes) {
            for (Triangle tri : linkedList) {
                for (int i = 0; i < 3; ++i) {
                    if (tri.edges[i].newI0 > -1) {
                        this._splitNormals[tri.edges[i].newI0].addLocal((ReadOnlyVector3)tri.normal);
                        this._splitIndices[count++] = tri.edges[i].newI0;
                        continue;
                    }
                    this._splitNormals[tri.edges[i].i0].addLocal((ReadOnlyVector3)tri.normal);
                    this._splitIndices[count++] = tri.edges[i].i0;
                }
            }
        }
        for (int i = 0; i < this._splitNormals.length; ++i) {
            if (!(this._splitNormals[i].distanceSquared(Vector3.ZERO) > 1.0E-4)) continue;
            this._splitNormals[i].normalizeLocal();
        }
    }

    private void cleanup() {
        this._creaseAngle = 0.0f;
        Arrays.fill(this._sourceVerts, null);
        this._sourceVerts = null;
        if (this._sourceColors != null) {
            Arrays.fill(this._sourceColors, null);
            this._sourceColors = null;
        }
        if (this._sourceTexCoords != null) {
            Arrays.fill(this._sourceTexCoords, null);
            this._sourceTexCoords = null;
        }
        this._sourceInds = null;
        if (this._triangles != null) {
            this._triangles.clear();
            this._triangles = null;
        }
        if (this._destVerts != null) {
            this._destVerts.clear();
            this._destVerts = null;
        }
        if (this._destColors != null) {
            this._destColors.clear();
            this._destColors = null;
        }
        if (this._destTexCoords != null) {
            this._destTexCoords.clear();
            this._destTexCoords = null;
        }
        if (this._destTris != null) {
            this._destTris.clear();
            this._destTris = null;
        }
        if (this._edges != null) {
            this._edges.clear();
            this._edges = null;
        }
        if (this._splitMeshes != null) {
            for (LinkedList linkedList : this._splitMeshes) {
                linkedList.clear();
            }
            this._splitMeshes.clear();
            this._splitMeshes = null;
        }
        if (this._splitMeshBorders != null) {
            for (LinkedList linkedList : this._splitMeshBorders) {
                linkedList.clear();
            }
            this._splitMeshBorders.clear();
            this._splitMeshBorders = null;
        }
        this._splitVerts = null;
        this._splitNormals = null;
        this._splitColors = null;
        this._splitTexCoords = null;
        this._splitIndices = null;
        this._borderIndices = null;
    }

    private class Edge {
        public int i0;
        public int i1;
        public int newI0 = -1;
        public int newI1 = -1;
        public Triangle parent;
        public Triangle connected;

        public Edge(Triangle parent, int i0, int i1) {
            this.parent = parent;
            this.i0 = i0;
            this.i1 = i1;
        }

        public boolean isConnectedTo(Edge other) {
            return this.i0 == other.i1 && this.i1 == other.i0;
        }

        public String toString() {
            String result = "Edge (";
            result = this.newI0 > -1 ? result + this.newI0 : result + this.i0;
            result = result + ", ";
            result = this.newI1 > -1 ? result + this.newI1 : result + this.i1;
            result = result + ")";
            return result;
        }
    }

    private class Triangle {
        public Edge[] edges = new Edge[3];
        public Vector3 normal = new Vector3(0.0, 0.0, 0.0);

        public Triangle(int i0, int i1, int i2) {
            this.edges[0] = new Edge(this, i0, i1);
            this.edges[1] = new Edge(this, i1, i2);
            this.edges[2] = new Edge(this, i2, i0);
        }

        public void computeNormal(Vector3[] verts) {
            int i0 = this.edges[0].i0;
            int i1 = this.edges[1].i0;
            int i2 = this.edges[2].i0;
            verts[i2].subtract((ReadOnlyVector3)verts[i1], NormalGenerator.this._compVect0);
            verts[i0].subtract((ReadOnlyVector3)verts[i1], NormalGenerator.this._compVect1);
            this.normal.set((ReadOnlyVector3)NormalGenerator.this._compVect0.crossLocal((ReadOnlyVector3)NormalGenerator.this._compVect1)).normalizeLocal();
        }

        public int indexOf(Edge edge) {
            for (int i = 0; i < 3; ++i) {
                if (this.edges[i] != edge) continue;
                return i;
            }
            return -1;
        }

        public String toString() {
            StringBuilder result = new StringBuilder("Triangle (");
            for (int i = 0; i < 3; ++i) {
                Edge edge = this.edges[i];
                if (edge == null) {
                    result.append('?');
                } else if (edge.newI0 > -1) {
                    result.append(edge.newI0);
                } else {
                    result.append(edge.i0);
                }
                if (i >= 2) continue;
                result.append(", ");
            }
            result.append(')');
            return result.toString();
        }
    }
}

