/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.geom;

import com.ardor3d.math.Vector2;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.IndexBufferData;
import com.ardor3d.scenegraph.MeshData;
import com.ardor3d.util.geom.BufferUtils;
import java.nio.FloatBuffer;

public class TangentUtil {
    public static FloatBuffer generateTangentBuffer(MeshData meshData) {
        return TangentUtil.generateTangentBuffer(meshData, 0);
    }

    public static FloatBuffer generateTangentBuffer(MeshData meshData, int uvUnit) {
        FloatBuffer vertexBuffer = meshData.getVertexBuffer();
        if (vertexBuffer == null) {
            throw new IllegalArgumentException("Vertex buffer is null!");
        }
        FloatBuffer normalBuffer = meshData.getNormalBuffer();
        if (normalBuffer == null) {
            throw new IllegalArgumentException("Normal buffer is null!");
        }
        FloatBuffer textureBuffer = meshData.getTextureBuffer(uvUnit);
        if (textureBuffer == null && uvUnit != 0) {
            textureBuffer = meshData.getTextureBuffer(0);
        }
        if (textureBuffer == null) {
            throw new IllegalArgumentException("Texture buffer is null!");
        }
        IndexBufferData<?> indexBuffer = meshData.getIndices();
        if (indexBuffer == null) {
            throw new IllegalArgumentException("Index buffer is null!");
        }
        int vertexCount = meshData.getVertexCount();
        int triangleCount = meshData.getTotalPrimitiveCount();
        Vector3[] tan1 = new Vector3[vertexCount];
        Vector3[] tan2 = new Vector3[vertexCount];
        for (int i = 0; i < vertexCount; ++i) {
            tan1[i] = new Vector3();
            tan2[i] = new Vector3();
        }
        Vector3[] vertex = BufferUtils.getVector3Array(vertexBuffer);
        Vector3[] normal = BufferUtils.getVector3Array(normalBuffer);
        Vector2[] texcoord = BufferUtils.getVector2Array(textureBuffer);
        for (int a = 0; a < triangleCount; ++a) {
            int i1 = indexBuffer.get(a * 3);
            int i2 = indexBuffer.get(a * 3 + 1);
            int i3 = indexBuffer.get(a * 3 + 2);
            Vector3 v1 = vertex[i1];
            Vector3 v2 = vertex[i2];
            Vector3 v3 = vertex[i3];
            Vector2 w1 = texcoord[i1];
            Vector2 w2 = texcoord[i2];
            Vector2 w3 = texcoord[i3];
            float x1 = v2.getXf() - v1.getXf();
            float x2 = v3.getXf() - v1.getXf();
            float y1 = v2.getYf() - v1.getYf();
            float y2 = v3.getYf() - v1.getYf();
            float z1 = v2.getZf() - v1.getZf();
            float z2 = v3.getZf() - v1.getZf();
            float s1 = w2.getXf() - w1.getXf();
            float s2 = w3.getXf() - w1.getXf();
            float t1 = w2.getYf() - w1.getYf();
            float t2 = w3.getYf() - w1.getYf();
            float r = 1.0f / (s1 * t2 - s2 * t1);
            if (Float.isNaN(r) || Float.isInfinite(r)) continue;
            Vector3 sdir = new Vector3((double)((t2 * x1 - t1 * x2) * r), (double)((t2 * y1 - t1 * y2) * r), (double)((t2 * z1 - t1 * z2) * r));
            Vector3 tdir = new Vector3((double)((s1 * x2 - s2 * x1) * r), (double)((s1 * y2 - s2 * y1) * r), (double)((s1 * z2 - s2 * z1) * r));
            tan1[i1].addLocal((ReadOnlyVector3)sdir);
            tan1[i2].addLocal((ReadOnlyVector3)sdir);
            tan1[i3].addLocal((ReadOnlyVector3)sdir);
            tan2[i1].addLocal((ReadOnlyVector3)tdir);
            tan2[i2].addLocal((ReadOnlyVector3)tdir);
            tan2[i3].addLocal((ReadOnlyVector3)tdir);
        }
        FloatBuffer tangentBuffer = BufferUtils.createVector4Buffer(vertexCount);
        Vector3 calc1 = new Vector3();
        Vector3 calc2 = new Vector3();
        for (int a = 0; a < vertexCount; ++a) {
            Vector3 n = normal[a];
            Vector3 t = tan1[a];
            double dot = n.dot((ReadOnlyVector3)t);
            calc1.set((ReadOnlyVector3)t).subtractLocal((ReadOnlyVector3)n.multiply(dot, calc2)).normalizeLocal();
            tangentBuffer.put(calc1.getXf()).put(calc1.getYf()).put(calc1.getZf());
            dot = calc1.set((ReadOnlyVector3)n).crossLocal((ReadOnlyVector3)t).dot((ReadOnlyVector3)tan2[a]);
            float w = dot < 0.0 ? -1.0f : 1.0f;
            tangentBuffer.put(w);
        }
        return tangentBuffer;
    }
}

