/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.geom;

import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.Vector2;
import com.ardor3d.math.Vector3;
import com.ardor3d.util.geom.GeometryTool;
import java.util.EnumSet;

public class VertKey {
    private final Vector3 _vert;
    private final Vector3 _norm;
    private final ColorRGBA _color;
    private final Vector2[] _texs;
    private final long _smoothGroup;
    private final EnumSet<GeometryTool.MatchCondition> _options;
    private int _hashCode = 0;

    public VertKey(Vector3 vert, Vector3 norm, ColorRGBA color, Vector2[] texs, EnumSet<GeometryTool.MatchCondition> options) {
        this(vert, norm, color, texs, options, 0L);
    }

    public VertKey(Vector3 vert, Vector3 norm, ColorRGBA color, Vector2[] texs, EnumSet<GeometryTool.MatchCondition> options, long smoothGroup) {
        this._vert = vert;
        this._options = options != null ? options : EnumSet.noneOf(GeometryTool.MatchCondition.class);
        this._norm = this._options.contains((Object)GeometryTool.MatchCondition.Normal) ? norm : null;
        this._color = this._options.contains((Object)GeometryTool.MatchCondition.Color) ? color : null;
        this._texs = this._options.contains((Object)GeometryTool.MatchCondition.UVs) ? texs : null;
        this._smoothGroup = this._options.contains((Object)GeometryTool.MatchCondition.Group) ? smoothGroup : 0L;
    }

    public int hashCode() {
        if (this._hashCode != 0) {
            return this._hashCode;
        }
        this._hashCode = this._vert.hashCode();
        if (this._options.contains((Object)GeometryTool.MatchCondition.Normal) && this._norm != null) {
            long x = Double.doubleToLongBits(this._norm.getX());
            this._hashCode += 31 * this._hashCode + (int)(x ^ x >>> 32);
            long y = Double.doubleToLongBits(this._norm.getY());
            this._hashCode += 31 * this._hashCode + (int)(y ^ y >>> 32);
            long z = Double.doubleToLongBits(this._norm.getZ());
            this._hashCode += 31 * this._hashCode + (int)(z ^ z >>> 32);
        }
        if (this._options.contains((Object)GeometryTool.MatchCondition.Color) && this._color != null) {
            int r = Float.floatToIntBits(this._color.getRed());
            this._hashCode += 31 * this._hashCode + r;
            int g = Float.floatToIntBits(this._color.getGreen());
            this._hashCode += 31 * this._hashCode + g;
            int b = Float.floatToIntBits(this._color.getBlue());
            this._hashCode += 31 * this._hashCode + b;
            int a = Float.floatToIntBits(this._color.getAlpha());
            this._hashCode += 31 * this._hashCode + a;
        }
        if (this._options.contains((Object)GeometryTool.MatchCondition.UVs) && this._texs != null) {
            for (int i = 0; i < this._texs.length; ++i) {
                if (this._texs[i] == null) continue;
                long x = Double.doubleToLongBits(this._texs[i].getX());
                this._hashCode += 31 * this._hashCode + (int)(x ^ x >>> 32);
                long y = Double.doubleToLongBits(this._texs[i].getY());
                this._hashCode += 31 * this._hashCode + (int)(y ^ y >>> 32);
            }
        }
        if (this._options.contains((Object)GeometryTool.MatchCondition.Group)) {
            this._hashCode = (int)((long)this._hashCode + ((long)(31 * this._hashCode) + this._smoothGroup));
        }
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VertKey)) {
            return false;
        }
        VertKey other = (VertKey)obj;
        if (other._options != this._options) {
            return false;
        }
        if (!other._vert.equals((Object)this._vert)) {
            return false;
        }
        if (this._options.contains((Object)GeometryTool.MatchCondition.Normal) && (this._norm != null ? !this._norm.equals((Object)other._norm) : other._norm != null)) {
            return false;
        }
        if (this._options.contains((Object)GeometryTool.MatchCondition.Color) && (this._color != null ? !this._color.equals((Object)other._color) : other._color != null)) {
            return false;
        }
        if (this._options.contains((Object)GeometryTool.MatchCondition.UVs)) {
            if (this._texs != null) {
                if (other._texs == null || other._texs.length != this._texs.length) {
                    return false;
                }
                for (int x = 0; x < this._texs.length; ++x) {
                    if (!(this._texs[x] != null ? !this._texs[x].equals((Object)other._texs[x]) : other._texs[x] != null)) continue;
                    return false;
                }
            } else if (other._texs != null) {
                return false;
            }
        }
        return !this._options.contains((Object)GeometryTool.MatchCondition.Group) || other._smoothGroup == this._smoothGroup;
    }
}

