/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.geom;

import com.ardor3d.scenegraph.Mesh;
import java.util.Map;

public class VertMap {
    private int[] _lookupTable;

    public VertMap(Mesh mesh) {
        this.setupTable(mesh);
    }

    private void setupTable(Mesh mesh) {
        this._lookupTable = new int[mesh.getMeshData().getVertexCount()];
        for (int x = 0; x < this._lookupTable.length; ++x) {
            this._lookupTable[x] = x;
        }
    }

    public int getNewIndex(int oldIndex) {
        return this._lookupTable[oldIndex];
    }

    public int getFirstOldIndex(int newIndex) {
        for (int i = 0; i < this._lookupTable.length; ++i) {
            if (this._lookupTable[i] != newIndex) continue;
            return i;
        }
        return -1;
    }

    public void applyRemapping(Map<Integer, Integer> indexRemap) {
        for (int i = 0; i < this._lookupTable.length; ++i) {
            if (!indexRemap.containsKey(this._lookupTable[i])) continue;
            this._lookupTable[i] = indexRemap.get(this._lookupTable[i]);
        }
    }

    public int[] getLookupTable() {
        return this._lookupTable;
    }
}

