/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.resource;

import com.ardor3d.util.resource.ResourceSource;
import com.ardor3d.util.resource.SimpleResourceLocator;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;

public class MultiFormatResourceLocator
extends SimpleResourceLocator {
    private final String[] _extensions;
    private boolean _trySpecifiedFormatFirst = false;

    public MultiFormatResourceLocator(URI baseDir, String ... extensions) throws URISyntaxException {
        super(baseDir);
        if (extensions == null) {
            throw new NullPointerException("extensions can not be null.");
        }
        this._extensions = extensions;
    }

    public MultiFormatResourceLocator(URL baseDir, String ... extensions) throws URISyntaxException {
        this(baseDir.toURI(), extensions);
    }

    @Override
    public ResourceSource locateResource(String resourceName) {
        ResourceSource src;
        resourceName = this.cleanup(resourceName);
        if (this._trySpecifiedFormatFirst && (src = this.doRecursiveLocate(resourceName)) != null) {
            return src;
        }
        String baseFileName = this.getBaseFileName(resourceName);
        for (String extension : this._extensions) {
            ResourceSource src2 = this.doRecursiveLocate(baseFileName + extension);
            if (src2 == null) continue;
            return src2;
        }
        if (!this._trySpecifiedFormatFirst) {
            return this.doRecursiveLocate(resourceName);
        }
        return null;
    }

    private String getBaseFileName(String resourceName) {
        File f = new File(resourceName);
        String name = f.getPath();
        int dot = name.lastIndexOf(46);
        if (dot < 0) {
            return name;
        }
        return name.substring(0, dot);
    }

    public boolean isTrySpecifiedFormatFirst() {
        return this._trySpecifiedFormatFirst;
    }

    public void setTrySpecifiedFormatFirst(boolean trySpecifiedFormatFirst) {
        this._trySpecifiedFormatFirst = trySpecifiedFormatFirst;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MultiFormatResourceLocator) {
            return this.getBaseDir().equals(((MultiFormatResourceLocator)obj).getBaseDir()) && Arrays.equals(this._extensions, ((MultiFormatResourceLocator)obj)._extensions);
        }
        return super.equals(obj);
    }
}

