/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.resource;

import com.ardor3d.util.resource.ResourceLocator;
import com.ardor3d.util.resource.ResourceSource;

public class RelativeResourceLocator
implements ResourceLocator {
    private final ResourceSource _baseSource;

    public RelativeResourceLocator(ResourceSource resource) {
        assert (resource != null) : "source may not be null.";
        this._baseSource = resource;
    }

    public ResourceSource getBaseSource() {
        return this._baseSource;
    }

    @Override
    public ResourceSource locateResource(String resourceName) {
        while (resourceName.startsWith("./") && resourceName.length() > 2) {
            resourceName = resourceName.substring(2);
        }
        while (resourceName.startsWith(".\\") && resourceName.length() > 2) {
            resourceName = resourceName.substring(2);
        }
        return this._baseSource.getRelativeSource(resourceName);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RelativeResourceLocator) {
            return this._baseSource.equals(((RelativeResourceLocator)obj)._baseSource);
        }
        return false;
    }

    public int hashCode() {
        return this._baseSource.hashCode();
    }
}

