/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.resource;

import com.ardor3d.util.resource.ResourceLocator;
import com.ardor3d.util.resource.ResourceSource;
import com.ardor3d.util.resource.URLResourceSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceLocatorTool {
    private static final Logger logger = Logger.getLogger(ResourceLocatorTool.class.getName());
    public static final String TYPE_TEXTURE = "texture";
    public static final String TYPE_MODEL = "model";
    public static final String TYPE_PARTICLE = "particle";
    public static final String TYPE_AUDIO = "audio";
    public static final String TYPE_SHADER = "shader";
    private static final Map<String, List<ResourceLocator>> _locatorMap = new HashMap<String, List<ResourceLocator>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceSource locateResource(String resourceType, String resourceName) {
        if (resourceName == null) {
            return null;
        }
        try {
            resourceName = URLDecoder.decode(resourceName, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        Map<String, List<ResourceLocator>> map = _locatorMap;
        synchronized (map) {
            List<ResourceLocator> bases = _locatorMap.get(resourceType);
            if (bases != null) {
                int i = bases.size();
                while (--i >= 0) {
                    ResourceLocator loc = bases.get(i);
                    ResourceSource rVal = loc.locateResource(resourceName);
                    if (rVal == null) continue;
                    return rVal;
                }
            }
            try {
                URL u = ResourceLocatorTool.getClassPathResource(ResourceLocatorTool.class, resourceName);
                if (u != null) {
                    return new URLResourceSource(u);
                }
            }
            catch (Exception e) {
                logger.logp(Level.WARNING, ResourceLocatorTool.class.getName(), "locateResource(String, String)", e.getMessage(), e);
            }
            logger.warning("Unable to locate: " + resourceName + " of type " + resourceType);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addResourceLocator(String resourceType, ResourceLocator locator) {
        if (locator == null) {
            return;
        }
        Map<String, List<ResourceLocator>> map = _locatorMap;
        synchronized (map) {
            List<ResourceLocator> bases = _locatorMap.get(resourceType);
            if (bases == null) {
                bases = new ArrayList<ResourceLocator>();
                _locatorMap.put(resourceType, bases);
            }
            if (!bases.contains(locator)) {
                bases.add(locator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeResourceLocator(String resourceType, ResourceLocator locator) {
        Map<String, List<ResourceLocator>> map = _locatorMap;
        synchronized (map) {
            List<ResourceLocator> bases = _locatorMap.get(resourceType);
            if (bases == null) {
                return false;
            }
            return bases.remove(locator);
        }
    }

    public static URL getClassPathResource(Class<?> clazz, String name) {
        URL result = Thread.currentThread().getContextClassLoader().getResource(name);
        if (result == null && !Thread.currentThread().getContextClassLoader().equals(ClassLoader.getSystemClassLoader())) {
            result = ClassLoader.getSystemResource(name);
        }
        if (result == null) {
            result = clazz.getClassLoader().getResource(name);
        }
        return result;
    }

    public static InputStream getClassPathResourceAsStream(Class<?> clazz, String name) {
        InputStream result = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        if (result == null && !Thread.currentThread().getContextClassLoader().equals(ClassLoader.getSystemClassLoader())) {
            result = ClassLoader.getSystemResourceAsStream(name);
        }
        if (result == null) {
            result = clazz.getClassLoader().getResourceAsStream(name);
        }
        return result;
    }

    public static Set<URL> getClassPathResources(Class<?> clazz, String name) {
        HashSet<URL> results = new HashSet<URL>();
        Enumeration<URL> urls = null;
        try {
            urls = Thread.currentThread().getContextClassLoader().getResources(name);
            while (urls.hasMoreElements()) {
                results.add(urls.nextElement());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!Thread.currentThread().getContextClassLoader().equals(ClassLoader.getSystemClassLoader())) {
            try {
                urls = ClassLoader.getSystemResources(name);
                while (urls.hasMoreElements()) {
                    results.add(urls.nextElement());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            urls = clazz.getClassLoader().getResources(name);
            while (urls.hasMoreElements()) {
                results.add(urls.nextElement());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return results;
    }
}

