/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.resource;

import com.ardor3d.util.resource.ResourceLocator;
import com.ardor3d.util.resource.ResourceSource;
import com.ardor3d.util.resource.URLResourceSource;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;

public class SimpleResourceLocator
implements ResourceLocator {
    private final URI _baseDir;

    public SimpleResourceLocator(URI baseDir) throws URISyntaxException {
        if (baseDir == null) {
            throw new NullPointerException("baseDir can not be null.");
        }
        String uri = baseDir.toString();
        this._baseDir = !uri.endsWith("/") ? new URI(baseDir.toString() + "/") : baseDir;
    }

    public SimpleResourceLocator(URL baseDir) throws URISyntaxException {
        this(baseDir.toURI());
    }

    public URI getBaseDir() {
        return this._baseDir;
    }

    @Override
    public ResourceSource locateResource(String resourceName) {
        return this.doRecursiveLocate(this.cleanup(resourceName));
    }

    protected ResourceSource doRecursiveLocate(String resourceName) {
        while (resourceName.startsWith("./") && resourceName.length() > 2) {
            resourceName = resourceName.substring(2);
        }
        while (resourceName.startsWith(".\\") && resourceName.length() > 2) {
            resourceName = resourceName.substring(2);
        }
        try {
            String spec = URLEncoder.encode(resourceName, "UTF-8");
            spec = spec.replaceAll("\\+", "%20");
            URL rVal = new URL(this._baseDir.toURL(), spec);
            rVal.openStream().close();
            return new URLResourceSource(rVal);
        }
        catch (IOException iOException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        resourceName = this.trimResourceName(resourceName);
        if (resourceName == null) {
            return null;
        }
        return this.doRecursiveLocate(resourceName);
    }

    protected String trimResourceName(String resourceName) {
        int firstSlashIndex = (resourceName = this.cleanup(resourceName)).indexOf(47);
        if (firstSlashIndex >= 0 && firstSlashIndex < resourceName.length() - 1) {
            return resourceName.substring(firstSlashIndex + 1);
        }
        return null;
    }

    protected String cleanup(String name) {
        name = name.replaceAll("\\%2[F,f]", "/");
        name = name.replace('\\', '/');
        return name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleResourceLocator) {
            return this._baseDir.equals(((SimpleResourceLocator)obj)._baseDir);
        }
        return false;
    }

    public int hashCode() {
        return this._baseDir.hashCode();
    }
}

