/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.resource;

import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.resource.ResourceSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StringResourceSource
implements ResourceSource {
    private static final Logger logger = Logger.getLogger(StringResourceSource.class.getName());
    private String _data;
    private String _type;

    public StringResourceSource(String data) {
        this(data, null);
    }

    public StringResourceSource(String data, String type) {
        this._data = data;
        this._type = type;
    }

    @Override
    public String getName() {
        return "string resource";
    }

    @Override
    public ResourceSource getRelativeSource(String name) {
        if (logger.isLoggable(Level.WARNING)) {
            logger.logp(Level.WARNING, this.getClass().getName(), "getRelativeSource(String)", "StringResourceSource does not support this method.");
        }
        return null;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public InputStream openStream() throws IOException {
        return new ByteArrayInputStream(this._data.getBytes("UTF8"));
    }

    public Class<?> getClassTag() {
        return StringResourceSource.class;
    }

    public void read(InputCapsule capsule) throws IOException {
        this._data = capsule.readString("data", null);
        this._type = capsule.readString("type", null);
    }

    public void write(OutputCapsule capsule) throws IOException {
        capsule.write(this._data, "data", null);
        capsule.write(this._type, "type", null);
    }
}

