/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.resource;

import com.ardor3d.util.UrlUtils;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.resource.ResourceLocatorTool;
import com.ardor3d.util.resource.ResourceSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class URLResourceSource
implements ResourceSource {
    private static final Logger logger = Logger.getLogger(URLResourceSource.class.getName());
    private URL _url;
    private String _type;
    private transient String _urlToString = null;

    public URLResourceSource() {
    }

    public URLResourceSource(URL sourceUrl) {
        assert (sourceUrl != null) : "sourceUrl must not be null";
        this.setURL(sourceUrl);
        String fileName = this._url.getFile();
        if (fileName != null) {
            int dot = fileName.lastIndexOf(46);
            this._type = dot >= 0 ? fileName.substring(dot) : "-unknown-";
        }
    }

    public URLResourceSource(URL sourceUrl, String type) {
        assert (sourceUrl != null) : "sourceUrl must not be null";
        this.setURL(sourceUrl);
        this._type = type;
    }

    @Override
    public ResourceSource getRelativeSource(String name) {
        try {
            URL srcURL = UrlUtils.resolveRelativeURL(this._url, "./" + name);
            if (srcURL != null) {
                srcURL.openStream().close();
                return new URLResourceSource(srcURL);
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, this.getClass().getName(), "getRelativeSource(String)", "Unable to find relative file {0} from {1}.", new Object[]{name, this._url});
        }
        return null;
    }

    public void setURL(URL url) {
        this._url = url;
        this._urlToString = url != null ? url.toString() : null;
    }

    public URL getURL() {
        return this._url;
    }

    @Override
    public String getName() {
        return this._urlToString;
    }

    @Override
    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    @Override
    public InputStream openStream() throws IOException {
        return this._url.openStream();
    }

    public String toString() {
        return "URLResourceSource [url=" + this._urlToString + ", type=" + this._type + "]";
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof URLResourceSource)) {
            return false;
        }
        URLResourceSource other = (URLResourceSource)obj;
        if (this._type == null ? other._type != null : !this._type.equals(other._type)) {
            return false;
        }
        return !(this._url == null ? other._url != null : !this._urlToString.equals(other._urlToString));
    }

    public Class<?> getClassTag() {
        return URLResourceSource.class;
    }

    public void read(InputCapsule capsule) throws IOException {
        ResourceSource src;
        String protocol = capsule.readString("protocol", null);
        String host = capsule.readString("host", null);
        String file = capsule.readString("file", null);
        if (file != null && (src = ResourceLocatorTool.locateResource("texture", URLDecoder.decode(file, "UTF-8"))) instanceof URLResourceSource) {
            this.setURL(((URLResourceSource)src)._url);
            this._type = ((URLResourceSource)src)._type;
            return;
        }
        if (protocol != null && host != null && file != null) {
            this.setURL(new URL(protocol, host, file));
        }
        this._type = capsule.readString("type", null);
    }

    public void write(OutputCapsule capsule) throws IOException {
        capsule.write(this._url.getProtocol(), "protocol", null);
        capsule.write(this._url.getHost(), "host", null);
        capsule.write(this._url.getFile(), "file", null);
        capsule.write(this._type, "type", null);
    }
}

