/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.scenegraph;

import com.ardor3d.renderer.ContextCleanListener;
import com.ardor3d.renderer.ContextManager;
import com.ardor3d.renderer.RenderContext;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.RendererCallable;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.util.GameTaskQueueManager;
import com.ardor3d.util.SimpleContextIdReference;
import com.ardor3d.util.scenegraph.RenderDelegate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.WeakHashMap;

public class DisplayListDelegate
implements RenderDelegate {
    private static Map<DisplayListDelegate, Object> _identityCache = new WeakHashMap<DisplayListDelegate, Object>();
    private static final Object STATIC_REF = new Object();
    private static ReferenceQueue<DisplayListDelegate> _refQueue = new ReferenceQueue();
    private final SimpleContextIdReference<DisplayListDelegate> _id;

    public DisplayListDelegate(int id, Object glContext) {
        this._id = new SimpleContextIdReference<DisplayListDelegate>(this, _refQueue, id, glContext);
        _identityCache.put(this, STATIC_REF);
    }

    @Override
    public void render(Spatial spatial, Renderer renderer) {
        boolean transformed = renderer.doTransforms(spatial.getWorldTransform());
        renderer.renderDisplayList(this._id.getId());
        ContextManager.getCurrentContext().invalidateStates();
        if (transformed) {
            renderer.undoTransforms(spatial.getWorldTransform());
        }
    }

    public static void cleanAllDisplayLists(Renderer deleter) {
        ArrayListMultimap idMap = ArrayListMultimap.create();
        DisplayListDelegate.gatherGCdIds((Multimap<Object, Integer>)idMap);
        for (DisplayListDelegate buf : _identityCache.keySet()) {
            idMap.put(buf._id.getGlContext(), (Object)buf._id.getId());
        }
        DisplayListDelegate.handleDisplayListDelete(deleter, (Multimap<Object, Integer>)idMap);
    }

    public static void cleanExpiredDisplayLists(Renderer deleter) {
        Multimap<Object, Integer> idMap = DisplayListDelegate.gatherGCdIds(null);
        if (idMap != null) {
            DisplayListDelegate.handleDisplayListDelete(deleter, idMap);
        }
    }

    private static Multimap<Object, Integer> gatherGCdIds(Multimap<Object, Integer> store) {
        SimpleContextIdReference ref;
        while ((ref = (SimpleContextIdReference)_refQueue.poll()) != null) {
            if (store == null) {
                store = ArrayListMultimap.create();
            }
            store.put(ref.getGlContext(), (Object)ref.getId());
            ref.clear();
        }
        return store;
    }

    private static void handleDisplayListDelete(Renderer deleter, final Multimap<Object, Integer> idMap) {
        Object currentGLRef = null;
        if (deleter != null && ContextManager.getCurrentContext() != null) {
            currentGLRef = ContextManager.getCurrentContext().getGlContextRep();
        }
        for (final Object glref : idMap.keySet()) {
            if (deleter != null && glref.equals(currentGLRef)) {
                deleter.deleteDisplayLists(idMap.get(glref));
                continue;
            }
            GameTaskQueueManager.getManager(ContextManager.getContextForRef(glref)).render(new RendererCallable<Void>(){

                @Override
                public Void call() throws Exception {
                    this.getRenderer().deleteDisplayLists(idMap.get(glref));
                    return null;
                }
            });
        }
    }

    static {
        ContextManager.addContextCleanListener(new ContextCleanListener(){

            @Override
            public void cleanForContext(RenderContext renderContext) {
            }
        });
    }
}

