/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.scenegraph;

import com.ardor3d.bounding.BoundingVolume;
import com.ardor3d.renderer.Camera;
import com.ardor3d.renderer.ContextManager;
import com.ardor3d.renderer.RenderContext;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.TextureState;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.visitor.Visitor;
import com.ardor3d.util.scenegraph.CompileOptions;
import com.ardor3d.util.scenegraph.DisplayListDelegate;

public class SceneCompiler {
    public static void compile(Spatial scene, Renderer renderer, CompileOptions options) {
        if (options.isDisplayList()) {
            RenderContext context = ContextManager.getCurrentContext();
            Camera originalCam = context.getCurrentCamera();
            Camera yesCam = new Camera(originalCam){

                @Override
                public Camera.FrustumIntersect contains(BoundingVolume bound) {
                    return Camera.FrustumIntersect.Inside;
                }
            };
            context.setCurrentCamera(yesCam);
            scene.acceptVisitor(new TextureApplyVisitor(renderer), true);
            context.invalidateStates();
            int id = renderer.startDisplayList();
            renderer.getQueue().pushBuckets();
            scene.draw(renderer);
            renderer.renderBuckets();
            renderer.getQueue().popBuckets();
            renderer.endDisplayList();
            context.setCurrentCamera(originalCam);
            scene.setRenderDelegate(new DisplayListDelegate(id, context.getGlContextRep()), context.getGlContextRep());
        }
    }

    static class TextureApplyVisitor
    implements Visitor {
        private final Renderer _renderer;

        public TextureApplyVisitor(Renderer renderer) {
            this._renderer = renderer;
        }

        @Override
        public void visit(Spatial spatial) {
            Mesh mesh;
            TextureState state;
            if (spatial instanceof Mesh && (state = (TextureState)(mesh = (Mesh)spatial).getWorldRenderState(RenderState.StateType.Texture)) != null) {
                this._renderer.applyState(state.getType(), state);
            }
        }
    }
}

