/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.screen;

import com.ardor3d.image.ImageDataFormat;
import com.ardor3d.image.PixelDataType;
import com.ardor3d.renderer.Camera;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.util.geom.BufferUtils;
import com.ardor3d.util.screen.ScreenExportable;
import java.nio.ByteBuffer;

public class ScreenExporter {
    static ByteBuffer _scratch = BufferUtils.createByteBuffer(1);

    public static synchronized void exportCurrentScreen(Renderer renderer, ScreenExportable exportable) {
        ImageDataFormat format = exportable.getFormat();
        Camera camera = Camera.getCurrentCamera();
        int width = camera.getWidth();
        int height = camera.getHeight();
        int size = renderer.getExpectedBufferSizeToGrabScreenContents(format, PixelDataType.UnsignedByte, width, height);
        if (_scratch.capacity() < size) {
            _scratch = BufferUtils.createByteBuffer(size);
        } else {
            _scratch.limit(size);
            _scratch.rewind();
        }
        renderer.grabScreenContents(_scratch, format, 0, 0, width, height);
        exportable.export(_scratch, width, height);
    }
}

