/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.stat;

import com.ardor3d.util.stat.StatType;
import com.ardor3d.util.stat.StatValue;
import java.util.HashMap;
import java.util.Set;

public class MultiStatSample {
    private final HashMap<StatType, StatValue> _values = new HashMap();
    private double _elapsedTime = 0.0;

    public static MultiStatSample createNew(HashMap<StatType, StatValue> current) {
        MultiStatSample rVal = new MultiStatSample();
        for (StatType type : current.keySet()) {
            StatValue entry = current.get(type);
            if (entry.getIterations() <= 0L) continue;
            StatValue store = new StatValue(entry);
            rVal._values.put(type, store);
        }
        return rVal;
    }

    public void setTimeElapsed(double time) {
        this._elapsedTime = time;
    }

    public boolean containsStat(StatType type) {
        return this._values.containsKey(type);
    }

    public StatValue getStatValue(StatType type) {
        return this._values.get(type);
    }

    public Set<StatType> getStatTypes() {
        return this._values.keySet();
    }

    public double getElapsedTime() {
        return this._elapsedTime;
    }
}

