/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.stat;

import com.ardor3d.util.Timer;
import com.ardor3d.util.stat.MultiStatSample;
import com.ardor3d.util.stat.StatListener;
import com.ardor3d.util.stat.StatType;
import com.ardor3d.util.stat.StatValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;

public abstract class StatCollector {
    private static final Logger logger = Logger.getLogger(StatCollector.class.getName());
    protected static int maxSamples = 100;
    protected static HashMap<StatType, StatValue> current = new HashMap();
    protected static List<MultiStatSample> historical = Collections.synchronizedList(new LinkedList());
    protected static double sampleRateMS = 1000.0;
    protected static double lastSampleTime = 0.0;
    protected static double lastTimeCheckMS = 0.0;
    protected static List<StatListener> listeners = new ArrayList<StatListener>();
    protected static double startOffset = 0.0;
    protected static boolean ignoreStats = false;
    protected static Stack<StatType> timeStatStack = new Stack();
    protected static HashSet<StatType> timedStats = new HashSet();
    protected static Timer timer = new Timer();
    protected static final double TO_MS = 1000.0 / (double)timer.getResolution();
    protected static long pausedTime;
    protected static long pausedStartTime;

    public static void init(long sampleRateMS, int maxHistorical) {
        StatCollector.sampleRateMS = sampleRateMS;
        maxSamples = maxHistorical;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStat(StatType type, double statValue) {
        if (ignoreStats) {
            return;
        }
        HashMap<StatType, StatValue> hashMap = current;
        synchronized (hashMap) {
            StatValue val = current.get(type);
            if (val == null) {
                val = new StatValue();
                current.put(type, val);
            }
            val.incrementValue(statValue);
            val.incrementIterations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startStat(StatType type) {
        if (ignoreStats || !timedStats.contains(type)) {
            return;
        }
        HashMap<StatType, StatValue> hashMap = current;
        synchronized (hashMap) {
            StatValue val;
            StatType top = !timeStatStack.isEmpty() ? timeStatStack.peek() : null;
            double timeMS = (double)timer.getTime() * TO_MS;
            if (top != null) {
                val = current.get(top);
                val.incrementValue(timeMS - lastTimeCheckMS);
            } else {
                val = current.get(StatType.STAT_UNSPECIFIED_TIMER);
                if (val == null) {
                    val = new StatValue();
                    val.setIterations(1L);
                    current.put(StatType.STAT_UNSPECIFIED_TIMER, val);
                }
                val.incrementValue(timeMS - lastTimeCheckMS);
            }
            lastTimeCheckMS = timeMS;
            timeStatStack.push(type);
            if (type != null) {
                val = current.get(type);
                if (val == null) {
                    val = new StatValue();
                    current.put(type, val);
                }
                val.incrementIterations();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endStat(StatType type) {
        if (ignoreStats || !timedStats.contains(type)) {
            return;
        }
        HashMap<StatType, StatValue> hashMap = current;
        synchronized (hashMap) {
            StatType top = timeStatStack.pop();
            double timeMS = (double)timer.getTime() * TO_MS;
            StatValue val = current.get(top);
            val.incrementValue(timeMS - lastTimeCheckMS);
            lastTimeCheckMS = timeMS;
            while (!top.equals(type)) {
                logger.warning("Mismatched endStat, found " + top + ".  Expected '" + type + "'");
                top = timeStatStack.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void update() {
        double timeMS = (double)timer.getTime() * TO_MS;
        double elapsed = timeMS - lastSampleTime;
        if (elapsed < sampleRateMS) {
            return;
        }
        HashMap<StatType, StatValue> hashMap = current;
        synchronized (hashMap) {
            StatValue val;
            if (!timeStatStack.isEmpty()) {
                val = current.get(timeStatStack.peek());
                val.incrementValue(timeMS - lastTimeCheckMS - (double)pausedTime * TO_MS);
                lastTimeCheckMS = timeMS;
                int x = timeStatStack.size();
                while (--x >= 0) {
                    StatValue val2 = current.get(timeStatStack.get(x));
                    if (val2 == null) continue;
                    val2.setIterations(0L);
                }
                val.setIterations(1L);
            } else {
                val = current.get(StatType.STAT_UNSPECIFIED_TIMER);
                if (val != null) {
                    val.incrementValue(timeMS - lastTimeCheckMS - (double)pausedTime * TO_MS);
                    lastTimeCheckMS = timeMS;
                    val.setIterations(1L);
                }
            }
            MultiStatSample sample = MultiStatSample.createNew(current);
            sample.setTimeElapsed(elapsed);
            historical.add(sample);
            for (StatValue value : current.values()) {
                value.reset();
            }
        }
        startOffset = 0.0;
        pausedTime = 0L;
        while (historical.size() > maxSamples) {
            MultiStatSample removed = historical.remove(0);
            if (removed == null) continue;
            startOffset += removed.getElapsedTime();
        }
        lastSampleTime = timeMS;
        StatCollector.fireActionEvent();
    }

    public static void addStatListener(StatListener listener) {
        listeners.add(listener);
    }

    public static boolean removeStatListener(StatListener listener) {
        return listeners.remove(listener);
    }

    public static void removeAllListeners() {
        listeners.clear();
    }

    public static void addTimedStat(StatType type) {
        timedStats.add(type);
    }

    public static boolean removeTimedStat(StatType type) {
        return timedStats.remove(type);
    }

    public static void removeAllTimedStats() {
        timedStats.clear();
    }

    public static void fireActionEvent() {
        for (StatListener l : listeners) {
            l.statsUpdated();
        }
    }

    public static double getStartOffset() {
        return startOffset;
    }

    public static double getSampleRate() {
        return sampleRateMS;
    }

    public static void setSampleRate(long sampleRateMS) {
        StatCollector.sampleRateMS = sampleRateMS;
    }

    public static void setMaxSamples(int samples) {
        maxSamples = samples;
    }

    public static int getMaxSamples() {
        return maxSamples;
    }

    public static List<MultiStatSample> getHistorical() {
        return historical;
    }

    public static MultiStatSample lastStats() {
        if (historical.size() == 0) {
            return null;
        }
        return historical.get(historical.size() - 1);
    }

    public static boolean isIgnoreStats() {
        return ignoreStats;
    }

    public static void setIgnoreStats(boolean ignoreStats) {
        StatCollector.ignoreStats = ignoreStats;
    }

    public static boolean hasHistoricalStat(StatType type) {
        for (MultiStatSample mss : historical) {
            if (!mss.containsStat(type)) continue;
            return true;
        }
        return false;
    }

    public static void resetTimedStack() {
        timeStatStack.clear();
    }

    public static void pause() {
        StatCollector.setIgnoreStats(true);
        pausedStartTime = timer.getTime();
    }

    public static void resume() {
        StatCollector.setIgnoreStats(false);
        pausedTime += timer.getTime() - pausedStartTime;
    }
}

