/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.stat;

public class StatValue {
    private double _accumulatedValue = 0.0;
    private double _averageValue = 0.0;
    private long _iterations;
    private boolean _averageDirty = true;

    public StatValue() {
    }

    public StatValue(StatValue entry) {
        this._accumulatedValue = entry._accumulatedValue;
        this._averageValue = entry._averageValue;
        this._averageDirty = entry._averageDirty;
        this._iterations = entry._iterations;
    }

    public double getAccumulatedValue() {
        return this._accumulatedValue;
    }

    public long getIterations() {
        return this._iterations;
    }

    public double getAverageValue() {
        if (this._averageDirty) {
            this._averageValue = this._iterations > 0L ? this._accumulatedValue / (double)this._iterations : this._accumulatedValue;
            this._averageDirty = false;
        }
        return this._averageValue;
    }

    public void incrementValue(double statValue) {
        this._accumulatedValue += statValue;
        this._averageDirty = true;
    }

    public void incrementIterations() {
        ++this._iterations;
        this._averageDirty = true;
    }

    public void setIterations(long iterations) {
        this._iterations = iterations;
        this._averageDirty = true;
    }

    public void reset() {
        this._accumulatedValue = 0.0;
        this._iterations = 0L;
        this._averageValue = 0.0;
        this._averageDirty = false;
    }
}

