/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.stat.graph;

import com.ardor3d.image.Texture2D;
import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.TextureRenderer;
import com.ardor3d.renderer.TextureRendererFactory;
import com.ardor3d.util.stat.StatListener;
import com.ardor3d.util.stat.StatType;
import java.util.HashMap;
import java.util.TreeMap;

public abstract class AbstractStatGrapher
implements StatListener {
    protected TextureRenderer _textureRenderer;
    protected Texture2D _texture;
    protected int _gWidth;
    protected int _gHeight;
    protected TreeMap<StatType, HashMap<String, Object>> _config = new TreeMap();
    protected boolean _enabled = true;

    public AbstractStatGrapher(int width, int height, Renderer renderer, ContextCapabilities caps) {
        this._gWidth = width;
        this._gHeight = height;
        this._textureRenderer = TextureRendererFactory.INSTANCE.createTextureRenderer(width, height, renderer, caps);
        if (this._textureRenderer != null) {
            this._textureRenderer.setBackgroundColor((ReadOnlyColorRGBA)new ColorRGBA(ColorRGBA.BLACK));
        }
    }

    public void setTexture(Texture2D tex) {
        this._textureRenderer.setupTexture(tex);
        this._texture = tex;
    }

    public TextureRenderer getTextureRenderer() {
        return this._textureRenderer;
    }

    public void clearConfig() {
        this._config.clear();
    }

    public void clearConfig(StatType type) {
        if (this._config.get(type) != null) {
            this._config.get(type).clear();
        }
    }

    public void clearConfig(StatType type, String key) {
        if (this._config.get(type) != null) {
            this._config.get(type).remove(key);
        }
    }

    public void addConfig(StatType type, HashMap<String, Object> configs) {
        this._config.put(type, configs);
    }

    public void addConfig(StatType type, String key, Object value) {
        HashMap<String, Object> vals = this._config.get(type);
        if (vals == null) {
            vals = new HashMap();
            this._config.put(type, vals);
        }
        vals.put(key, value);
    }

    protected ColorRGBA getColorConfig(StatType type, String configName, ColorRGBA defaultVal) {
        Object val;
        HashMap<String, Object> vals = this._config.get(type);
        if (vals != null && vals.containsKey(configName) && (val = vals.get(configName)) instanceof ColorRGBA) {
            return (ColorRGBA)val;
        }
        return defaultVal;
    }

    protected String getStringConfig(StatType type, String configName, String defaultVal) {
        Object val;
        HashMap<String, Object> vals = this._config.get(type);
        if (vals != null && vals.containsKey(configName) && (val = vals.get(configName)) instanceof String) {
            return (String)val;
        }
        return defaultVal;
    }

    protected short getShortConfig(StatType type, String configName, short defaultVal) {
        Object val;
        HashMap<String, Object> vals = this._config.get(type);
        if (vals != null && vals.containsKey(configName) && (val = vals.get(configName)) instanceof Number) {
            return ((Number)val).shortValue();
        }
        return defaultVal;
    }

    protected int getIntConfig(StatType type, String configName, int defaultVal) {
        Object val;
        HashMap<String, Object> vals = this._config.get(type);
        if (vals != null && vals.containsKey(configName) && (val = vals.get(configName)) instanceof Number) {
            return ((Number)val).intValue();
        }
        return defaultVal;
    }

    protected long getLongConfig(StatType type, String configName, long defaultVal) {
        Object val;
        HashMap<String, Object> vals = this._config.get(type);
        if (vals != null && vals.containsKey(configName) && (val = vals.get(configName)) instanceof Number) {
            return ((Number)val).longValue();
        }
        return defaultVal;
    }

    protected float getFloatConfig(StatType type, String configName, float defaultVal) {
        Object val;
        HashMap<String, Object> vals = this._config.get(type);
        if (vals != null && vals.containsKey(configName) && (val = vals.get(configName)) instanceof Number) {
            return ((Number)val).floatValue();
        }
        return defaultVal;
    }

    protected double getDoubleConfig(StatType type, String configName, double defaultVal) {
        Object val;
        HashMap<String, Object> vals = this._config.get(type);
        if (vals != null && vals.containsKey(configName) && (val = vals.get(configName)) instanceof Number) {
            return ((Number)val).doubleValue();
        }
        return defaultVal;
    }

    protected boolean getBooleanConfig(StatType type, String configName, boolean defaultVal) {
        Object val;
        HashMap<String, Object> vals = this._config.get(type);
        if (vals != null && vals.containsKey(configName) && (val = vals.get(configName)) instanceof Boolean) {
            return (Boolean)val;
        }
        return defaultVal;
    }

    public boolean hasConfig(StatType type) {
        return this._config.containsKey(type) && !this._config.get(type).isEmpty();
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public abstract void reset();
}

