/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.stat.graph;

import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.controller.SpatialController;
import com.ardor3d.scenegraph.hint.CullHint;

public class DefColorFadeController
implements SpatialController<Spatial> {
    private Mesh _target;
    private final float _targetAlpha;
    private final double _rate;
    private final boolean _dir;

    public DefColorFadeController(Mesh target, float targetAlpha, double rate) {
        this._target = target;
        this._targetAlpha = targetAlpha;
        boolean bl = this._dir = target.getDefaultColor().getAlpha() > targetAlpha;
        if (this._dir && rate > 0.0 || !this._dir && rate < 0.0) {
            rate *= -1.0;
        }
        this._rate = rate;
    }

    @Override
    public void update(double time, Spatial caller) {
        if (this._target == null) {
            return;
        }
        ColorRGBA color = ColorRGBA.fetchTempInstance().set(this._target.getDefaultColor());
        float alpha = color.getAlpha();
        alpha = (float)((double)alpha + this._rate * time);
        if (this._dir && alpha <= this._targetAlpha) {
            alpha = this._targetAlpha;
        } else if (!this._dir && alpha >= this._targetAlpha) {
            alpha = this._targetAlpha;
        }
        if (alpha != 0.0f) {
            this._target.getSceneHints().setCullHint(CullHint.Inherit);
        } else {
            this._target.getSceneHints().setCullHint(CullHint.Always);
        }
        color.setAlpha(alpha);
        this._target.setDefaultColor((ReadOnlyColorRGBA)color);
        ColorRGBA.releaseTempInstance((ColorRGBA)color);
        if (alpha == this._targetAlpha) {
            this._target.removeController(this);
            this._target = null;
        }
    }
}

