/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.stat.graph;

import com.ardor3d.image.Texture;
import com.ardor3d.image.Texture2D;
import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.queue.RenderBucketType;
import com.ardor3d.renderer.state.BlendState;
import com.ardor3d.renderer.state.TextureState;
import com.ardor3d.scenegraph.hint.LightCombineMode;
import com.ardor3d.scenegraph.hint.TextureCombineMode;
import com.ardor3d.scenegraph.shape.Quad;
import com.ardor3d.util.stat.StatCollector;
import com.ardor3d.util.stat.graph.AbstractStatGrapher;
import com.ardor3d.util.stat.graph.LineGrapher;
import com.ardor3d.util.stat.graph.TabledLabelGrapher;
import com.ardor3d.util.stat.graph.TimedAreaGrapher;
import java.nio.FloatBuffer;

public abstract class GraphFactory {
    public static LineGrapher makeLineGraph(int width, int height, Quad quad, Renderer renderer, ContextCapabilities caps) {
        LineGrapher grapher = new LineGrapher(width, height, renderer, caps);
        grapher.setThreshold(1);
        StatCollector.addStatListener(grapher);
        Texture2D graphTex = GraphFactory.setupGraphTexture(grapher);
        float dW = (float)width / (float)grapher._textureRenderer.getWidth();
        float dH = (float)height / (float)grapher._textureRenderer.getHeight();
        GraphFactory.setupGraphQuad(quad, graphTex, dW, dH);
        return grapher;
    }

    public static TimedAreaGrapher makeTimedGraph(int width, int height, Quad quad, Renderer renderer, ContextCapabilities caps) {
        TimedAreaGrapher grapher = new TimedAreaGrapher(width, height, renderer, caps);
        grapher.setThreshold(1);
        StatCollector.addStatListener(grapher);
        Texture2D graphTex = GraphFactory.setupGraphTexture(grapher);
        float dW = (float)width / (float)grapher._textureRenderer.getWidth();
        float dH = (float)height / (float)grapher._textureRenderer.getHeight();
        GraphFactory.setupGraphQuad(quad, graphTex, dW, dH);
        return grapher;
    }

    public static TabledLabelGrapher makeTabledLabelGraph(int width, int height, Quad quad, Renderer renderer, ContextCapabilities caps) {
        TabledLabelGrapher grapher = new TabledLabelGrapher(width, height, renderer, caps);
        grapher.setThreshold(1);
        StatCollector.addStatListener(grapher);
        Texture2D graphTex = GraphFactory.setupGraphTexture(grapher);
        float dW = (float)width / (float)grapher._textureRenderer.getWidth();
        float dH = (float)height / (float)grapher._textureRenderer.getHeight();
        GraphFactory.setupGraphQuad(quad, graphTex, dW, dH);
        return grapher;
    }

    private static Texture2D setupGraphTexture(AbstractStatGrapher grapher) {
        Texture2D graphTex = new Texture2D();
        graphTex.setMinificationFilter(Texture.MinificationFilter.NearestNeighborNoMipMaps);
        graphTex.setMagnificationFilter(Texture.MagnificationFilter.Bilinear);
        grapher.setTexture(graphTex);
        return graphTex;
    }

    private static void setupGraphQuad(Quad quad, Texture2D graphTexture, float maxU, float maxV) {
        quad.getSceneHints().setTextureCombineMode(TextureCombineMode.Replace);
        quad.getSceneHints().setLightCombineMode(LightCombineMode.Off);
        quad.getSceneHints().setRenderBucketType(RenderBucketType.Ortho);
        quad.getSceneHints().setOrthoOrder(-1);
        FloatBuffer tbuf = (FloatBuffer)quad.getMeshData().getTextureCoords(0).getBuffer();
        tbuf.clear();
        tbuf.put(0.0f).put(0.0f);
        tbuf.put(0.0f).put(maxV);
        tbuf.put(maxU).put(maxV);
        tbuf.put(maxU).put(0.0f);
        tbuf.rewind();
        TextureState texState = new TextureState();
        texState.setTexture(graphTexture);
        quad.setRenderState(texState);
        BlendState blend = new BlendState();
        blend.setBlendEnabled(true);
        blend.setSourceFunction(BlendState.SourceFunction.SourceAlpha);
        blend.setDestinationFunction(BlendState.DestinationFunction.OneMinusSourceAlpha);
        quad.setRenderState(blend);
    }
}

