/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.stat.graph;

import com.ardor3d.image.Texture;
import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.IndexMode;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.queue.RenderBucketType;
import com.ardor3d.renderer.state.BlendState;
import com.ardor3d.scenegraph.Line;
import com.ardor3d.scenegraph.Node;
import com.ardor3d.scenegraph.Point;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.hint.CullHint;
import com.ardor3d.util.Constants;
import com.ardor3d.util.geom.BufferUtils;
import com.ardor3d.util.stat.MultiStatSample;
import com.ardor3d.util.stat.StatCollector;
import com.ardor3d.util.stat.StatType;
import com.ardor3d.util.stat.graph.AbstractStatGrapher;
import com.ardor3d.util.stat.graph.TableLinkable;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class LineGrapher
extends AbstractStatGrapher
implements TableLinkable {
    public static final StatType Vertical = new StatType("_lineGrapher_vert");
    public static final StatType Horizontal = new StatType("_lineGrapher_horiz");
    protected Node _graphRoot = new Node("root");
    protected Line _horizontals;
    protected Line _verticals;
    protected int _eventCount = 0;
    protected int _threshold = 1;
    protected float _startMarker = 0.0f;
    private float _off;
    private float _vSpan;
    private static final int majorHBar = 20;
    private static final int majorVBar = 10;
    private final HashMap<StatType, LineEntry> _entries = new HashMap();
    private BlendState _defBlendState = null;

    public LineGrapher(int width, int height, Renderer renderer, ContextCapabilities caps) {
        super(width, height, renderer, caps);
        this.createHLines();
        this._defBlendState = new BlendState();
        this._defBlendState.setEnabled(true);
        this._defBlendState.setBlendEnabled(true);
        this._defBlendState.setSourceFunction(BlendState.SourceFunction.SourceAlpha);
        this._defBlendState.setDestinationFunction(BlendState.DestinationFunction.OneMinusSourceAlpha);
        this._graphRoot.setRenderState(this._defBlendState);
        this._graphRoot.getSceneHints().setCullHint(CullHint.Never);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statsUpdated() {
        if (!this.isEnabled() || !Constants.updateGraphs) {
            return;
        }
        StatCollector.pause();
        int texWidth = this._gWidth;
        int texHeight = this._gHeight;
        ++this._eventCount;
        this._off = (float)((double)this._off + StatCollector.getStartOffset());
        if (this._eventCount < this._threshold) {
            return;
        }
        this._eventCount = 0;
        if (!this._graphRoot.equals(this._horizontals.getParent())) {
            this._graphRoot.attachChild(this._horizontals);
        }
        float newVSpan = this.calcVSpan();
        if (this._verticals == null || newVSpan != this._vSpan) {
            this._vSpan = newVSpan;
            this.createVLines();
        }
        this._off = (float)((double)this._off % (StatCollector.getSampleRate() * 10.0));
        if (!this._graphRoot.equals(this._verticals.getParent())) {
            this._graphRoot.attachChild(this._verticals);
        }
        this.shiftVerticals();
        for (StatType type : this._entries.keySet()) {
            this._entries.get((Object)type).visited = false;
            this._entries.get((Object)type).verts.clear();
        }
        List<MultiStatSample> list = StatCollector.getHistorical();
        synchronized (list) {
            for (int i = 0; i < StatCollector.getHistorical().size(); ++i) {
                MultiStatSample sample = StatCollector.getHistorical().get(i);
                for (StatType type : this._config.keySet()) {
                    LineEntry entry;
                    if (sample.containsStat(type)) {
                        entry = this._entries.get(type);
                        if (entry == null || entry.maxSamples != StatCollector.getMaxSamples()) {
                            entry = new LineEntry(StatCollector.getMaxSamples(), type);
                            this._entries.put(type, entry);
                        }
                        double value = this.getBooleanConfig(type, ConfigKeys.FrameAverage.name(), false) ? sample.getStatValue(type).getAverageValue() : sample.getStatValue(type).getAccumulatedValue();
                        Vector3 point = new Vector3((double)i, value, 0.0);
                        entry.verts.add(point);
                        if (entry.max < value) {
                            entry.max = value;
                        }
                        entry.visited = true;
                        continue;
                    }
                    entry = this._entries.get(type);
                    if (entry == null) continue;
                    entry.verts.add(new Vector3((double)i, 0.0, 0.0));
                }
            }
        }
        Iterator<StatType> i = this._entries.keySet().iterator();
        while (i.hasNext()) {
            LineEntry entry = this._entries.get(i.next());
            if (!entry.visited) {
                entry.line.removeFromParent();
                entry.point.removeFromParent();
                i.remove();
                continue;
            }
            FloatBuffer fb = BufferUtils.createFloatBuffer((ReadOnlyVector3[])entry.verts.toArray(new Vector3[entry.verts.size()]));
            entry.point.getMeshData().setVertexBuffer(fb);
            double scaleWidth = (double)texWidth / ((double)StatCollector.getMaxSamples() - 1.0);
            double scaleHeight = (double)texHeight / (entry.max * 1.02);
            entry.point.setScale((ReadOnlyVector3)new Vector3(scaleWidth, scaleHeight, 1.0));
            entry.line.getMeshData().setVertexBuffer(fb);
            entry.line.setScale((ReadOnlyVector3)new Vector3(scaleWidth, scaleHeight, 1.0));
            fb.rewind();
            if (!this._graphRoot.equals(entry.line.getParent())) {
                this._graphRoot.attachChild(entry.line);
            }
            if (this._graphRoot.equals(entry.point.getParent())) continue;
            this._graphRoot.attachChild(entry.point);
        }
        this._graphRoot.updateGeometricState(0.0, true);
        this._textureRenderer.render((Spatial)this._graphRoot, (Texture)this._texture, 3);
        StatCollector.resume();
    }

    private float calcVSpan() {
        return this._textureRenderer.getWidth() * 10 / StatCollector.getMaxSamples();
    }

    private void shiftVerticals() {
        int texWidth = this._textureRenderer.getWidth();
        double xOffset = (double)(-(this._off * (float)texWidth)) / ((double)StatCollector.getMaxSamples() * StatCollector.getSampleRate());
        ReadOnlyVector3 trans = this._verticals.getTranslation();
        this._verticals.setTranslation(xOffset, trans.getY(), trans.getZ());
    }

    public int getThreshold() {
        return this._threshold;
    }

    public void setThreshold(int threshold) {
        this._threshold = threshold;
    }

    private void createHLines() {
        int texWidth = this._textureRenderer.getWidth();
        int texHeight = this._textureRenderer.getHeight();
        FloatBuffer verts = BufferUtils.createVector3Buffer(10);
        float div = (float)(texHeight * 20) / 100.0f;
        int y = 0;
        for (int i = 0; i < verts.capacity(); i += 6) {
            verts.put(0.0f).put(y).put(0.0f);
            verts.put(texWidth).put(y).put(0.0f);
            y = (int)((float)y + div);
        }
        this._horizontals = new Line("horiz", verts, null, null, null);
        this._horizontals.getMeshData().setIndexMode(IndexMode.Lines);
        this._horizontals.getSceneHints().setRenderBucketType(RenderBucketType.Ortho);
        this._horizontals.setDefaultColor((ReadOnlyColorRGBA)this.getColorConfig(Horizontal, ConfigKeys.Color.name(), new ColorRGBA(ColorRGBA.BLUE)));
        this._horizontals.setLineWidth(this.getIntConfig(Horizontal, ConfigKeys.Width.name(), 1));
        this._horizontals.setStipplePattern(this.getShortConfig(Horizontal, ConfigKeys.Stipple.name(), (short)-256));
        this._horizontals.setAntialiased(this.getBooleanConfig(Horizontal, ConfigKeys.Antialias.name(), true));
    }

    private void createVLines() {
        int texWidth = this._textureRenderer.getWidth();
        int texHeight = this._textureRenderer.getHeight();
        FloatBuffer verts = BufferUtils.createVector3Buffer(((int)((float)texWidth / this._vSpan) + 1) * 2);
        for (float x = this._vSpan; x <= (float)texWidth + this._vSpan; x += this._vSpan) {
            verts.put(x).put(0.0f).put(0.0f);
            verts.put(x).put(texHeight).put(0.0f);
        }
        this._verticals = new Line("vert", verts, null, null, null);
        this._verticals.getMeshData().setIndexMode(IndexMode.Lines);
        this._verticals.getSceneHints().setRenderBucketType(RenderBucketType.Ortho);
        this._verticals.setDefaultColor((ReadOnlyColorRGBA)this.getColorConfig(Vertical, ConfigKeys.Color.name(), new ColorRGBA(ColorRGBA.RED)));
        this._verticals.setLineWidth(this.getIntConfig(Vertical, ConfigKeys.Width.name(), 1));
        this._verticals.setStipplePattern(this.getShortConfig(Vertical, ConfigKeys.Stipple.name(), (short)-256));
        this._verticals.setAntialiased(this.getBooleanConfig(Vertical, ConfigKeys.Antialias.name(), true));
    }

    @Override
    public Line updateLineKey(StatType type, Line lineKey) {
        if (lineKey == null) {
            lineKey = new Line("lk", BufferUtils.createVector3Buffer(2), null, null, null);
            FloatBuffer fb = BufferUtils.createFloatBuffer((ReadOnlyVector3[])new Vector3[]{new Vector3(0.0, 0.0, 0.0), new Vector3(30.0, 0.0, 0.0)});
            fb.rewind();
            lineKey.getMeshData().setVertexBuffer(fb);
        }
        lineKey.getSceneHints().setRenderBucketType(RenderBucketType.Ortho);
        lineKey.getMeshData().setIndexMode(IndexMode.LineStrip);
        lineKey.setDefaultColor((ReadOnlyColorRGBA)this.getColorConfig(type, ConfigKeys.Color.name(), new ColorRGBA(ColorRGBA.LIGHT_GRAY)));
        lineKey.setLineWidth(this.getIntConfig(type, ConfigKeys.Width.name(), 3));
        lineKey.setStipplePattern(this.getShortConfig(type, ConfigKeys.Stipple.name(), (short)-1));
        lineKey.setAntialiased(this.getBooleanConfig(type, ConfigKeys.Antialias.name(), true));
        if (!this.getBooleanConfig(type, ConfigKeys.ShowLines.name(), true)) {
            lineKey.getSceneHints().setCullHint(CullHint.Always);
        }
        return lineKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        List<MultiStatSample> list = StatCollector.getHistorical();
        synchronized (list) {
            Iterator<StatType> i = this._entries.keySet().iterator();
            while (i.hasNext()) {
                LineEntry entry = this._entries.get(i.next());
                entry.line.removeFromParent();
                entry.point.removeFromParent();
                i.remove();
            }
        }
    }

    class LineEntry {
        public List<Vector3> verts = new ArrayList<Vector3>();
        public int maxSamples;
        public double min = 0.0;
        public double max = 10.0;
        public boolean visited;
        public Point point;
        public Line line;

        public LineEntry(int maxSamples, StatType type) {
            this.maxSamples = maxSamples;
            this.point = new Point("p", BufferUtils.createVector3Buffer(maxSamples), null, null, null);
            this.point.getSceneHints().setRenderBucketType(RenderBucketType.Ortho);
            this.point.setDefaultColor((ReadOnlyColorRGBA)LineGrapher.this.getColorConfig(type, ConfigKeys.PointColor.name(), new ColorRGBA(ColorRGBA.WHITE)));
            this.point.setPointSize(LineGrapher.this.getIntConfig(type, ConfigKeys.PointSize.name(), 5));
            this.point.setAntialiased(LineGrapher.this.getBooleanConfig(type, ConfigKeys.Antialias.name(), true));
            if (!LineGrapher.this.getBooleanConfig(type, ConfigKeys.ShowPoints.name(), false)) {
                this.point.getSceneHints().setCullHint(CullHint.Always);
            }
            this.line = new Line("l", BufferUtils.createVector3Buffer(maxSamples), null, null, null);
            this.line.getSceneHints().setRenderBucketType(RenderBucketType.Ortho);
            this.line.getMeshData().setIndexMode(IndexMode.LineStrip);
            this.line.setDefaultColor((ReadOnlyColorRGBA)LineGrapher.this.getColorConfig(type, ConfigKeys.Color.name(), new ColorRGBA(ColorRGBA.LIGHT_GRAY)));
            this.line.setLineWidth(LineGrapher.this.getIntConfig(type, ConfigKeys.Width.name(), 3));
            this.line.setStipplePattern(LineGrapher.this.getShortConfig(type, ConfigKeys.Stipple.name(), (short)-1));
            this.line.setAntialiased(LineGrapher.this.getBooleanConfig(type, ConfigKeys.Antialias.name(), true));
            if (!LineGrapher.this.getBooleanConfig(type, ConfigKeys.ShowLines.name(), true)) {
                this.line.getSceneHints().setCullHint(CullHint.Always);
            }
        }
    }

    public static enum ConfigKeys {
        ShowPoints,
        PointSize,
        PointColor,
        Antialias,
        ShowLines,
        Width,
        Stipple,
        Color,
        FrameAverage;

    }
}

