/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.stat.graph;

import com.ardor3d.image.Texture;
import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.queue.RenderBucketType;
import com.ardor3d.renderer.state.BlendState;
import com.ardor3d.scenegraph.Line;
import com.ardor3d.scenegraph.Node;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.hint.CullHint;
import com.ardor3d.scenegraph.shape.Quad;
import com.ardor3d.ui.text.BasicText;
import com.ardor3d.util.Constants;
import com.ardor3d.util.stat.MultiStatSample;
import com.ardor3d.util.stat.StatCollector;
import com.ardor3d.util.stat.StatType;
import com.ardor3d.util.stat.StatValue;
import com.ardor3d.util.stat.graph.AbstractStatGrapher;
import com.ardor3d.util.stat.graph.LineGrapher;
import com.ardor3d.util.stat.graph.TableLinkable;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TabledLabelGrapher
extends AbstractStatGrapher {
    public static final int DEFAULT_DECIMALS = 2;
    protected Node _graphRoot = new Node("root");
    protected int _eventCount = 0;
    protected int _threshold = 1;
    protected int _columns = 1;
    protected Quad _bgQuad = new Quad("bgQuad", 1.0, 1.0);
    protected BlendState _defBlendState = null;
    private final HashMap<StatType, LabelEntry> _entries = new HashMap();
    private boolean _minimalBackground;
    private AbstractStatGrapher _linkedGraph;

    public TabledLabelGrapher(int width, int height, Renderer renderer, ContextCapabilities caps) {
        super(width, height, renderer, caps);
        this._defBlendState = new BlendState();
        this._defBlendState.setEnabled(true);
        this._defBlendState.setBlendEnabled(true);
        this._defBlendState.setSourceFunction(BlendState.SourceFunction.SourceAlpha);
        this._defBlendState.setDestinationFunction(BlendState.DestinationFunction.OneMinusSourceAlpha);
        this._graphRoot.setRenderState(this._defBlendState);
        this._bgQuad.getSceneHints().setRenderBucketType(RenderBucketType.Ortho);
        this._bgQuad.setDefaultColor((ReadOnlyColorRGBA)new ColorRGBA(ColorRGBA.BLACK));
        this._graphRoot.getSceneHints().setCullHint(CullHint.Never);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statsUpdated() {
        if (!this.isEnabled() || !Constants.updateGraphs) {
            return;
        }
        StatCollector.pause();
        int texWidth = this._gWidth;
        int texHeight = this._gHeight;
        ++this._eventCount;
        if (this._eventCount < this._threshold) {
            return;
        }
        this._eventCount = 0;
        int col = 0;
        double lastY = texHeight - 3;
        double maxY = 0.0;
        float colSize = (float)texWidth / (float)this.getColumns();
        for (StatType type : this._entries.keySet()) {
            this._entries.get((Object)type).visited = false;
        }
        List<MultiStatSample> list = StatCollector.getHistorical();
        synchronized (list) {
            MultiStatSample sample = StatCollector.getHistorical().get(StatCollector.getHistorical().size() - 1);
            for (StatType type : this._config.keySet()) {
                LabelEntry entry;
                StatValue val = sample.getStatValue(type);
                if (val == null) {
                    if (!StatCollector.hasHistoricalStat(type)) continue;
                    val = new StatValue();
                    val.incrementIterations();
                }
                if ((entry = this._entries.get(type)) == null) {
                    entry = new LabelEntry(type);
                    this._entries.put(type, entry);
                    this._graphRoot.attachChild(entry.text);
                }
                entry.visited = true;
                double value = this.getBooleanConfig(type, ConfigKeys.FrameAverage.name(), false) ? val.getAverageValue() : val.getAccumulatedValue();
                entry.text.setText(this.getStringConfig(type, ConfigKeys.Name.name(), type.getStatName()) + " " + this.stripVal(value, type));
                float scale = this.getFloatConfig(type, ConfigKeys.FontScale.name(), 0.8f);
                entry.text.setScale(scale);
                entry.text.setTextColor((ReadOnlyColorRGBA)this.getColorConfig(type, ConfigKeys.TextColor.name(), this._linkedGraph != null ? this._linkedGraph.getColorConfig(type, LineGrapher.ConfigKeys.Color.name(), new ColorRGBA(ColorRGBA.WHITE)) : new ColorRGBA(ColorRGBA.WHITE)));
                double labelHeight = entry.text.getHeight();
                if (maxY < labelHeight) {
                    maxY = labelHeight;
                }
                entry.text.setTranslation(colSize * (float)col, lastY, 0.0);
                if (this._linkedGraph != null && this._linkedGraph.hasConfig(type) && this._linkedGraph instanceof TableLinkable) {
                    entry.lineKey = ((TableLinkable)((Object)this._linkedGraph)).updateLineKey(type, entry.lineKey);
                    if (entry.lineKey.getParent() != this._graphRoot) {
                        this._graphRoot.attachChild(entry.lineKey);
                    }
                    ReadOnlyVector3 tLoc = entry.text.getTranslation();
                    entry.lineKey.setTranslation((float)(tLoc.getX() + (double)entry.text.getWidth() + 15.0), (float)(tLoc.getY() + 0.5 * (double)entry.text.getHeight()), 0.0);
                }
                ++col;
                if ((col %= this.getColumns()) != 0) continue;
                lastY -= maxY;
                maxY = 0.0;
            }
            Iterator<StatType> i = this._entries.keySet().iterator();
            while (i.hasNext()) {
                LabelEntry entry = this._entries.get(i.next());
                if (entry.visited) continue;
                entry.text.removeFromParent();
                if (entry.lineKey != null) {
                    entry.lineKey.removeFromParent();
                }
                i.remove();
            }
        }
        this._graphRoot.updateGeometricState(0.0, true);
        ColorRGBA bgColor = ColorRGBA.fetchTempInstance().set(this._textureRenderer.getBackgroundColor());
        if (this._minimalBackground) {
            bgColor.setAlpha(0.0f);
            this._textureRenderer.setBackgroundColor((ReadOnlyColorRGBA)bgColor);
            lastY -= 3.0;
            if (col != 0) {
                lastY -= maxY;
            }
            this._bgQuad.resize(texWidth, (double)texHeight - lastY);
            this._bgQuad.setRenderState(this._defBlendState);
            this._bgQuad.setTranslation((float)texWidth / 2.0f, (double)texHeight - ((double)texHeight - lastY) / 2.0, 0.0);
            this._bgQuad.updateGeometricState(0.0, true);
            this._textureRenderer.render((Spatial)this._bgQuad, (Texture)this._texture, 3);
            this._textureRenderer.render((Spatial)this._graphRoot, (Texture)this._texture, 0);
        } else {
            bgColor.setAlpha(1.0f);
            this._textureRenderer.setBackgroundColor((ReadOnlyColorRGBA)bgColor);
            this._textureRenderer.render((Spatial)this._graphRoot, (Texture)this._texture, 3);
        }
        ColorRGBA.releaseTempInstance((ColorRGBA)bgColor);
        StatCollector.resume();
    }

    private String stripVal(double val, StatType type) {
        val *= this.getDoubleConfig(type, ConfigKeys.ValueScale.name(), 1.0);
        String post = "";
        if (this.getBooleanConfig(type, ConfigKeys.Abbreviate.name(), true)) {
            if (val >= 1000000.0) {
                val /= 1000000.0;
                post = "m";
            } else if (val >= 1000.0) {
                val /= 1000.0;
                post = "k";
            }
        }
        int decimals = this.getIntConfig(type, ConfigKeys.Decimals.name(), 2);
        if (!"".equals(post) && decimals == 0) {
            decimals = 1;
        }
        StringBuilder format = new StringBuilder(decimals > 0 ? "0.0" : "0");
        for (int x = 1; x < decimals; ++x) {
            format.append('0');
        }
        return new DecimalFormat(format.toString()).format(val) + post;
    }

    public int getThreshold() {
        return this._threshold;
    }

    public void setThreshold(int threshold) {
        this._threshold = threshold;
    }

    public int getColumns() {
        return this._columns;
    }

    public void setColumns(int columns) {
        if (columns < 1) {
            throw new IllegalArgumentException("columns must be >= 1 (" + columns + ")");
        }
        this._columns = columns;
    }

    public boolean isMinimalBackground() {
        return this._minimalBackground;
    }

    public void setMinimalBackground(boolean minimalBackground) {
        this._minimalBackground = minimalBackground;
    }

    public void linkTo(AbstractStatGrapher grapher) {
        this._linkedGraph = grapher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        List<MultiStatSample> list = StatCollector.getHistorical();
        synchronized (list) {
            Iterator<StatType> i = this._entries.keySet().iterator();
            while (i.hasNext()) {
                LabelEntry entry = this._entries.get(i.next());
                entry.text.removeFromParent();
                entry.lineKey.removeFromParent();
                i.remove();
            }
        }
    }

    class LabelEntry {
        BasicText text;
        Line lineKey;
        boolean visited;
        StatType _type;

        public LabelEntry(StatType type) {
            this._type = type;
            this.text = BasicText.createDefaultTextLabel("label", TabledLabelGrapher.this.getStringConfig(type, ConfigKeys.Name.name(), type.getStatName()));
        }
    }

    public static enum ConfigKeys {
        TextColor,
        Name,
        FrameAverage,
        Decimals,
        FontScale,
        ValueScale,
        Abbreviate;

    }
}

