/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.util.stat.graph;

import com.ardor3d.image.Texture;
import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.IndexMode;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.queue.RenderBucketType;
import com.ardor3d.renderer.state.BlendState;
import com.ardor3d.scenegraph.Line;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.scenegraph.Node;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.hint.CullHint;
import com.ardor3d.util.Constants;
import com.ardor3d.util.geom.BufferUtils;
import com.ardor3d.util.stat.MultiStatSample;
import com.ardor3d.util.stat.StatCollector;
import com.ardor3d.util.stat.StatType;
import com.ardor3d.util.stat.graph.AbstractStatGrapher;
import com.ardor3d.util.stat.graph.TableLinkable;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TimedAreaGrapher
extends AbstractStatGrapher
implements TableLinkable {
    public static final StatType Vertical = new StatType("_timedGrapher_vert");
    public static final StatType Horizontal = new StatType("_timedGrapher_horiz");
    protected Node _graphRoot = new Node("root");
    protected Line _horizontals;
    protected Line _verticals;
    protected int _eventCount = 0;
    protected int _threshold = 1;
    protected float _startMarker = 0.0f;
    private float _off;
    private float _vSpan;
    private static final int majorHBar = 20;
    private static final int majorVBar = 10;
    private final HashMap<StatType, AreaEntry> _entries = new HashMap();
    private BlendState _defBlendState = null;

    public TimedAreaGrapher(int width, int height, Renderer renderer, ContextCapabilities caps) {
        super(width, height, renderer, caps);
        this.createHLines();
        this._defBlendState = new BlendState();
        this._defBlendState.setEnabled(true);
        this._defBlendState.setBlendEnabled(true);
        this._defBlendState.setSourceFunction(BlendState.SourceFunction.SourceAlpha);
        this._defBlendState.setDestinationFunction(BlendState.DestinationFunction.OneMinusSourceAlpha);
        this._graphRoot.setRenderState(this._defBlendState);
        this._graphRoot.getSceneHints().setCullHint(CullHint.Never);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statsUpdated() {
        if (!this.isEnabled() || !Constants.updateGraphs) {
            return;
        }
        StatCollector.pause();
        int texWidth = this._gWidth;
        int texHeight = this._gHeight;
        ++this._eventCount;
        this._off = (float)((double)this._off + StatCollector.getStartOffset());
        if (this._eventCount < this._threshold) {
            return;
        }
        this._eventCount = 0;
        if (!this._graphRoot.equals(this._horizontals.getParent())) {
            this._graphRoot.attachChild(this._horizontals);
        }
        float newVSpan = this.calcVSpan();
        if (this._verticals == null || newVSpan != this._vSpan) {
            this._vSpan = newVSpan;
            this.createVLines();
        }
        this._off = (float)((double)this._off % (StatCollector.getSampleRate() * 10.0));
        if (!this._graphRoot.equals(this._verticals.getParent())) {
            this._graphRoot.attachChild(this._verticals);
        }
        this.shiftVerticals();
        for (StatType type : this._entries.keySet()) {
            this._entries.get((Object)type).visited = false;
            this._entries.get((Object)type).verts.clear();
        }
        List<MultiStatSample> list = StatCollector.getHistorical();
        synchronized (list) {
            for (int i = 0; i < StatCollector.getHistorical().size(); ++i) {
                MultiStatSample sample = StatCollector.getHistorical().get(i);
                double max = 0.0;
                for (StatType type : sample.getStatTypes()) {
                    if (!this._config.containsKey(type)) continue;
                    max = Math.max(sample.getStatValue(type).getAccumulatedValue(), max);
                }
                double accum = 0.0;
                for (StatType type : sample.getStatTypes()) {
                    if (!this._config.containsKey(type)) continue;
                    AreaEntry entry = this._entries.get(type);
                    if (entry == null || entry.maxSamples != StatCollector.getMaxSamples()) {
                        entry = new AreaEntry(StatCollector.getMaxSamples(), type);
                        this._entries.put(type, entry);
                    }
                    double value = sample.getStatValue(type).getAccumulatedValue() / max;
                    Vector3 point1 = new Vector3((double)i, (double)((float)(value + accum)), 0.0);
                    entry.verts.add(point1);
                    Vector3 point2 = new Vector3((double)i, (double)((float)accum), 0.0);
                    entry.verts.add(point2);
                    entry.visited = true;
                    accum += value;
                }
            }
        }
        float scaleWidth = (float)texWidth / (float)(StatCollector.getMaxSamples() - 1);
        float scaleHeight = (float)texHeight / 1.02f;
        Iterator<StatType> i = this._entries.keySet().iterator();
        while (i.hasNext()) {
            AreaEntry entry = this._entries.get(i.next());
            if (!entry.visited) {
                entry.area.removeFromParent();
                i.remove();
                continue;
            }
            FloatBuffer fb = BufferUtils.createFloatBuffer((ReadOnlyVector3[])entry.verts.toArray(new Vector3[entry.verts.size()]));
            fb.rewind();
            entry.area.getMeshData().setVertexBuffer(fb);
            entry.area.setScale((ReadOnlyVector3)new Vector3((double)scaleWidth, (double)scaleHeight, 1.0));
            entry.area.getMeshData().getIndices().limit(entry.verts.size());
            if (this._graphRoot.equals(entry.area.getParent())) continue;
            this._graphRoot.attachChild(entry.area);
        }
        this._graphRoot.updateGeometricState(0.0, true);
        this._textureRenderer.render((Spatial)this._graphRoot, (Texture)this._texture, 3);
        StatCollector.resume();
    }

    private float calcVSpan() {
        return this._textureRenderer.getWidth() * 10 / StatCollector.getMaxSamples();
    }

    private void shiftVerticals() {
        int texWidth = this._textureRenderer.getWidth();
        double xOffset = (double)(-(this._off * (float)texWidth)) / ((double)StatCollector.getMaxSamples() * StatCollector.getSampleRate());
        ReadOnlyVector3 trans = this._verticals.getTranslation();
        this._verticals.setTranslation(xOffset, trans.getY(), trans.getZ());
    }

    public int getThreshold() {
        return this._threshold;
    }

    public void setThreshold(int threshold) {
        this._threshold = threshold;
    }

    private void createHLines() {
        int texWidth = this._textureRenderer.getWidth();
        int texHeight = this._textureRenderer.getHeight();
        FloatBuffer verts = BufferUtils.createVector3Buffer(10);
        float div = (float)(texHeight * 20) / 100.0f;
        int y = 0;
        for (int i = 0; i < verts.capacity(); i += 6) {
            verts.put(0.0f).put(y).put(0.0f);
            verts.put(texWidth).put(y).put(0.0f);
            y = (int)((float)y + div);
        }
        this._horizontals = new Line("horiz", verts, null, null, null);
        this._horizontals.getMeshData().setIndexMode(IndexMode.Lines);
        this._horizontals.getSceneHints().setRenderBucketType(RenderBucketType.Ortho);
        this._horizontals.setDefaultColor((ReadOnlyColorRGBA)this.getColorConfig(Horizontal, ConfigKeys.Color.name(), new ColorRGBA(ColorRGBA.BLUE)));
        this._horizontals.setLineWidth(this.getIntConfig(Horizontal, ConfigKeys.Width.name(), 1));
        this._horizontals.setStipplePattern(this.getShortConfig(Horizontal, ConfigKeys.Stipple.name(), (short)-256));
        this._horizontals.setAntialiased(this.getBooleanConfig(Horizontal, ConfigKeys.Antialias.name(), true));
    }

    private void createVLines() {
        int texWidth = this._textureRenderer.getWidth();
        int texHeight = this._textureRenderer.getHeight();
        FloatBuffer verts = BufferUtils.createVector3Buffer(((int)((float)texWidth / this._vSpan) + 1) * 2);
        for (float x = this._vSpan; x <= (float)texWidth + this._vSpan; x += this._vSpan) {
            verts.put(x).put(0.0f).put(0.0f);
            verts.put(x).put(texHeight).put(0.0f);
        }
        this._verticals = new Line("vert", verts, null, null, null);
        this._verticals.getMeshData().setIndexMode(IndexMode.Lines);
        this._verticals.getSceneHints().setRenderBucketType(RenderBucketType.Ortho);
        this._verticals.setDefaultColor((ReadOnlyColorRGBA)this.getColorConfig(Vertical, ConfigKeys.Color.name(), new ColorRGBA(ColorRGBA.RED)));
        this._verticals.setLineWidth(this.getIntConfig(Vertical, ConfigKeys.Width.name(), 1));
        this._verticals.setStipplePattern(this.getShortConfig(Vertical, ConfigKeys.Stipple.name(), (short)-256));
        this._verticals.setAntialiased(this.getBooleanConfig(Vertical, ConfigKeys.Antialias.name(), true));
    }

    @Override
    public Line updateLineKey(StatType type, Line lineKey) {
        if (lineKey == null) {
            lineKey = new Line("lk", BufferUtils.createVector3Buffer(2), null, null, null);
            FloatBuffer fb = BufferUtils.createFloatBuffer((ReadOnlyVector3[])new Vector3[]{new Vector3(0.0, 0.0, 0.0), new Vector3(30.0, 0.0, 0.0)});
            fb.rewind();
            lineKey.getMeshData().setVertexBuffer(fb);
        }
        lineKey.getSceneHints().setRenderBucketType(RenderBucketType.Ortho);
        lineKey.getMeshData().setIndexMode(IndexMode.LineLoop);
        lineKey.setDefaultColor((ReadOnlyColorRGBA)this.getColorConfig(type, ConfigKeys.Color.name(), new ColorRGBA(ColorRGBA.LIGHT_GRAY)));
        lineKey.setLineWidth(this.getIntConfig(type, ConfigKeys.Width.name(), 3));
        lineKey.setStipplePattern(this.getShortConfig(type, ConfigKeys.Stipple.name(), (short)-1));
        lineKey.setAntialiased(this.getBooleanConfig(type, ConfigKeys.Antialias.name(), true));
        if (!this.getBooleanConfig(type, ConfigKeys.ShowAreas.name(), true)) {
            lineKey.getSceneHints().setCullHint(CullHint.Always);
        }
        return lineKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        List<MultiStatSample> list = StatCollector.getHistorical();
        synchronized (list) {
            Iterator<StatType> i = this._entries.keySet().iterator();
            while (i.hasNext()) {
                AreaEntry entry = this._entries.get(i.next());
                entry.area.removeFromParent();
                i.remove();
            }
        }
    }

    class AreaEntry {
        public List<Vector3> verts = new ArrayList<Vector3>();
        public int maxSamples;
        public boolean visited;
        public Mesh area;

        public AreaEntry(int maxSamples, StatType type) {
            this.maxSamples = maxSamples;
            this.area = new Mesh("a");
            this.area.getMeshData().setVertexBuffer(BufferUtils.createVector3Buffer(maxSamples * 2));
            this.area.getSceneHints().setRenderBucketType(RenderBucketType.Ortho);
            this.area.getMeshData().setIndexMode(IndexMode.LineStrip);
            this.area.setDefaultColor((ReadOnlyColorRGBA)TimedAreaGrapher.this.getColorConfig(type, ConfigKeys.Color.name(), new ColorRGBA(ColorRGBA.LIGHT_GRAY)));
            if (!TimedAreaGrapher.this.getBooleanConfig(type, ConfigKeys.ShowAreas.name(), true)) {
                this.area.getSceneHints().setCullHint(CullHint.Always);
            }
        }
    }

    public static enum ConfigKeys {
        Antialias,
        ShowAreas,
        Width,
        Stipple,
        Color;

    }
}

