/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.classpath;

import com.threerings.getdown.classpath.ClassPath;
import com.threerings.getdown.classpath.cache.GarbageCollector;
import com.threerings.getdown.classpath.cache.ResourceCache;
import com.threerings.getdown.data.Application;
import com.threerings.getdown.data.Resource;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.concurrent.TimeUnit;

public class ClassPaths {
    static final String CACHE_DIR = ".cache";

    public static ClassPath buildClassPath(Application app) throws IOException {
        return app.useCodeCache() ? ClassPaths.buildDefaultClassPath(app) : ClassPaths.buildCachedClassPath(app);
    }

    public static ClassPath buildDefaultClassPath(Application app) {
        LinkedHashSet<File> classPathEntries = new LinkedHashSet<File>();
        for (Resource resource : app.getActiveCodeResources()) {
            classPathEntries.add(resource.getFinalTarget());
        }
        return new ClassPath(classPathEntries);
    }

    public static ClassPath buildCachedClassPath(Application app) throws IOException {
        File cacheDir = new File(app.getAppdir(), CACHE_DIR);
        if (app.getCodeCacheRetentionDays() <= 0) {
            ClassPaths.runGarbageCollection(app, cacheDir);
        }
        ResourceCache cache = new ResourceCache(cacheDir);
        LinkedHashSet<File> classPathEntries = new LinkedHashSet<File>();
        for (Resource resource : app.getActiveCodeResources()) {
            File entry = cache.cacheFile(resource.getFinalTarget(), app.getDigest(resource));
            classPathEntries.add(entry);
        }
        if (app.getCodeCacheRetentionDays() > 0) {
            ClassPaths.runGarbageCollection(app, cacheDir);
        }
        return new ClassPath(classPathEntries);
    }

    private static void runGarbageCollection(Application app, File cacheDir) {
        long retainMillis = TimeUnit.DAYS.toMillis(app.getCodeCacheRetentionDays());
        GarbageCollector.collect(cacheDir, retainMillis);
    }
}

