/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.samskivert.io.StreamUtil;
import com.samskivert.text.MessageUtil;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.RandomUtil;
import com.samskivert.util.RunAnywhere;
import com.samskivert.util.StringUtil;
import com.threerings.getdown.Log;
import com.threerings.getdown.classpath.ClassPath;
import com.threerings.getdown.classpath.ClassPaths;
import com.threerings.getdown.data.Digest;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.util.ConfigUtil;
import com.threerings.getdown.util.ConnectionUtil;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.LaunchUtil;
import com.threerings.getdown.util.ProgressAggregator;
import com.threerings.getdown.util.ProgressObserver;
import com.threerings.getdown.util.VersionUtil;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JApplet;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application {
    public static final String CONFIG_FILE = "getdown.txt";
    public static final String VERSION_FILE = "version.txt";
    public static final String PROP_PASSTHROUGH_PREFIX = "app.";
    public static final String SIGNATURE_SUFFIX = ".sig";
    public static final String MANIFEST_CLASS = "manifest";
    protected File _appdir;
    protected String _appid;
    protected File _config;
    protected Digest _digest;
    protected long _version = -1L;
    protected long _targetVersion = -1L;
    protected String _appbase;
    protected URL _vappbase;
    protected URL _latest;
    protected String _class;
    protected String _name;
    protected String _dockIconPath;
    protected boolean _windebug;
    protected boolean _allowOffline;
    protected String _trackingURL;
    protected Set<Integer> _trackingPcts;
    protected String _trackingCookieName;
    protected String _trackingCookieProperty;
    protected String _trackingURLSuffix;
    protected String _trackingGAHash;
    protected long _trackingStart;
    protected int _trackingId;
    protected String _javaVersionProp = "java.version";
    protected String _javaVersionRegex = "(\\d+)\\.(\\d+)\\.(\\d+)(_\\d+)?.*";
    protected long _javaMinVersion;
    protected long _javaMaxVersion;
    protected boolean _javaExactVersionRequired;
    protected String _javaLocation;
    protected List<Resource> _codes = new ArrayList<Resource>();
    protected List<Resource> _resources = new ArrayList<Resource>();
    protected boolean _useCodeCache;
    protected int _codeCacheRetentionDays;
    protected Map<String, AuxGroup> _auxgroups = new HashMap<String, AuxGroup>();
    protected Map<String, Boolean> _auxactive = new HashMap<String, Boolean>();
    protected List<String> _jvmargs = new ArrayList<String>();
    protected List<String> _appargs = new ArrayList<String>();
    protected String[] _extraJvmArgs;
    protected String[] _extraAppArgs;
    protected String[] _optimumJvmArgs;
    protected List<String> _txtJvmArgs = new ArrayList<String>();
    protected List<Certificate> _signers;
    protected boolean _warnedAboutSetLastModified;
    protected FileLock _lock;
    protected FileChannel _lockChannel;
    protected static final String[] SA_PROTO = ArrayUtil.EMPTY_STRING;
    protected static final String ENV_VAR_PREFIX = "%ENV.";
    protected static final Pattern ENV_VAR_PATTERN = Pattern.compile("%ENV\\.(.*?)%");

    public Application(File appdir, String appid) {
        this(appdir, appid, null, null, null);
    }

    public Application(File appdir, String appid, List<Certificate> signers, String[] jvmargs, String[] appargs) {
        this._appdir = appdir;
        this._appid = appid;
        this._signers = signers == null ? Collections.emptyList() : signers;
        this._config = this.getLocalPath(CONFIG_FILE);
        this._extraJvmArgs = jvmargs == null ? ArrayUtil.EMPTY_STRING : jvmargs;
        this._extraAppArgs = appargs == null ? ArrayUtil.EMPTY_STRING : appargs;
    }

    public File getAppdir() {
        return this._appdir;
    }

    public boolean useCodeCache() {
        return this._useCodeCache;
    }

    public int getCodeCacheRetentionDays() {
        return this._codeCacheRetentionDays;
    }

    public Resource getConfigResource() {
        try {
            return this.createResource(CONFIG_FILE, false);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid appbase '" + this._vappbase + "'.", e);
        }
    }

    public List<Resource> getCodeResources() {
        return this._codes;
    }

    public List<Resource> getResources() {
        return this._resources;
    }

    public String getDigest(Resource resource) {
        return this._digest.getDigest(resource);
    }

    public List<Resource> getAllActiveResources() {
        ArrayList<Resource> allResources = new ArrayList<Resource>();
        allResources.addAll(this.getActiveCodeResources());
        allResources.addAll(this.getActiveResources());
        return allResources;
    }

    public AuxGroup getAuxGroup(String name) {
        return this._auxgroups.get(name);
    }

    public Iterable<AuxGroup> getAuxGroups() {
        return this._auxgroups.values();
    }

    public boolean isAuxGroupActive(String auxgroup) {
        Boolean active = this._auxactive.get(auxgroup);
        if (active == null) {
            active = this.getLocalPath(auxgroup + ".dat").exists();
            this._auxactive.put(auxgroup, active);
        }
        return active;
    }

    public List<Resource> getActiveCodeResources() {
        ArrayList<Resource> codes = new ArrayList<Resource>();
        codes.addAll(this.getCodeResources());
        for (AuxGroup aux : this.getAuxGroups()) {
            if (!this.isAuxGroupActive(aux.name)) continue;
            codes.addAll(aux.codes);
        }
        return codes;
    }

    public List<Resource> getActiveResources() {
        ArrayList<Resource> rsrcs = new ArrayList<Resource>();
        rsrcs.addAll(this.getResources());
        for (AuxGroup aux : this.getAuxGroups()) {
            if (!this.isAuxGroupActive(aux.name)) continue;
            rsrcs.addAll(aux.rsrcs);
        }
        return rsrcs;
    }

    public Resource getPatchResource(String auxgroup) {
        if (this._targetVersion <= this._version) {
            Log.log.warning((Object)"Requested patch resource for up-to-date or non-versioned application", new Object[]{"cvers", this._version, "tvers", this._targetVersion});
            return null;
        }
        String infix = auxgroup == null ? "" : "-" + auxgroup;
        String pfile = "patch" + infix + this._version + ".dat";
        try {
            URL remote = new URL(this.createVAppBase(this._targetVersion), Application.encodePath(pfile));
            return new Resource(pfile, remote, this.getLocalPath(pfile), false);
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failed to create patch resource path", new Object[]{"pfile", pfile, "appbase", this._appbase, "tvers", this._targetVersion, "error", e});
            return null;
        }
    }

    public Resource getJavaVMResource() {
        if (StringUtil.isBlank((String)this._javaLocation)) {
            return null;
        }
        String vmfile = "java_vm.jar";
        try {
            URL remote = new URL(this.createVAppBase(this._targetVersion), Application.encodePath(this._javaLocation));
            return new Resource(vmfile, remote, this.getLocalPath(vmfile), true);
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failed to create VM resource", new Object[]{"vmfile", vmfile, "appbase", this._appbase, "tvers", this._targetVersion, "javaloc", this._javaLocation, "error", e});
            return null;
        }
    }

    public Resource getFullResource() {
        String file = "full";
        try {
            URL remote = new URL(this.createVAppBase(this._targetVersion), Application.encodePath(file));
            return new Resource(file, remote, this.getLocalPath(file), false);
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failed to create full resource path", new Object[]{"file", file, "appbase", this._appbase, "tvers", this._targetVersion, "error", e});
            return null;
        }
    }

    public URL getTrackingURL(String event) {
        try {
            String suffix = this._trackingURLSuffix == null ? "" : this._trackingURLSuffix;
            String ga = this.getGATrackingCode();
            return this._trackingURL == null ? null : new URL(Application.encodePath(this._trackingURL + event + suffix + ga));
        }
        catch (MalformedURLException mue) {
            Log.log.warning((Object)"Invalid tracking URL", new Object[]{"path", this._trackingURL, "event", event, "error", mue});
            return null;
        }
    }

    public URL getTrackingProgressURL(int percent) {
        if (this._trackingPcts == null || !this._trackingPcts.contains(percent)) {
            return null;
        }
        return this.getTrackingURL("pct" + percent);
    }

    public String getTrackingCookieName() {
        return this._trackingCookieName;
    }

    public String getTrackingCookieProperty() {
        return this._trackingCookieProperty;
    }

    public UpdateInterface init(boolean checkPlatform) throws IOException {
        String installError;
        Map<String, Object> cdata = null;
        File config = this._config;
        try {
            if (config.exists()) {
                cdata = ConfigUtil.parseConfig(this._config, checkPlatform);
            } else {
                config = this.getLocalPath("getdown.txt_old");
                if (config.exists()) {
                    cdata = ConfigUtil.parseConfig(config, checkPlatform);
                } else {
                    Log.log.info((Object)"Found no getdown.txt file", new Object[]{"appdir", this._appdir});
                }
            }
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failure reading config file", new Object[]{"file", config, e});
        }
        if (cdata == null) {
            String appbase = SysProps.appBase();
            Log.log.info((Object)"Attempting to obtain 'appbase' from system property", new Object[]{"appbase", appbase});
            cdata = new HashMap<String, Object>();
            cdata.put("appbase", appbase);
        }
        this._appbase = (String)cdata.get("appbase");
        if (this._appbase == null) {
            throw new RuntimeException("m.missing_appbase");
        }
        if (!this._appbase.endsWith("/")) {
            this._appbase = this._appbase + "/";
        }
        this._appbase = this.replaceDomain(this._appbase);
        String vstr = (String)cdata.get("version");
        if (vstr != null) {
            this._version = Application.parseLong(vstr, "m.invalid_version");
        }
        try {
            this._vappbase = this._version < 0L ? new URL(this._appbase) : this.createVAppBase(this._version);
        }
        catch (MalformedURLException mue) {
            String err = MessageUtil.tcompose((String)"m.invalid_appbase", (String[])new String[]{this._appbase});
            throw (IOException)new IOException(err).initCause(mue);
        }
        String latest = (String)cdata.get("latest");
        if (latest != null) {
            latest = this.replaceDomain(latest);
            try {
                this._latest = new URL(latest);
            }
            catch (MalformedURLException mue) {
                Log.log.warning((Object)"Invalid URL for latest attribute.", new Object[]{mue});
            }
        }
        String appPrefix = StringUtil.isBlank((String)this._appid) ? "" : this._appid + ".";
        this._class = (String)cdata.get(appPrefix + "class");
        if (this._class == null) {
            throw new IOException("m.missing_class");
        }
        vstr = (String)cdata.get("java_version_prop");
        if (vstr != null) {
            this._javaVersionProp = vstr;
        }
        if ((vstr = (String)cdata.get("java_version_regex")) != null) {
            this._javaVersionRegex = vstr;
        }
        if ((vstr = (String)cdata.get("java_version")) != null) {
            this._javaMinVersion = Application.parseLong(vstr, "m.invalid_java_version");
        }
        if ((vstr = (String)cdata.get("java_min_version")) != null) {
            this._javaMinVersion = Application.parseLong(vstr, "m.invalid_java_version");
        }
        if ((vstr = (String)cdata.get("java_max_version")) != null) {
            this._javaMaxVersion = Application.parseLong(vstr, "m.invalid_java_version");
        }
        vstr = (String)cdata.get("java_exact_version_required");
        this._javaExactVersionRequired = Boolean.parseBoolean(vstr);
        Object javaloc = cdata.get("java_location");
        if (javaloc instanceof String) {
            this._javaLocation = (String)javaloc;
        }
        this._trackingURL = (String)cdata.get("tracking_url");
        String trackPcts = (String)cdata.get("tracking_percents");
        if (!StringUtil.isBlank((String)trackPcts)) {
            this._trackingPcts = new HashSet<Integer>();
            for (int pct : StringUtil.parseIntArray((String)trackPcts)) {
                this._trackingPcts.add(pct);
            }
        } else if (!StringUtil.isBlank((String)this._trackingURL)) {
            this._trackingPcts = new HashSet<Integer>();
            this._trackingPcts.add(50);
        }
        this._trackingCookieName = (String)cdata.get("tracking_cookie_name");
        this._trackingCookieProperty = (String)cdata.get("tracking_cookie_property");
        this._trackingURLSuffix = (String)cdata.get("tracking_url_suffix");
        this._trackingGAHash = (String)cdata.get("tracking_ga_hash");
        this._codes.clear();
        this._resources.clear();
        this._auxgroups.clear();
        this._jvmargs.clear();
        this._appargs.clear();
        this._txtJvmArgs.clear();
        if (ConfigUtil.getMultiValue(cdata, "code") == null && ConfigUtil.getMultiValue(cdata, "ucode") == null) {
            throw new IOException("m.missing_code");
        }
        this.parseResources(cdata, "code", false, this._codes);
        this.parseResources(cdata, "ucode", true, this._codes);
        this.parseResources(cdata, "resource", false, this._resources);
        this.parseResources(cdata, "uresource", true, this._resources);
        for (String auxgroup : this.parseList(cdata, "auxgroups")) {
            ArrayList<Resource> codes = new ArrayList<Resource>();
            this.parseResources(cdata, auxgroup + ".code", false, codes);
            this.parseResources(cdata, auxgroup + ".ucode", true, codes);
            ArrayList<Resource> rsrcs = new ArrayList<Resource>();
            this.parseResources(cdata, auxgroup + ".resource", false, rsrcs);
            this.parseResources(cdata, auxgroup + ".uresource", true, rsrcs);
            this._auxgroups.put(auxgroup, new AuxGroup(auxgroup, codes, rsrcs));
        }
        String[] stringArray = ConfigUtil.getMultiValue(cdata, "jvmarg");
        Application.addAll(stringArray, this._jvmargs);
        if (appPrefix.length() > 0) {
            String[] stringArray2 = ConfigUtil.getMultiValue(cdata, appPrefix + "jvmarg");
            Application.addAll(stringArray2, this._jvmargs);
        }
        Application.addAll(this._extraJvmArgs, this._jvmargs);
        this._optimumJvmArgs = ConfigUtil.getMultiValue(cdata, "optimum_jvmarg");
        String[] appargs = ConfigUtil.getMultiValue(cdata, appPrefix + "apparg");
        Application.addAll(appargs, this._appargs);
        Application.addAll(this._extraAppArgs, this._appargs);
        this.fillAssignmentListFromPairs("extra.txt", this._txtJvmArgs);
        this._allowOffline = Boolean.parseBoolean((String)cdata.get("allow_offline"));
        this._windebug = this.getLocalPath("debug.txt").exists();
        this._useCodeCache = Boolean.parseBoolean((String)cdata.get("use_code_cache"));
        this._codeCacheRetentionDays = cdata.containsKey("code_cache_retention_days") ? Integer.parseInt((String)cdata.get("use_code_cache")) : 7;
        UpdateInterface ui = new UpdateInterface();
        this._name = ui.name = (String)cdata.get("ui.name");
        ui.progress = this.parseRect(cdata, "ui.progress", ui.progress);
        ui.progressText = this.parseColor(cdata, "ui.progress_text", ui.progressText);
        ui.hideProgressText = Boolean.parseBoolean((String)cdata.get("ui.hide_progress_text"));
        ui.progressBar = this.parseColor(cdata, "ui.progress_bar", ui.progressBar);
        ui.status = this.parseRect(cdata, "ui.status", ui.status);
        ui.statusText = this.parseColor(cdata, "ui.status_text", ui.statusText);
        ui.textShadow = this.parseColor(cdata, "ui.text_shadow", ui.textShadow);
        ui.hideDecorations = Boolean.parseBoolean((String)cdata.get("ui.hide_decorations"));
        ui.backgroundImage = (String)cdata.get("ui.background_image");
        if (ui.backgroundImage == null) {
            ui.backgroundImage = (String)cdata.get("ui.background");
        }
        Color defaultBackground = 0.5f < Color.RGBtoHSB(ui.progressText.getRed(), ui.progressText.getGreen(), ui.progressText.getBlue(), null)[2] ? Color.BLACK : Color.WHITE;
        ui.background = this.parseColor(cdata, "ui.background", defaultBackground);
        ui.progressImage = (String)cdata.get("ui.progress_image");
        ui.rotatingBackgrounds = ConfigUtil.getMultiValue(cdata, "ui.rotating_background");
        ui.iconImages = ConfigUtil.getMultiValue(cdata, "ui.icon");
        ui.errorBackground = (String)cdata.get("ui.error_background");
        this._dockIconPath = (String)cdata.get("ui.mac_dock_icon");
        if (this._dockIconPath == null) {
            this._dockIconPath = "../desktop.icns";
        }
        ui.installError = (installError = this.parseUrl(cdata, "ui.install_error", null)) == null ? "m.default_install_error" : MessageUtil.taint((Object)installError);
        ui.patchNotes = this.parseRect(cdata, "ui.patch_notes", ui.patchNotes);
        ui.patchNotesUrl = this.parseUrl(cdata, "ui.patch_notes_url", null);
        ui.playAgain = this.parseRect(cdata, "ui.play_again", ui.playAgain);
        ui.playAgainImage = (String)cdata.get("ui.play_again_image");
        for (UpdateInterface.Step step : UpdateInterface.Step.values()) {
            String spec = (String)cdata.get("ui.percents." + step.name());
            if (spec == null) continue;
            try {
                ui.stepPercentages.put(step, Application.intsToList(StringUtil.parseIntArray((String)spec)));
            }
            catch (Exception e) {
                Log.log.warning((Object)("Failed to parse percentages for " + (Object)((Object)step) + ": " + spec), new Object[0]);
            }
        }
        return ui;
    }

    protected void fillAssignmentListFromPairs(String pairLocation, List<String> collector) {
        File pairFile = this.getLocalPath(pairLocation);
        if (pairFile.exists()) {
            try {
                List<String[]> args = ConfigUtil.parsePairs(pairFile, false);
                for (String[] pair : args) {
                    if (pair[1].length() == 0) {
                        collector.add(pair[0]);
                        continue;
                    }
                    collector.add(pair[0] + "=" + pair[1]);
                }
            }
            catch (Throwable t) {
                Log.log.warning((Object)("Failed to parse '" + pairFile + "': " + t), new Object[0]);
            }
        }
    }

    public URL getRemoteURL(String path) throws MalformedURLException {
        return new URL(this._vappbase, Application.encodePath(path));
    }

    public File getLocalPath(String path) {
        return new File(this._appdir, path);
    }

    public boolean haveValidJavaVersion() {
        if (this._javaMinVersion == 0L && this._javaMaxVersion == 0L) {
            return true;
        }
        try {
            long version = SysProps.parseJavaVersion(this._javaVersionProp, this._javaVersionRegex);
            Log.log.info((Object)"Checking Java version", new Object[]{"current", version, "wantMin", this._javaMinVersion, "wantMax", this._javaMaxVersion});
            Resource vmjar = this.getJavaVMResource();
            if (vmjar != null && vmjar.isMarkedValid()) {
                File vmdir = new File(this._appdir, "java_vm");
                File relfile = new File(vmdir, "release");
                if (!relfile.exists()) {
                    Log.log.warning((Object)"Unpacked JVM missing 'release' file. Assuming valid version.", new Object[0]);
                    return true;
                }
                long vmvers = VersionUtil.readReleaseVersion(relfile, this._javaVersionRegex);
                if (vmvers == 0L) {
                    Log.log.warning((Object)"Unable to read version from 'release' file. Assuming valid.", new Object[0]);
                    return true;
                }
                version = vmvers;
                Log.log.info((Object)("Checking version of unpacked JVM [vers=" + version + "]."), new Object[0]);
            }
            if (this._javaExactVersionRequired) {
                if (version == this._javaMinVersion) {
                    return true;
                }
                Log.log.warning((Object)"An exact Java VM version is required.", new Object[]{"current", version, "required", this._javaMinVersion});
                return false;
            }
            boolean minVersionOK = this._javaMinVersion == 0L || version >= this._javaMinVersion;
            boolean maxVersionOK = this._javaMaxVersion == 0L || version <= this._javaMaxVersion;
            return minVersionOK && maxVersionOK;
        }
        catch (RuntimeException re) {
            Log.log.warning((Object)"Unable to parse VM version, hoping for the best", new Object[]{"error", re, "needed", this._javaMinVersion});
            return true;
        }
    }

    public boolean hasOptimumJvmArgs() {
        return this._optimumJvmArgs != null;
    }

    public boolean allowOffline() {
        return this._allowOffline;
    }

    public void attemptRecovery(StatusDisplay status) throws IOException {
        status.updateStatus("m.updating_metadata");
        this.downloadConfigFile();
    }

    public void updateMetadata() throws IOException {
        try {
            this._vappbase = this.createVAppBase(this._targetVersion);
        }
        catch (MalformedURLException mue) {
            String err = MessageUtil.tcompose((String)"m.invalid_appbase", (String[])new String[]{this._appbase});
            throw (IOException)new IOException(err).initCause(mue);
        }
        try {
            this.downloadDigestFile();
            this.downloadConfigFile();
        }
        catch (IOException ex) {
            if (this._allowOffline) {
                Log.log.warning((Object)"Failed to update digest files.  Attempting offline operaton.", new Object[]{ex});
                if (!this.getLocalPath(VERSION_FILE).delete()) {
                    Log.log.warning((Object)"Deleting version.txt failed.  This probably isn't going to work.", new Object[0]);
                }
            }
            throw ex;
        }
    }

    public Process createProcess(boolean optimum) throws IOException {
        String proxyHost;
        ArrayList<String> args = new ArrayList<String>();
        args.add(LaunchUtil.getJVMPath(this._appdir, this._windebug || optimum));
        boolean dashJarMode = MANIFEST_CLASS.equals(this._class);
        ClassPath classPath = ClassPaths.buildClassPath(this);
        if (!dashJarMode) {
            args.add("-classpath");
            args.add(classPath.asArgumentString());
        }
        if (RunAnywhere.isMacOS()) {
            args.add("-Xdock:icon=" + this.getLocalPath(this._dockIconPath).getAbsolutePath());
            args.add("-Xdock:name=" + this._name);
        }
        if ((proxyHost = System.getProperty("http.proxyHost")) != null) {
            args.add("-Dhttp.proxyHost=" + proxyHost);
            args.add("-Dhttp.proxyPort=" + System.getProperty("http.proxyPort"));
            args.add("-Dhttps.proxyHost=" + proxyHost);
            args.add("-Dhttps.proxyPort=" + System.getProperty("http.proxyPort"));
        }
        args.add("-Dcom.threerings.getdown=true");
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(PROP_PASSTHROUGH_PREFIX)) continue;
            key = key.substring(PROP_PASSTHROUGH_PREFIX.length());
            args.add("-D" + key + "=" + entry.getValue());
        }
        for (String string : this._jvmargs) {
            args.add(this.processArg(string));
        }
        if (optimum && this._optimumJvmArgs != null) {
            for (Iterator<Object> iterator : this._optimumJvmArgs) {
                args.add(this.processArg((String)((Object)iterator)));
            }
        }
        for (String string : this._txtJvmArgs) {
            args.add(this.processArg(string));
        }
        if (dashJarMode) {
            args.add("-jar");
            args.add(classPath.asArgumentString());
        } else {
            args.add(this._class);
        }
        for (String string : this._appargs) {
            args.add(this.processArg(string));
        }
        String[] envp = this.createEnvironment();
        Object[] sargs = args.toArray(new String[args.size()]);
        Log.log.info((Object)("Running " + StringUtil.join((Object[])sargs, (String)"\n  ")), new Object[0]);
        return Runtime.getRuntime().exec((String[])sargs, envp, this._appdir);
    }

    protected String[] createEnvironment() {
        ArrayList<String> envvar = new ArrayList<String>();
        this.fillAssignmentListFromPairs("env.txt", envvar);
        if (envvar.isEmpty()) {
            Log.log.info((Object)"Didn't find any custom environment variables, not setting any.", new Object[0]);
            return null;
        }
        ArrayList<String> envAssignments = new ArrayList<String>();
        for (String string : envvar) {
            envAssignments.add(this.processArg(string));
        }
        for (Map.Entry entry : System.getenv().entrySet()) {
            envAssignments.add((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        Object[] envp = envAssignments.toArray(new String[envAssignments.size()]);
        Log.log.info((Object)("Environment " + StringUtil.join((Object[])envp, (String)"\n ")), new Object[0]);
        return envp;
    }

    /*
     * WARNING - void declaration
     */
    public void invokeDirect(JApplet applet) throws IOException {
        void var7_15;
        void var7_10;
        ClassPath classPath = ClassPaths.buildClassPath(this);
        URL[] jarUrls = classPath.asUrls();
        URLClassLoader loader = new URLClassLoader(jarUrls, ClassLoader.getSystemClassLoader()){

            protected PermissionCollection getPermissions(CodeSource code) {
                Permissions perms = new Permissions();
                perms.add(new AllPermission());
                return perms;
            }
        };
        Thread.currentThread().setContextClassLoader(loader);
        Log.log.info((Object)"Configured URL class loader:", new Object[0]);
        URL[] uRLArray = jarUrls;
        int n = uRLArray.length;
        boolean bl = false;
        while (var7_10 < n) {
            URL url = uRLArray[var7_10];
            Log.log.info((Object)("  " + url), new Object[0]);
            ++var7_10;
        }
        for (String jvmarg : this._jvmargs) {
            if (!jvmarg.startsWith("-D")) continue;
            int n2 = (jvmarg = this.processArg(jvmarg.substring(2))).indexOf("=");
            if (n2 == -1) {
                Log.log.warning((Object)("Bogus system property: '" + jvmarg + "'?"), new Object[0]);
                continue;
            }
            System.setProperty(jvmarg.substring(0, n2), jvmarg.substring(n2 + 1));
        }
        HashMap<String, String> passProps = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(PROP_PASSTHROUGH_PREFIX)) continue;
            key = key.substring(PROP_PASSTHROUGH_PREFIX.length());
            passProps.put(key, (String)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : passProps.entrySet()) {
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        System.setProperty("applet", "true");
        Object[] args = new String[this._appargs.size()];
        boolean bl2 = false;
        while (var7_15 < args.length) {
            args[var7_15] = this.processArg(this._appargs.get((int)var7_15));
            ++var7_15;
        }
        try {
            Method main;
            Log.log.info((Object)("Loading " + this._class), new Object[0]);
            Class<?> clazz = loader.loadClass(this._class);
            try {
                main = clazz.getMethod("main", JApplet.class, SA_PROTO.getClass());
                Log.log.info((Object)("Invoking main(JApplet, {" + StringUtil.join((Object[])args, (String)", ") + "})"), new Object[0]);
                main.invoke(null, applet, args);
            }
            catch (NoSuchMethodException nsme) {
                main = clazz.getMethod("main", SA_PROTO.getClass());
                Log.log.info((Object)("Invoking main({" + StringUtil.join((Object[])args, (String)", ") + "})"), new Object[0]);
                main.invoke(null, new Object[]{args});
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    protected String processArg(String arg) {
        arg = arg.replace("%APPDIR%", this._appdir.getAbsolutePath());
        if ((arg = arg.replace("%VERSION%", String.valueOf(this._version))).contains(ENV_VAR_PREFIX)) {
            StringBuffer sb = new StringBuffer();
            Matcher matcher = ENV_VAR_PATTERN.matcher(arg);
            while (matcher.find()) {
                String varName = matcher.group(1);
                String varValue = System.getenv(varName);
                if (varName == null) {
                    varName = "MISSING:" + varName;
                }
                matcher.appendReplacement(sb, varValue);
            }
            matcher.appendTail(sb);
            arg = sb.toString();
        }
        return arg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyMetadata(StatusDisplay status) throws IOException {
        Resource crsrc;
        Log.log.info((Object)("Verifying application: " + this._vappbase), new Object[0]);
        Log.log.info((Object)("Version: " + this._version), new Object[0]);
        Log.log.info((Object)("Class: " + this._class), new Object[0]);
        try {
            this._digest = new Digest(this._appdir);
        }
        catch (IOException ioe) {
            Log.log.info((Object)("Failed to load digest: " + ioe.getMessage() + ". Attempting recovery..."), new Object[0]);
        }
        if (this._version == -1L) {
            String olddig = this._digest == null ? "" : this._digest.getMetaDigest();
            try {
                status.updateStatus("m.checking");
                this.downloadDigestFile();
                this._digest = new Digest(this._appdir);
                if (!olddig.equals(this._digest.getMetaDigest())) {
                    Log.log.info((Object)"Unversioned digest changed. Revalidating...", new Object[0]);
                    status.updateStatus("m.validating");
                    this.clearValidationMarkers();
                }
            }
            catch (IOException ioe) {
                Log.log.warning((Object)("Failed to refresh non-versioned digest: " + ioe.getMessage() + ". Proceeding..."), new Object[0]);
            }
        }
        if (this._digest == null) {
            status.updateStatus("m.updating_metadata");
            this.downloadDigestFile();
            this._digest = new Digest(this._appdir);
        }
        if (!this._digest.validateResource(crsrc = this.getConfigResource(), null)) {
            status.updateStatus("m.updating_metadata");
            this.downloadConfigFile();
            this.downloadDigestFile();
            this._digest = new Digest(this._appdir);
            this.clearValidationMarkers();
            if (this._digest.validateResource(crsrc, null)) {
                this.init(true);
            } else {
                Log.log.warning((Object)"getdown.txt failed to validate even after redownloading. Blindly forging onward.", new Object[0]);
            }
        }
        this._targetVersion = this._version;
        if (this._version != -1L) {
            File vfile = this.getLocalPath(VERSION_FILE);
            long fileVersion = VersionUtil.readVersion(vfile);
            if (fileVersion != -1L) {
                this._targetVersion = fileVersion;
            }
            if (this._latest != null) {
                InputStream in = null;
                PrintStream out = null;
                try {
                    in = ConnectionUtil.open(this._latest).getInputStream();
                    BufferedReader bin = new BufferedReader(new InputStreamReader(in));
                    for (String[] pair : ConfigUtil.parsePairs(bin, false)) {
                        if (!pair[0].equals("version")) continue;
                        this._targetVersion = Math.max(Long.parseLong(pair[1]), this._targetVersion);
                        if (fileVersion == -1L || this._targetVersion <= fileVersion) break;
                        out = new PrintStream(new FileOutputStream(vfile));
                        out.println(this._targetVersion);
                        break;
                    }
                }
                catch (Exception e) {
                    try {
                        Log.log.warning((Object)"Unable to retrieve version from latest config file.", new Object[]{e});
                    }
                    catch (Throwable throwable) {
                        StreamUtil.close(in);
                        StreamUtil.close(out);
                        throw throwable;
                    }
                    StreamUtil.close((InputStream)in);
                    StreamUtil.close(out);
                }
                StreamUtil.close((InputStream)in);
                StreamUtil.close(out);
            }
        }
        return this._version != this._targetVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Resource> verifyResources(ProgressObserver obs, int[] alreadyValid, Set<Resource> unpacked) throws InterruptedException {
        List<Resource> rsrcs = this.getAllActiveResources();
        ArrayList<Resource> failures = new ArrayList<Resource>();
        long[] sizes = new long[rsrcs.size()];
        for (int ii = 0; ii < sizes.length; ++ii) {
            sizes[ii] = rsrcs.get(ii).getLocal().length();
        }
        ProgressAggregator pagg = new ProgressAggregator(obs, sizes);
        boolean noUnpack = SysProps.noUnpack();
        for (int ii = 0; ii < sizes.length; ++ii) {
            Resource rsrc = rsrcs.get(ii);
            if (Thread.interrupted()) {
                throw new InterruptedException("m.applet_stopped");
            }
            ProgressObserver robs = pagg.startElement(ii);
            if (rsrc.isMarkedValid()) {
                if (alreadyValid != null) {
                    alreadyValid[0] = alreadyValid[0] + 1;
                }
                robs.progress(100);
                continue;
            }
            try {
                if (this._digest.validateResource(rsrc, robs)) {
                    if (noUnpack || !rsrc.shouldUnpack()) {
                        rsrc.markAsValid();
                        continue;
                    }
                    if (rsrc.unpack()) {
                        unpacked.add(rsrc);
                        rsrc.markAsValid();
                        continue;
                    }
                    Log.log.info((Object)"Failure unpacking resource", new Object[]{"rsrc", rsrc});
                }
            }
            catch (Exception e) {
                Log.log.info((Object)"Failure validating resource. Requesting redownload...", new Object[]{"rsrc", rsrc, "error", e});
            }
            finally {
                robs.progress(100);
            }
            failures.add(rsrc);
        }
        return failures.size() == 0 ? null : failures;
    }

    public void unpackResources(ProgressObserver obs, Set<Resource> unpacked) throws InterruptedException {
        List<Resource> rsrcs = this.getActiveResources();
        Iterator<Resource> it = rsrcs.iterator();
        while (it.hasNext()) {
            Resource rsrc = it.next();
            if (rsrc.shouldUnpack() && !unpacked.contains(rsrc)) continue;
            it.remove();
        }
        long[] sizes = new long[rsrcs.size()];
        for (int ii = 0; ii < sizes.length; ++ii) {
            sizes[ii] = rsrcs.get(ii).getLocal().length();
        }
        ProgressAggregator pagg = new ProgressAggregator(obs, sizes);
        for (int ii = 0; ii < sizes.length; ++ii) {
            if (Thread.interrupted()) {
                throw new InterruptedException("m.applet_stopped");
            }
            Resource rsrc = rsrcs.get(ii);
            ProgressObserver pobs = pagg.startElement(ii);
            if (!rsrc.unpack()) {
                Log.log.info((Object)"Failure unpacking resource", new Object[]{"rsrc", rsrc});
            }
            pobs.progress(100);
        }
    }

    public void clearValidationMarkers() {
        this.clearValidationMarkers(this.getAllActiveResources().iterator());
    }

    public long getVersion() {
        return this._version;
    }

    protected URL createVAppBase(long version) throws MalformedURLException {
        return new URL(this._appbase.replace("%VERSION%", "" + version));
    }

    protected void clearValidationMarkers(Iterator<Resource> iter) {
        while (iter.hasNext()) {
            iter.next().clearMarker();
        }
    }

    protected void downloadConfigFile() throws IOException {
        this.downloadControlFile(CONFIG_FILE, false);
    }

    public synchronized boolean lockForUpdates() {
        if (this._lock != null && this._lock.isValid()) {
            return true;
        }
        try {
            this._lockChannel = new RandomAccessFile(this.getLocalPath("gettingdown.lock"), "rw").getChannel();
        }
        catch (FileNotFoundException e) {
            Log.log.warning((Object)"Unable to create lock file", new Object[]{"message", e.getMessage(), e});
            return false;
        }
        try {
            this._lock = this._lockChannel.tryLock();
        }
        catch (IOException e) {
            Log.log.warning((Object)"Unable to create lock", new Object[]{"message", e.getMessage(), e});
            return false;
        }
        catch (OverlappingFileLockException e) {
            Log.log.warning((Object)"The lock is held elsewhere in this JVM", new Object[]{e});
            return false;
        }
        Log.log.info((Object)("Able to lock for updates: " + (this._lock != null)), new Object[0]);
        return this._lock != null;
    }

    public synchronized void releaseLock() {
        if (this._lock != null) {
            Log.log.info((Object)"Releasing lock", new Object[0]);
            try {
                this._lock.release();
            }
            catch (IOException e) {
                Log.log.warning((Object)"Unable to release lock", new Object[]{"message", e.getMessage(), e});
            }
            try {
                this._lockChannel.close();
            }
            catch (IOException e) {
                Log.log.warning((Object)"Unable to close lock channel", new Object[]{"message", e.getMessage(), e});
            }
            this._lockChannel = null;
            this._lock = null;
        }
    }

    protected void downloadDigestFile() throws IOException {
        this.downloadControlFile("digest.txt", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void downloadControlFile(String path, boolean validateSignature) throws IOException {
        File original;
        File target;
        block14: {
            block15: {
                target = this.downloadFile(path);
                if (!validateSignature) break block14;
                if (!this._signers.isEmpty()) break block15;
                Log.log.info((Object)"No signers, not verifying file", new Object[]{"path", path});
                break block14;
            }
            File signatureFile = this.downloadFile(path + SIGNATURE_SUFFIX);
            byte[] signature = null;
            FileReader reader = null;
            try {
                reader = new FileReader(signatureFile);
                signature = StreamUtil.toByteArray((InputStream)new FileInputStream(signatureFile));
            }
            catch (Throwable throwable) {
                StreamUtil.close(reader);
                signatureFile.delete();
                throw throwable;
            }
            StreamUtil.close((Reader)reader);
            signatureFile.delete();
            byte[] buffer = new byte[8192];
            int validated = 0;
            for (Certificate cert : this._signers) {
                FileInputStream dataInput;
                block13: {
                    int length;
                    dataInput = null;
                    dataInput = new FileInputStream(target);
                    Signature sig = Signature.getInstance("SHA1withRSA");
                    sig.initVerify(cert);
                    while ((length = dataInput.read(buffer)) != -1) {
                        sig.update(buffer, 0, length);
                    }
                    if (sig.verify(Base64.decodeBase64((byte[])signature))) break block13;
                    Log.log.info((Object)"Signature does not match", new Object[]{"cert", cert.getPublicKey()});
                    StreamUtil.close((InputStream)dataInput);
                    dataInput = null;
                    continue;
                }
                try {
                    Log.log.info((Object)"Signature matches", new Object[]{"cert", cert.getPublicKey()});
                    ++validated;
                }
                catch (IOException ioe) {
                    Log.log.warning((Object)("Failure validating signature of " + target + ": " + ioe), new Object[0]);
                    StreamUtil.close((InputStream)dataInput);
                    dataInput = null;
                    continue;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    StreamUtil.close((InputStream)dataInput);
                    dataInput = null;
                    continue;
                    {
                        catch (Throwable throwable) {
                            StreamUtil.close(dataInput);
                            dataInput = null;
                            throw throwable;
                        }
                    }
                }
                StreamUtil.close((InputStream)dataInput);
                dataInput = null;
            }
            if (validated == 0) {
                target.delete();
                throw new IOException("m.corrupt_digest_signature_error");
            }
        }
        if (!FileUtil.renameTo(target, original = this.getLocalPath(path))) {
            throw new IOException("Failed to rename(" + target + ", " + original + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File downloadFile(String path) throws IOException {
        File target = this.getLocalPath(path + "_new");
        URL targetURL = null;
        try {
            targetURL = this.getRemoteURL(path);
        }
        catch (Exception e) {
            Log.log.warning((Object)"Requested to download invalid control file", new Object[]{"appbase", this._vappbase, "path", path, "error", e});
            throw (IOException)new IOException("Invalid path '" + path + "'.").initCause(e);
        }
        Log.log.info((Object)("Attempting to refetch '" + path + "' from '" + targetURL + "'."), new Object[0]);
        InputStream fin = null;
        FileOutputStream fout = null;
        try {
            URLConnection uconn = ConnectionUtil.open(targetURL);
            uconn.setUseCaches(false);
            int ctimeout = SysProps.connectTimeout();
            if (ctimeout > 0) {
                uconn.setConnectTimeout(ctimeout * 1000);
            }
            fin = uconn.getInputStream();
            fout = new FileOutputStream(target);
            StreamUtil.copy((InputStream)fin, (OutputStream)fout);
        }
        catch (Throwable throwable) {
            StreamUtil.close(fin);
            StreamUtil.close(fout);
            throw throwable;
        }
        StreamUtil.close((InputStream)fin);
        StreamUtil.close((OutputStream)fout);
        return target;
    }

    protected Resource createResource(String path, boolean unpack) throws MalformedURLException {
        return new Resource(path, this.getRemoteURL(path), this.getLocalPath(path), unpack);
    }

    protected void parseResources(Map<String, Object> cdata, String name, boolean unpack, List<Resource> list) {
        String[] rsrcs = ConfigUtil.getMultiValue(cdata, name);
        if (rsrcs == null) {
            return;
        }
        for (String rsrc : rsrcs) {
            try {
                list.add(this.createResource(rsrc, unpack));
            }
            catch (Exception e) {
                Log.log.warning((Object)("Invalid resource '" + rsrc + "'. " + e), new Object[0]);
            }
        }
    }

    protected Rectangle parseRect(Map<String, Object> cdata, String name, Rectangle def) {
        String value = (String)cdata.get(name);
        Rectangle rect = Application.parseRect(name, value);
        return rect == null ? def : rect;
    }

    protected static void addAll(String[] values, List<String> target) {
        if (values != null) {
            for (String value : values) {
                target.add(value);
            }
        }
    }

    public static List<Integer> intsToList(int[] values) {
        ArrayList<Integer> list = new ArrayList<Integer>(values.length);
        for (int val : values) {
            list.add(val);
        }
        return Collections.unmodifiableList(list);
    }

    public static Rectangle parseRect(String name, String value) {
        if (!StringUtil.isBlank((String)value)) {
            int[] v = StringUtil.parseIntArray((String)value);
            if (v != null && v.length == 4) {
                return new Rectangle(v[0], v[1], v[2], v[3]);
            }
            Log.log.warning((Object)("Ignoring invalid '" + name + "' config '" + value + "'."), new Object[0]);
        }
        return null;
    }

    protected Color parseColor(Map<String, Object> cdata, String name, Color def) {
        String value = (String)cdata.get(name);
        Color color = Application.parseColor(value);
        return color == null ? def : color;
    }

    public static Color parseColor(String hexValue) {
        if (!StringUtil.isBlank((String)hexValue)) {
            try {
                return new Color(Integer.parseInt(hexValue, 16));
            }
            catch (NumberFormatException e) {
                Log.log.warning((Object)"Ignoring invalid color", new Object[]{"hexValue", hexValue, "exception", e});
            }
        }
        return null;
    }

    protected String[] parseList(Map<String, Object> cdata, String name) {
        String value = (String)cdata.get(name);
        return value == null ? ArrayUtil.EMPTY_STRING : StringUtil.parseStringArray((String)value);
    }

    protected String parseUrl(Map<String, Object> cdata, String name, String def) {
        String value = (String)cdata.get(name + "." + Locale.getDefault().getLanguage());
        if (!StringUtil.isBlank((String)value)) {
            return value;
        }
        value = (String)cdata.get(name);
        return StringUtil.isBlank((String)value) ? def : value;
    }

    protected String getGATrackingCode() {
        if (this._trackingGAHash == null) {
            return "";
        }
        long time = System.currentTimeMillis() / 1000L;
        if (this._trackingStart == 0L) {
            this._trackingStart = time;
        }
        if (this._trackingId == 0) {
            this._trackingId = RandomUtil.getInRange((int)100000000, (int)1000000000);
        }
        StringBuilder cookie = new StringBuilder("&utmcc=__utma%3D").append(this._trackingGAHash);
        cookie.append(".").append(this._trackingId);
        cookie.append(".").append(this._trackingStart).append(".").append(this._trackingStart);
        cookie.append(".").append(time).append(".1%3B%2B");
        cookie.append("__utmz%3D").append(this._trackingGAHash).append(".");
        cookie.append(this._trackingStart).append(".1.1.");
        cookie.append("utmcsr%3D(direct)%7Cutmccn%3D(direct)%7Cutmcmd%3D(none)%3B");
        cookie.append("&utmn=").append(RandomUtil.getInRange((int)1000000000, (int)2000000000));
        return cookie.toString();
    }

    protected String replaceDomain(String appbase) {
        String appbaseDomain = SysProps.appbaseDomain();
        if (appbaseDomain != null) {
            Matcher m = Pattern.compile("(http://[^/]+)(.*)").matcher(appbase);
            appbase = m.replaceAll(appbaseDomain + "$2");
        }
        return appbase;
    }

    protected static String encodePath(String path) {
        return path.replace(" ", "%20");
    }

    protected static long parseLong(String value, String errkey) throws IOException {
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            String err = MessageUtil.tcompose((String)errkey, (String[])new String[]{value});
            throw (IOException)new IOException(err).initCause(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AuxGroup {
        public final String name;
        public final List<Resource> codes;
        public final List<Resource> rsrcs;

        public AuxGroup(String name, List<Resource> codes, List<Resource> rsrcs) {
            this.name = name;
            this.codes = Collections.unmodifiableList(codes);
            this.rsrcs = Collections.unmodifiableList(rsrcs);
        }
    }

    public static interface StatusDisplay {
        public void updateStatus(String var1);
    }

    public static class UpdateInterface {
        public String name;
        public Color background = Color.white;
        public String[] rotatingBackgrounds;
        public String errorBackground;
        public String[] iconImages;
        public String backgroundImage;
        public String progressImage;
        public Rectangle progress = new Rectangle(5, 5, 300, 15);
        public Color progressText = Color.black;
        public Color progressBar = new Color(0x6699CC);
        public Rectangle status = new Rectangle(5, 25, 500, 100);
        public Color statusText = Color.black;
        public Color textShadow;
        public String installError;
        public Rectangle patchNotes = new Rectangle(5, 50, 112, 26);
        public String patchNotesUrl;
        public Rectangle playAgain;
        public String playAgainImage;
        public boolean hideDecorations;
        public boolean hideProgressText;
        public Map<Step, List<Integer>> stepPercentages = new EnumMap<Step, List<Integer>>(Step.class);

        public UpdateInterface() {
            for (Step step : Step.values()) {
                this.stepPercentages.put(step, step.defaultPercents);
            }
        }

        public String toString() {
            return "[name=" + this.name + ", bg=" + this.background + ", bg=" + this.backgroundImage + ", pi=" + this.progressImage + ", prect=" + this.progress + ", pt=" + this.progressText + ", pb=" + this.progressBar + ", srect=" + this.status + ", st=" + this.statusText + ", shadow=" + this.textShadow + ", err=" + this.installError + ", nrect=" + this.patchNotes + ", notes=" + this.patchNotesUrl + ", stepPercentages=" + this.stepPercentages + ", parect=" + this.playAgain + ", paimage=" + this.playAgainImage + ", hideProgressText" + this.hideProgressText + "]";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Step {
            UPDATE_JAVA(10),
            VERIFY_METADATA(15, 65, 95),
            DOWNLOAD(40),
            PATCH(60),
            VERIFY_RESOURCES(70, 97),
            REDOWNLOAD_RESOURCES(90),
            UNPACK(98),
            LAUNCH(99);

            public final List<Integer> defaultPercents;

            private Step(int ... percents) {
                this.defaultPercents = Application.intsToList(percents);
            }
        }
    }
}

