/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.samskivert.io.StreamUtil;
import com.samskivert.text.MessageUtil;
import com.samskivert.util.StringUtil;
import com.threerings.getdown.Log;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.util.ConfigUtil;
import com.threerings.getdown.util.ProgressObserver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Digest {
    public static final String DIGEST_FILE = "digest.txt";
    protected HashMap<String, String> _digests = new HashMap();
    protected String _metaDigest = "";

    public Digest(File appdir) throws IOException {
        byte[] contents;
        MessageDigest md;
        String md5;
        StringBuilder data = new StringBuilder();
        File dfile = new File(appdir, DIGEST_FILE);
        for (String[] pair : ConfigUtil.parsePairs(dfile, false)) {
            if (pair[0].equals(DIGEST_FILE)) {
                this._metaDigest = pair[1];
                break;
            }
            this._digests.put(pair[0], pair[1]);
            Digest.note(data, pair[0], pair[1]);
        }
        if (!(md5 = StringUtil.hexlate((byte[])(md = Digest.getMessageDigest()).digest(contents = data.toString().getBytes("UTF-8")))).equals(this._metaDigest)) {
            String err = MessageUtil.tcompose((String)"m.invalid_digest_file", (String[])new String[]{this._metaDigest, md5});
            throw new IOException(err);
        }
    }

    public String getMetaDigest() {
        return this._metaDigest;
    }

    public boolean validateResource(Resource resource, ProgressObserver obs) {
        try {
            String cmd5 = resource.computeDigest(Digest.getMessageDigest(), obs);
            String emd5 = this._digests.get(resource.getPath());
            if (cmd5.equals(emd5)) {
                return true;
            }
            Log.log.info((Object)"Resource failed digest check", new Object[]{"rsrc", resource, "computed", cmd5, "expected", emd5});
        }
        catch (Throwable t) {
            Log.log.info((Object)"Resource failed digest check", new Object[]{"rsrc", resource, "error", t});
        }
        return false;
    }

    public String getDigest(Resource resource) {
        return this._digests.get(resource.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDigest(List<Resource> resources, File output) throws IOException {
        MessageDigest md = Digest.getMessageDigest();
        StringBuilder data = new StringBuilder();
        PrintWriter pout = null;
        try {
            pout = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), "UTF-8"));
            for (Resource rsrc : resources) {
                String path = rsrc.getPath();
                try {
                    String digest = rsrc.computeDigest(md, null);
                    Digest.note(data, path, digest);
                    pout.println(path + " = " + digest);
                }
                catch (Throwable t) {
                    throw (IOException)new IOException("Error computing digest for: " + rsrc).initCause(t);
                }
            }
            md.reset();
            byte[] contents = data.toString().getBytes("UTF-8");
            pout.println("digest.txt = " + StringUtil.hexlate((byte[])md.digest(contents)));
        }
        catch (Throwable throwable) {
            StreamUtil.close(pout);
            throw throwable;
        }
        StreamUtil.close((Writer)pout);
    }

    public static MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("JVM does not support MD5. Gurp!");
        }
    }

    protected static void note(StringBuilder data, String path, String digest) {
        data.append(path).append(" = ").append(digest).append("\n");
    }
}

