/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.samskivert.io.StreamUtil;
import com.samskivert.util.StringUtil;
import com.threerings.getdown.Log;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.ProgressObserver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Resource {
    protected String _path;
    protected URL _remote;
    protected File _local;
    protected File _local_new;
    protected File _marker;
    protected File _unpacked;
    protected boolean _unpack;
    protected boolean _isJar;
    protected boolean _isPacked200Jar;
    protected static final Comparator<JarEntry> ENTRY_COMP = new Comparator<JarEntry>(){

        @Override
        public int compare(JarEntry e1, JarEntry e2) {
            return e1.getName().compareTo(e2.getName());
        }
    };
    protected static final int DIGEST_BUFFER_SIZE = 5125;

    public Resource(String path, URL remote, File local, boolean unpack) {
        this._path = path;
        this._remote = remote;
        this._local = local;
        this._local_new = new File(local.toString() + "_new");
        String lpath = this._local.getPath();
        this._marker = new File(lpath + "v");
        this._unpack = unpack;
        this._isJar = Resource.isJar(lpath);
        this._isPacked200Jar = Resource.isPacked200Jar(lpath);
        if (this._unpack && this._isJar) {
            this._unpacked = this._local.getParentFile();
        } else if (this._unpack && this._isPacked200Jar) {
            String dotJar = ".jar";
            String lname = this._local.getName();
            String uname = lname.substring(0, lname.lastIndexOf(dotJar) + dotJar.length());
            this._unpacked = new File(this._local.getParent(), uname);
        }
    }

    public String getPath() {
        return this._path;
    }

    public File getLocal() {
        return this._local;
    }

    public File getLocalNew() {
        return this._local_new;
    }

    public File getUnpacked() {
        return this._unpacked;
    }

    public File getFinalTarget() {
        return this.shouldUnpack() ? this.getUnpacked() : this.getLocal();
    }

    public URL getRemote() {
        return this._remote;
    }

    public boolean shouldUnpack() {
        return this._unpack;
    }

    public String computeDigest(MessageDigest md, ProgressObserver obs) throws IOException {
        File file = this._local.toString().toLowerCase().endsWith("getdown.txt") ? this._local : (this._local_new.exists() ? this._local_new : this._local);
        return Resource.computeDigest(file, md, obs);
    }

    public boolean isMarkedValid() {
        if (!this._local.exists()) {
            this.clearMarker();
            return false;
        }
        return this._marker.exists();
    }

    public void markAsValid() throws IOException {
        this._marker.createNewFile();
    }

    public void clearMarker() {
        if (this._marker.exists() && !this._marker.delete()) {
            Log.log.warning((Object)("Failed to erase marker file '" + this._marker + "'."), new Object[0]);
        }
    }

    public boolean unpack() {
        if (!this._isJar && !this._isPacked200Jar) {
            Log.log.warning((Object)("Requested to unpack non-jar file '" + this._local + "'."), new Object[0]);
            return false;
        }
        try {
            if (this._isJar) {
                return FileUtil.unpackJar((JarFile)new JarFile(this._local), (File)this._unpacked);
            }
            return FileUtil.unpackPacked200Jar(this._local, this._unpacked);
        }
        catch (IOException ioe) {
            Log.log.warning((Object)("Failed to create JarFile from '" + this._local + "': " + ioe), new Object[0]);
            return false;
        }
    }

    public void erase() {
        this.clearMarker();
        if (this._local.exists() && !this._local.delete()) {
            Log.log.warning((Object)("Failed to erase resource '" + this._local + "'."), new Object[0]);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof Resource) {
            return this._path.equals(((Resource)other)._path);
        }
        return false;
    }

    public int hashCode() {
        return this._path.hashCode();
    }

    public String toString() {
        return this._path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String computeDigest(File target, MessageDigest md, ProgressObserver obs) throws IOException {
        block23: {
            byte[] buffer;
            block22: {
                File tmpJarFile;
                block21: {
                    md.reset();
                    buffer = new byte[5125];
                    boolean isJar = Resource.isJar(target.getPath());
                    boolean isPacked200Jar = Resource.isPacked200Jar(target.getPath());
                    if (!isJar && !isPacked200Jar) break block22;
                    tmpJarFile = null;
                    JarFile jar = null;
                    try {
                        if (isPacked200Jar) {
                            tmpJarFile = new File(target.getPath() + ".tmp");
                            FileUtil.unpackPacked200Jar(target, tmpJarFile);
                            jar = new JarFile(tmpJarFile);
                        } else {
                            jar = new JarFile(target);
                        }
                        ArrayList<JarEntry> entries = Collections.list(jar.entries());
                        Collections.sort(entries, ENTRY_COMP);
                        int eidx = 0;
                        for (JarEntry entry : entries) {
                            if (entry.getName().startsWith("META-INF")) {
                                Resource.updateProgress(obs, eidx, entries.size());
                                continue;
                            }
                            InputStream in = null;
                            try {
                                int read;
                                in = jar.getInputStream(entry);
                                while ((read = in.read(buffer)) != -1) {
                                    md.update(buffer, 0, read);
                                }
                            }
                            finally {
                                StreamUtil.close((InputStream)in);
                            }
                            Resource.updateProgress(obs, eidx, entries.size());
                        }
                        if (jar == null) break block21;
                    }
                    catch (Throwable throwable) {
                        if (jar != null) {
                            try {
                                jar.close();
                            }
                            catch (IOException ioe) {
                                Log.log.warning((Object)"Error closing jar", new Object[]{"path", target, "jar", jar, "error", ioe});
                            }
                        }
                        if (tmpJarFile != null) {
                            tmpJarFile.delete();
                        }
                        throw throwable;
                    }
                    try {
                        jar.close();
                    }
                    catch (IOException ioe) {
                        Log.log.warning((Object)"Error closing jar", new Object[]{"path", target, "jar", jar, "error", ioe});
                    }
                }
                if (tmpJarFile != null) {
                    tmpJarFile.delete();
                }
                break block23;
            }
            long totalSize = target.length();
            long position = 0L;
            FileInputStream fin = null;
            try {
                int read;
                fin = new FileInputStream(target);
                while ((read = fin.read(buffer)) != -1) {
                    md.update(buffer, 0, read);
                    Resource.updateProgress(obs, position += (long)read, totalSize);
                }
            }
            catch (Throwable throwable) {
                StreamUtil.close(fin);
                throw throwable;
            }
            StreamUtil.close((InputStream)fin);
        }
        return StringUtil.hexlate((byte[])md.digest());
    }

    protected static void updateProgress(ProgressObserver obs, long pos, long total) {
        if (obs != null) {
            obs.progress((int)(100L * pos / total));
        }
    }

    protected static boolean isJar(String path) {
        return path.endsWith(".jar") || path.endsWith(".jar_new");
    }

    protected static boolean isPacked200Jar(String path) {
        return path.endsWith(".jar.pack") || path.endsWith(".jar.pack.gz");
    }
}

