/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.threerings.getdown.util.VersionUtil;

public class SysProps {
    public static String appDir() {
        return System.getProperty("appdir");
    }

    public static String appId() {
        return System.getProperty("appid");
    }

    public static String appBase() {
        return System.getProperty("appbase");
    }

    public static boolean noLogRedir() {
        return System.getProperty("no_log_redir") != null;
    }

    public static String appbaseDomain() {
        return System.getProperty("appbase_domain");
    }

    public static boolean silent() {
        return System.getProperty("silent") != null;
    }

    public static boolean install() {
        return System.getProperty("no_install") == null;
    }

    public static boolean launchInSilent() {
        return "launch".equals(System.getProperty("silent"));
    }

    public static int startDelay() {
        return Integer.getInteger("delay", 0);
    }

    public static boolean noUnpack() {
        return Boolean.getBoolean("no_unpack");
    }

    public static boolean direct() {
        return Boolean.getBoolean("direct");
    }

    public static int connectTimeout() {
        return Integer.getInteger("connect_timeout", 0);
    }

    public static long parseJavaVersion(String propName, String propRegex) {
        String verstr = System.getProperty(propName);
        if (verstr == null) {
            throw new IllegalArgumentException("No system property '" + propName + "'.");
        }
        long vers = VersionUtil.parseJavaVersion(propRegex, verstr);
        if (vers == 0L) {
            throw new IllegalArgumentException("Regexp '" + propRegex + "' does not match '" + verstr + "' (from " + propName + ")");
        }
        return vers;
    }
}

