/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.Spacer;
import com.samskivert.swing.VGroupLayout;
import com.samskivert.text.MessageUtil;
import com.threerings.getdown.Log;
import com.threerings.getdown.launcher.Getdown;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AbortPanel
extends JFrame
implements ActionListener {
    protected Getdown _getdown;
    protected ResourceBundle _msgs;

    public AbortPanel(Getdown getdown, ResourceBundle msgs) {
        this._getdown = getdown;
        this._msgs = msgs;
        this.setLayout((LayoutManager)new VGroupLayout());
        this.setResizable(false);
        this.setTitle(this.get("m.abort_title"));
        JLabel message = new JLabel(this.get("m.abort_confirm"));
        message.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(message);
        this.add((Component)new Spacer(5, 5));
        JPanel row = GroupLayout.makeButtonBox((GroupLayout.Justification)GroupLayout.CENTER, (Component[])new Component[0]);
        JButton button = new JButton(this.get("m.abort_ok"));
        row.add(button);
        button.setActionCommand("ok");
        button.addActionListener(this);
        button = new JButton(this.get("m.abort_cancel"));
        row.add(button);
        button.setActionCommand("cancel");
        button.addActionListener(this);
        this.getRootPane().setDefaultButton(button);
        this.add(row);
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 200);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("ok")) {
            System.exit(0);
        } else {
            this.setVisible(false);
        }
    }

    protected String get(String key) {
        if (MessageUtil.isTainted((String)key)) {
            return MessageUtil.untaint((String)key);
        }
        try {
            return this._msgs.getString(key);
        }
        catch (MissingResourceException mre) {
            Log.log.warning((Object)("Missing translation message '" + key + "'."), new Object[0]);
            return key;
        }
    }
}

